/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.mcrl2;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.external.AbstractFileBasedValidator;
import org.eclipse.emf.henshin.statespace.util.StateSpaceProperties;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class MCRL2StateSpaceValidator
extends AbstractFileBasedValidator {
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        String line;
        monitor.beginTask("Validating property...", 10);
        String name = stateSpace.eResource().getURI().trimFileExtension().lastSegment();
        File aut = this.exportAsAUT(stateSpace, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
        if (monitor.isCanceled()) {
            return null;
        }
        File min = File.createTempFile(name, ".aut");
        this.convertFile(aut, min, (IProgressMonitor)new SubProgressMonitor(monitor, 1), "ltsconvert", "--equivalence=bisim");
        if (monitor.isCanceled()) {
            return null;
        }
        String actions = this.createActions(stateSpace);
        System.out.println(String.valueOf(actions) + "\n");
        File act = this.createTempFile(name, ".mcrl2", actions);
        File lps = File.createTempFile(name, ".lps");
        this.convertFile(min, lps, (IProgressMonitor)new SubProgressMonitor(monitor, 1), "lts2lps", "--data=" + act.getAbsolutePath());
        if (monitor.isCanceled()) {
            return null;
        }
        File mcl = this.createTempFile("property", ".mcl", this.property);
        File pbes = File.createTempFile(name, ".pbes");
        this.convertFile(lps, pbes, (IProgressMonitor)new SubProgressMonitor(monitor, 2), "lps2pbes", "--formula=" + mcl.getAbsolutePath());
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.subTask("Running pbes2bool...");
        String[] pbes2bool = new String[]{"pbes2bool", pbes.getAbsolutePath()};
        if (System.getProperty("os.name").startsWith("Linux")) {
            pbes2bool = new String[]{"bash", "-c", "ulimit -s unlimited; pbes2bool " + pbes.getAbsolutePath()};
        }
        Process process = Runtime.getRuntime().exec(pbes2bool);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        Boolean result = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            System.out.println("pbes2bool:" + line);
            if (line.startsWith("The solution for the initial variable of the pbes is")) {
                if (line.endsWith("true")) {
                    result = Boolean.TRUE;
                    break;
                }
                if (line.endsWith("false")) {
                    result = Boolean.FALSE;
                    break;
                }
                throw new RuntimeException("pbes2bool produced unexpected output: " + line);
            }
            if (!monitor.isCanceled()) continue;
            process.destroy();
            return null;
        }
        process.waitFor();
        monitor.worked(1);
        min.delete();
        act.delete();
        lps.delete();
        mcl.delete();
        pbes.delete();
        monitor.worked(1);
        monitor.done();
        if (result == Boolean.TRUE) {
            return ValidationResult.VALID;
        }
        if (result == Boolean.FALSE) {
            return ValidationResult.INVALID;
        }
        throw new RuntimeException("pbes2bool produced no output.");
    }

    private String createActions(StateSpace stateSpace) {
        StringBuffer actions = new StringBuffer();
        if (!stateSpace.getEqualityHelper().isIgnoreNodeIDs()) {
            Map<EClass, Integer> maxIDs = this.getMaxIDs(stateSpace);
            for (EClass type : maxIDs.keySet()) {
                actions.append("sort " + type.getName() + " = struct ");
                char prefix = type.getName().toLowerCase().charAt(0);
                int max = maxIDs.get(type);
                if (max < 0) {
                    max = 0;
                }
                int i = 0;
                while (i <= max) {
                    actions.append(String.valueOf(String.valueOf(prefix)) + i + (i < max ? " | " : ";\n"));
                    ++i;
                }
            }
        }
        actions.append("act ");
        int i = 0;
        while (i < stateSpace.getRules().size()) {
            Rule rule = (Rule)stateSpace.getRules().get(i);
            actions.append(rule.getName());
            if (!stateSpace.getEqualityHelper().isIgnoreNodeIDs()) {
                actions.append(" : ");
                List params = StateSpaceProperties.getParameters((StateSpace)stateSpace, (Rule)rule);
                int j = 0;
                while (j < params.size()) {
                    actions.append(((Node)params.get(j)).getType().getName());
                    if (j < params.size() - 1) {
                        actions.append(" # ");
                    }
                    ++j;
                }
            }
            actions.append("; ");
            ++i;
        }
        return String.valueOf(actions.toString()) + "\n";
    }

    private Map<EClass, Integer> getMaxIDs(StateSpace stateSpace) {
        HashMap paramTypes = new HashMap();
        for (Rule rule : stateSpace.getRules()) {
            List nodes = StateSpaceProperties.getParameters((StateSpace)stateSpace, (Rule)rule);
            ArrayList<EClass> types = new ArrayList<EClass>();
            for (Node node : nodes) {
                types.add(node.getType());
            }
            paramTypes.put(rule, types);
        }
        HashMap<EClass, Integer> max = new HashMap<EClass, Integer>();
        for (State state : stateSpace.getStates()) {
            for (Transition transition : state.getOutgoing()) {
                List params = (List)paramTypes.get(transition.getRule());
                int[] ids = transition.getParameterIDs();
                int count = Math.min(ids.length, params.size());
                int i = 0;
                while (i < count) {
                    EClass type = (EClass)params.get(i);
                    if (!max.containsKey(type)) {
                        max.put(type, 0);
                    }
                    if ((Integer)max.get(type) < ids[i]) {
                        max.put(type, ids[i]);
                    }
                    ++i;
                }
            }
        }
        return max;
    }

    public String getName() {
        return "mCRL2";
    }

    public boolean usesProperty() {
        return true;
    }
}

