/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.Stack;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.interpreter.util.ModelHelper;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.CountedUnit;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class UnitApplication
extends Observable {
    InterpreterEngine engine;
    TransformationUnit transformationUnit;
    Map<Parameter, Object> parameterValues;
    Map<Parameter, Object> oldParameterValues;
    Stack<RuleApplication> appliedRules;
    Stack<RuleApplication> undoneRules;
    Collection<Observer> observers;

    public UnitApplication(InterpreterEngine engine, TransformationUnit transformationUnit) {
        if (engine == null) {
            throw new IllegalArgumentException("engine can not be null");
        }
        if (transformationUnit == null) {
            throw new IllegalArgumentException("transformationUnit can not be null");
        }
        this.engine = engine;
        this.transformationUnit = transformationUnit;
        this.parameterValues = new HashMap<Parameter, Object>();
        this.oldParameterValues = new HashMap<Parameter, Object>(this.parameterValues);
        this.appliedRules = new Stack();
        this.undoneRules = new Stack();
    }

    public UnitApplication(InterpreterEngine engine, TransformationUnit transformationUnit, Map<Parameter, Object> parameterValues) {
        this.engine = engine;
        this.transformationUnit = transformationUnit;
        this.parameterValues = parameterValues;
        this.oldParameterValues = new HashMap<Parameter, Object>(parameterValues);
        this.appliedRules = new Stack();
    }

    public boolean execute() {
        switch (this.transformationUnit.eClass().getClassifierID()) {
            case 3: {
                return this.executeRule();
            }
            case 17: {
                return this.executeAmalgamatedUnit();
            }
            case 13: {
                return this.executeIndependentUnit();
            }
            case 14: {
                return this.executeSequentialUnit();
            }
            case 15: {
                return this.executeConditionalUnit();
            }
            case 16: {
                return this.executePriorityUnit();
            }
            case 18: {
                return this.executeCountedUnit();
            }
        }
        return false;
    }

    public void undo() {
        while (!this.appliedRules.isEmpty()) {
            RuleApplication ruleApplication = this.appliedRules.pop();
            ruleApplication.undo();
            this.undoneRules.push(ruleApplication);
        }
        this.parameterValues = this.oldParameterValues;
    }

    public void redo() {
        while (!this.undoneRules.isEmpty()) {
            RuleApplication ruleApplication = this.undoneRules.pop();
            ruleApplication.redo();
            this.appliedRules.push(ruleApplication);
        }
    }

    private UnitApplication createApplicationFor(TransformationUnit unit) {
        Map<Parameter, Object> childPortValues = this.createChildParameterValues(unit);
        return new UnitApplication(this.engine, unit, childPortValues);
    }

    private Map<Parameter, Object> createChildParameterValues(TransformationUnit child) {
        HashMap<Parameter, Object> childParameterValues = new HashMap<Parameter, Object>();
        for (ParameterMapping mapping : this.transformationUnit.getParameterMappings()) {
            Parameter sourceParameter = mapping.getSource();
            Parameter targetParameter = mapping.getTarget();
            if (targetParameter.getUnit() != child) continue;
            childParameterValues.put(targetParameter, this.parameterValues.get(sourceParameter));
        }
        return childParameterValues;
    }

    private void updateParameterValues(UnitApplication childUnit) {
        block0: for (ParameterMapping mapping : this.transformationUnit.getParameterMappings()) {
            Parameter sourceParameter = mapping.getSource();
            Parameter targetParameter = mapping.getTarget();
            if (sourceParameter.getUnit() != childUnit.getTransformationUnit()) continue;
            for (Parameter p : childUnit.parameterValues.keySet()) {
                if (!p.getName().equals(sourceParameter.getName())) continue;
                this.parameterValues.put(targetParameter, childUnit.parameterValues.get(p));
                continue block0;
            }
        }
    }

    private boolean executeIndependentUnit() {
        IndependentUnit independentUnit = (IndependentUnit)this.transformationUnit;
        ArrayList possibleUnits = new ArrayList(independentUnit.getSubUnits());
        while (possibleUnits.size() > 0) {
            int index = new Random().nextInt(possibleUnits.size());
            UnitApplication unitApplication = this.createApplicationFor((TransformationUnit)possibleUnits.get(index));
            if (!unitApplication.execute()) {
                possibleUnits.remove(index);
                continue;
            }
            this.updateParameterValues(unitApplication);
            if (unitApplication.appliedRules.size() > 0) {
                this.appliedRules.addAll(unitApplication.appliedRules);
            }
            return true;
        }
        return false;
    }

    private boolean executeRule() {
        Rule rule = (Rule)this.transformationUnit;
        Match match = new Match(rule, this.parameterValues, ModelHelper.createPrematch((TransformationUnit)rule, this.parameterValues));
        RuleApplication ruleApplication = new RuleApplication(this.engine, rule);
        ruleApplication.setMatch(match);
        if (ruleApplication.apply()) {
            System.out.println(rule.getName());
            this.parameterValues = ruleApplication.getComatch().getParameterValues();
            this.appliedRules.push(ruleApplication);
            return true;
        }
        return false;
    }

    private boolean executeAmalgamatedUnit() {
        AmalgamationUnit amalUnit = (AmalgamationUnit)this.transformationUnit;
        RuleApplication amalgamationRule = this.engine.generateAmalgamationRule(amalUnit, this.parameterValues);
        if (amalgamationRule != null) {
            amalgamationRule.apply();
            this.parameterValues = amalgamationRule.getComatch().getParameterValues();
            this.appliedRules.push(amalgamationRule);
            return true;
        }
        return false;
    }

    private boolean executeSequentialUnit() {
        SequentialUnit sequentialUnit = (SequentialUnit)this.transformationUnit;
        int i = 0;
        while (i < sequentialUnit.getSubUnits().size()) {
            TransformationUnit subUnit = (TransformationUnit)sequentialUnit.getSubUnits().get(i);
            UnitApplication genericUnit = this.createApplicationFor(subUnit);
            if (!genericUnit.execute()) {
                this.undo();
                return false;
            }
            this.updateParameterValues(genericUnit);
            this.appliedRules.addAll(genericUnit.appliedRules);
            ++i;
        }
        return true;
    }

    private boolean executeConditionalUnit() {
        boolean success = false;
        ConditionalUnit conditionalUnit = (ConditionalUnit)this.transformationUnit;
        TransformationUnit ifUnit = conditionalUnit.getIf();
        UnitApplication genericIfUnit = this.createApplicationFor(ifUnit);
        if (genericIfUnit.execute()) {
            this.updateParameterValues(genericIfUnit);
            this.appliedRules.addAll(genericIfUnit.appliedRules);
            TransformationUnit thenUnit = conditionalUnit.getThen();
            UnitApplication genericThenUnit = this.createApplicationFor(thenUnit);
            success = genericThenUnit.execute();
            if (success) {
                this.updateParameterValues(genericThenUnit);
            }
            this.appliedRules.addAll(genericThenUnit.appliedRules);
        } else if (conditionalUnit.getElse() != null) {
            TransformationUnit elseUnit = conditionalUnit.getElse();
            UnitApplication genericElseUnit = this.createApplicationFor(elseUnit);
            success = genericElseUnit.execute();
            if (success) {
                this.updateParameterValues(genericElseUnit);
            }
            this.appliedRules.addAll(genericElseUnit.appliedRules);
        }
        if (!success) {
            this.undo();
        }
        return success;
    }

    private boolean executePriorityUnit() {
        PriorityUnit priorityUnit = (PriorityUnit)this.transformationUnit;
        ArrayList possibleUnits = new ArrayList(priorityUnit.getSubUnits());
        while (possibleUnits.size() > 0) {
            UnitApplication genericUnit = this.createApplicationFor((TransformationUnit)possibleUnits.get(0));
            if (!genericUnit.execute()) {
                possibleUnits.remove(0);
                continue;
            }
            this.updateParameterValues(genericUnit);
            if (genericUnit.appliedRules.size() > 0) {
                this.appliedRules.addAll(genericUnit.appliedRules);
            }
            return true;
        }
        return false;
    }

    private boolean executeCountedUnit() {
        CountedUnit countedUnit = (CountedUnit)this.transformationUnit;
        int count = countedUnit.getCount();
        int i = 0;
        while (i < count || count == -1) {
            UnitApplication genericUnit = this.createApplicationFor(countedUnit.getSubUnit());
            if (!genericUnit.execute()) {
                if (count == -1) break;
                this.undo();
                return false;
            }
            this.updateParameterValues(genericUnit);
            this.appliedRules.addAll(genericUnit.appliedRules);
            ++i;
        }
        return true;
    }

    public TransformationUnit getTransformationUnit() {
        return this.transformationUnit;
    }

    public void setParameterValue(String name, Object value) {
        Parameter parameter = this.transformationUnit.getParameterByName(name);
        if (parameter != null) {
            this.parameterValues.put(parameter, value);
        }
    }

    public Object getParameterValue(String name) {
        Parameter parameter;
        if (this.parameterValues != null && (parameter = this.transformationUnit.getParameterByName(name)) != null) {
            return this.parameterValues.get(parameter);
        }
        return null;
    }

    public Map<Parameter, Object> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(Map<Parameter, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public Stack<RuleApplication> getAppliedRules() {
        return this.appliedRules;
    }

    public InterpreterEngine getInterpreterEngine() {
        return this.engine;
    }
}

