/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.internal.change.ObjectChange;

public class ModelChange {
    private Map<EObject, ObjectChange> changes;
    private Collection<EObject> createdObjects = new ArrayList<EObject>();
    private Collection<EObject> deletedObjects = new ArrayList<EObject>();

    public ModelChange() {
        this.changes = new LinkedHashMap<EObject, ObjectChange>();
        this.createdObjects = new ArrayList<EObject>();
        this.deletedObjects = new ArrayList<EObject>();
    }

    public void addCreatedObject(EObject eObject) {
        this.createdObjects.add(eObject);
    }

    public void addDeletedObject(EObject eObject) {
        this.deletedObjects.add(eObject);
    }

    public void addObjectChange(EObject eObject, EStructuralFeature feature, Object value, boolean deletion) {
        if (eObject != null && feature != null) {
            ObjectChange objectChange = this.changes.get(eObject);
            if (objectChange == null) {
                objectChange = new ObjectChange(eObject);
                this.changes.put(eObject, objectChange);
            }
            if (deletion) {
                objectChange.removeValue(feature, value);
            } else {
                objectChange.addValue(feature, value);
            }
        }
    }

    public void applyChanges() {
        for (ObjectChange change : this.changes.values()) {
            change.execute();
        }
    }

    public void undoChanges() {
        for (ObjectChange change : this.changes.values()) {
            change.undo();
        }
    }

    public void redoChanges() {
        for (ObjectChange change : this.changes.values()) {
            change.execute();
        }
    }

    public Collection<EObject> getCreatedObjects() {
        return this.createdObjects;
    }

    public Collection<EObject> getDeletedObjects() {
        return this.deletedObjects;
    }
}

