/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.actions;

import java.text.ParseException;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;

public enum ActionType {
    PRESERVE(ColorConstants.gray),
    CREATE(new Color(null, 0, 200, 0)),
    DELETE(ColorConstants.red),
    FORBID(ColorConstants.blue);

    private Color color;

    private ActionType(Color color) {
        this.color = color;
    }

    public static ActionType parse(String value) throws ParseException {
        value = value.trim();
        ActionType[] actionTypeArray = ActionType.values();
        int n = actionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionType type = actionTypeArray[n2];
            if (type.name().equalsIgnoreCase(value)) {
                return type;
            }
            ++n2;
        }
        if ("remove".equalsIgnoreCase(value)) {
            return DELETE;
        }
        if ("new".equalsIgnoreCase(value)) {
            return CREATE;
        }
        if ("none".equalsIgnoreCase(value)) {
            return PRESERVE;
        }
        throw new ParseException("Unknown action type: " + value, 0);
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }
}

