/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateEqualityHelper;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.StorageImpl;

public class StateSpaceImpl
extends StorageImpl
implements StateSpace {
    protected Set<State> openStates;
    protected EList<Rule> rules;
    protected EList<State> states;
    protected EList<State> initialStates;
    protected static final int TRANSITION_COUNT_EDEFAULT = 0;
    protected int transitionCount = 0;
    protected StateEqualityHelper equalityHelper;
    protected static final int ZOOM_LEVEL_EDEFAULT = 0;
    protected static final int STATE_REPULSION_EDEFAULT = 0;
    protected static final int TRANSITION_ATTRACTION_EDEFAULT = 0;
    protected static final int MAX_STATE_DISTANCE_EDEFAULT = -1;
    protected static final boolean HIDE_LABELS_EDEFAULT = false;
    protected EMap<String, String> properties;

    protected StateSpaceImpl() {
        this.setEqualityHelper(StateSpaceFactory.eINSTANCE.createStateEqualityHelper());
        this.openStates = new HashSet<State>();
    }

    @Override
    public Set<State> getOpenStates() {
        return this.openStates;
    }

    @Override
    public boolean removeState(State state) {
        if (this.getStates().remove((Object)state)) {
            for (Transition transition : state.getIncoming()) {
                State source = transition.getSource();
                if (source != null) {
                    source.setOpen(true);
                    if (!this.getOpenStates().contains(source)) {
                        this.getOpenStates().add(source);
                    }
                }
                transition.setSource(null);
            }
            for (Transition transition : state.getOutgoing()) {
                transition.setTarget(null);
            }
            int index = 0;
            for (State current : this.getStates()) {
                current.setIndex(index++);
            }
            return true;
        }
        return false;
    }

    private int getPercent(int index, int def) {
        int p = this.getData(index);
        return p == 0 ? def : Math.min(100, Math.max(p, 1));
    }

    private void setPercent(int index, int p) {
        p = Math.min(100, Math.max(p, 1));
        if (this.getData(index) != p) {
            this.setData(index, p);
        }
    }

    @Override
    public int getZoomLevel() {
        return this.getPercent(0, 100);
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        this.setPercent(0, zoomLevel);
    }

    @Override
    public int getStateRepulsion() {
        return this.getPercent(1, 50);
    }

    @Override
    public void setStateRepulsion(int repulsion) {
        this.setPercent(1, repulsion);
    }

    @Override
    public int getTransitionAttraction() {
        return this.getPercent(2, 50);
    }

    @Override
    public void setTransitionAttraction(int attraction) {
        this.setPercent(2, attraction);
    }

    @Override
    public int getMaxStateDistance() {
        int maxDistance = this.getData(3);
        return maxDistance > 0 ? maxDistance : -1;
    }

    @Override
    public void setMaxStateDistance(int maxStateDistance) {
        this.setData(3, maxStateDistance);
    }

    @Override
    public boolean isHideLabels() {
        return this.getData(4) != 0;
    }

    @Override
    public void setHideLabels(boolean hideLabels) {
        this.setData(4, hideLabels ? 1 : 0);
    }

    @Override
    protected EClass eStaticClass() {
        return StateSpacePackage.Literals.STATE_SPACE;
    }

    @Override
    public EList<State> getStates() {
        if (this.states == null) {
            this.states = new EObjectContainmentWithInverseEList(State.class, (InternalEObject)this, 2, 4);
        }
        return this.states;
    }

    @Override
    public EList<State> getInitialStates() {
        if (this.initialStates == null) {
            this.initialStates = new EObjectResolvingEList(State.class, (InternalEObject)this, 3);
        }
        return this.initialStates;
    }

    @Override
    public EList<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new EObjectResolvingEList(Rule.class, (InternalEObject)this, 1);
        }
        return this.rules;
    }

    @Override
    public int getTransitionCount() {
        return this.transitionCount;
    }

    @Override
    public void setTransitionCount(int newTransitionCount) {
        int oldTransitionCount = this.transitionCount;
        this.transitionCount = newTransitionCount;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldTransitionCount, this.transitionCount));
        }
    }

    @Override
    public StateEqualityHelper getEqualityHelper() {
        return this.equalityHelper;
    }

    @Override
    public EMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new EcoreEMap(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, (InternalEObject)this, 12);
        }
        return this.properties;
    }

    public NotificationChain basicSetEqualityHelper(StateEqualityHelper newEqualityHelper, NotificationChain msgs) {
        StateEqualityHelper oldEqualityHelper = this.equalityHelper;
        this.equalityHelper = newEqualityHelper;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldEqualityHelper, (Object)newEqualityHelper);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setEqualityHelper(StateEqualityHelper newEqualityHelper) {
        if (newEqualityHelper != this.equalityHelper) {
            NotificationChain msgs = null;
            if (this.equalityHelper != null) {
                msgs = ((InternalEObject)this.equalityHelper).eInverseRemove((InternalEObject)this, -7, null, msgs);
            }
            if (newEqualityHelper != null) {
                msgs = ((InternalEObject)newEqualityHelper).eInverseAdd((InternalEObject)this, -7, null, msgs);
            }
            if ((msgs = this.basicSetEqualityHelper(newEqualityHelper, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newEqualityHelper, (Object)newEqualityHelper));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getStates()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getStates()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return this.basicSetEqualityHelper(null, msgs);
            }
            case 12: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getRules();
            }
            case 2: {
                return this.getStates();
            }
            case 3: {
                return this.getInitialStates();
            }
            case 4: {
                return this.getOpenStates();
            }
            case 5: {
                return this.getTransitionCount();
            }
            case 6: {
                return this.getEqualityHelper();
            }
            case 7: {
                return this.getZoomLevel();
            }
            case 8: {
                return this.getStateRepulsion();
            }
            case 9: {
                return this.getTransitionAttraction();
            }
            case 10: {
                return this.getMaxStateDistance();
            }
            case 11: {
                return this.isHideLabels();
            }
            case 12: {
                if (coreType) {
                    return this.getProperties();
                }
                return this.getProperties().map();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getRules().clear();
                this.getRules().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getStates().clear();
                this.getStates().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getInitialStates().clear();
                this.getInitialStates().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getOpenStates().clear();
                this.getOpenStates().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setTransitionCount((Integer)newValue);
                return;
            }
            case 6: {
                this.setEqualityHelper((StateEqualityHelper)newValue);
                return;
            }
            case 7: {
                this.setZoomLevel((Integer)newValue);
                return;
            }
            case 8: {
                this.setStateRepulsion((Integer)newValue);
                return;
            }
            case 9: {
                this.setTransitionAttraction((Integer)newValue);
                return;
            }
            case 10: {
                this.setMaxStateDistance((Integer)newValue);
                return;
            }
            case 11: {
                this.setHideLabels((Boolean)newValue);
                return;
            }
            case 12: {
                ((EStructuralFeature.Setting)this.getProperties()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getRules().clear();
                return;
            }
            case 2: {
                this.getStates().clear();
                return;
            }
            case 3: {
                this.getInitialStates().clear();
                return;
            }
            case 4: {
                this.getOpenStates().clear();
                return;
            }
            case 5: {
                this.setTransitionCount(0);
                return;
            }
            case 6: {
                this.setEqualityHelper(null);
                return;
            }
            case 7: {
                this.setZoomLevel(0);
                return;
            }
            case 8: {
                this.setStateRepulsion(0);
                return;
            }
            case 9: {
                this.setTransitionAttraction(0);
                return;
            }
            case 10: {
                this.setMaxStateDistance(-1);
                return;
            }
            case 11: {
                this.setHideLabels(false);
                return;
            }
            case 12: {
                this.getProperties().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.rules != null && !this.rules.isEmpty();
            }
            case 2: {
                return this.states != null && !this.states.isEmpty();
            }
            case 3: {
                return this.initialStates != null && !this.initialStates.isEmpty();
            }
            case 4: {
                return this.openStates != null && !this.openStates.isEmpty();
            }
            case 5: {
                return this.transitionCount != 0;
            }
            case 6: {
                return this.equalityHelper != null;
            }
            case 7: {
                return this.getZoomLevel() != 0;
            }
            case 8: {
                return this.getStateRepulsion() != 0;
            }
            case 9: {
                return this.getTransitionAttraction() != 0;
            }
            case 10: {
                return this.getMaxStateDistance() != -1;
            }
            case 11: {
                return this.isHideLabels();
            }
            case 12: {
                return this.properties != null && !this.properties.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (transitionCount: ");
        result.append(this.transitionCount);
        result.append(')');
        return result.toString();
    }
}

