/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.provider.HenshinEditPlugin;
import org.eclipse.emf.henshin.provider.HenshinItemProviderAdapter;
import org.eclipse.emf.henshin.provider.RuleItemProvider;
import org.eclipse.emf.henshin.provider.descriptors.MappingImagePropertyDescriptor;
import org.eclipse.emf.henshin.provider.descriptors.MappingOriginPropertyDescriptor;

public class MappingItemProvider
extends HenshinItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider {
    protected NodeListener nodeListener = new NodeListener();

    public MappingItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addOriginPropertyDescriptor(object);
            this.addImagePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addOriginPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new MappingOriginPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Mapping_origin_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Mapping_origin_feature", "_UI_Mapping_type"), (EStructuralFeature)HenshinPackage.Literals.MAPPING__ORIGIN));
    }

    protected void addImagePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new MappingImagePropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Mapping_image_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Mapping_image_feature", "_UI_Mapping_type"), (EStructuralFeature)HenshinPackage.Literals.MAPPING__IMAGE));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Mapping"));
    }

    public String getText(Object object) {
        Mapping mapping = (Mapping)object;
        String result = this.getString("_UI_Mapping_type");
        String origin = mapping.getOrigin() != null ? MappingItemProvider.getShortNodeName(mapping.getOrigin()) : "?";
        String image = mapping.getImage() != null ? MappingItemProvider.getShortNodeName(mapping.getImage()) : "?";
        origin = origin.isEmpty() ? "_" : origin;
        image = image.isEmpty() ? "_" : image;
        result = String.valueOf(result) + " " + origin + " -> " + image;
        return result;
    }

    private static String getShortNodeName(Node node) {
        String label = node.toString();
        if (label.startsWith("Node")) {
            label = label.replaceFirst("Node", "").trim();
        }
        return label;
    }

    public Object getParent(Object object) {
        Object o = super.getParent(object);
        if (o instanceof Rule) {
            Rule rule = (Rule)o;
            Mapping mapping = (Mapping)object;
            RuleItemProvider rip = (RuleItemProvider)this.getRootAdapterFactory().adapt((Notifier)rule, IEditingDomainItemProvider.class);
            if (mapping.eContainingFeature() == HenshinPackage.eINSTANCE.getRule_MultiMappings()) {
                return rip.getMultiMappingContainer(rule);
            }
            if (mapping.eContainingFeature() == HenshinPackage.eINSTANCE.getRule_Mappings()) {
                return rip.getLrMappingContainer(rule);
            }
            return super.getParent(object);
        }
        return super.getParent(object);
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 1) {
            Node n1 = (Node)notification.getNewValue();
            Node n2 = (Node)notification.getOldValue();
            this.notifyNodeForRefresh(notification, n1);
            this.notifyNodeForRefresh(notification, n2);
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
            this.removeNodeListener(n2);
            this.addNodeListener(n1);
        }
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    private void addNodeListener(Node node) {
        if (node != null) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)node, Node.class);
            adapter.addListener((INotifyChangedListener)this.nodeListener);
        }
    }

    private void removeNodeListener(Node node) {
        if (node != null) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)node, Node.class);
            adapter.removeListener((INotifyChangedListener)this.nodeListener);
        }
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return HenshinEditPlugin.INSTANCE;
    }

    public void unsetTarget(Notifier target) {
        super.unsetTarget(target);
        Mapping mapping = (Mapping)target;
        this.removeNodeListener(mapping.getImage());
        this.removeNodeListener(mapping.getOrigin());
    }

    public void setTarget(Notifier target) {
        super.setTarget(target);
        Mapping mapping = (Mapping)target;
        this.addNodeListener(mapping.getImage());
        this.addNodeListener(mapping.getOrigin());
    }

    private void notifyNodeForRefresh(Notification notification, Node node) {
        if (node != null) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)node, Node.class);
            ViewerNotification notif = new ViewerNotification(notification, (Object)node, false, true);
            adapter.fireNotifyChanged((Notification)notif);
        }
    }

    protected class NodeListener
    implements INotifyChangedListener {
        protected NodeListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == HenshinPackage.Literals.NAMED_ELEMENT__NAME || notification.getFeature() == HenshinPackage.Literals.NODE__TYPE) {
                List<Mapping> mappings = this.findMappingsByNode((Node)notification.getNotifier());
                if (mappings == null) {
                    return;
                }
                AdapterFactory fac = MappingItemProvider.this.adapterFactory;
                for (Mapping m : mappings) {
                    ViewerNotification notif = new ViewerNotification(notification, (Object)m, false, true);
                    ItemProviderAdapter adapter = (ItemProviderAdapter)fac.adapt((Notifier)m, Mapping.class);
                    adapter.fireNotifyChanged((Notification)notif);
                }
            }
        }

        protected List<Mapping> findMappingsByNode(Node node) {
            ArrayList<Mapping> resultList = new ArrayList<Mapping>();
            Graph graph = node.getGraph();
            if (node.getGraph() == null) {
                return null;
            }
            if (graph.eContainer() instanceof Rule) {
                Rule rule = (Rule)graph.eContainer();
                this.collectMappingHelper(node, (List<Mapping>)rule.getMappings(), resultList);
            } else if (graph.eContainer() instanceof NestedCondition) {
                NestedCondition nc = (NestedCondition)graph.eContainer();
                ArrayList<NestedCondition> allNestedConditions = new ArrayList<NestedCondition>();
                this.collectNestedConditions((Formula)nc, allNestedConditions);
                for (NestedCondition n : allNestedConditions) {
                    this.collectMappingHelper(node, (List<Mapping>)n.getMappings(), resultList);
                }
            }
            return resultList;
        }

        private void collectMappingHelper(Node node, List<Mapping> mappingList, List<Mapping> resultList) {
            for (Mapping m : mappingList) {
                if (m.getImage() != node && m.getOrigin() != node) continue;
                resultList.add(m);
            }
        }

        private void collectNestedConditions(Formula formula, List<NestedCondition> resultList) {
            if (formula instanceof BinaryFormula) {
                BinaryFormula bf = (BinaryFormula)formula;
                this.collectNestedConditions(bf.getLeft(), resultList);
                this.collectNestedConditions(bf.getRight(), resultList);
            } else if (formula instanceof UnaryFormula) {
                UnaryFormula uf = (UnaryFormula)formula;
                this.collectNestedConditions(uf.getChild(), resultList);
            } else if (formula instanceof NestedCondition) {
                resultList.add((NestedCondition)formula);
            }
        }
    }
}

