/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.diningphils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResourceSet;
import org.eclipse.emf.henshin.statespace.util.StateSpaceExplorationHelper;

public class DiningPhilsBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/diningphils";

    public static void run(String path, int maxPhils) {
        block8: {
            StateSpaceResourceSet resourceSet = new StateSpaceResourceSet(path);
            StateSpace stateSpace = resourceSet.getStateSpace("3-phils.henshin_statespace");
            StateSpaceManager manager = StateSpaceFactory.eINSTANCE.createStateSpaceManager(stateSpace);
            stateSpace.getProperties().remove((Object)"identityTypes");
            Rule createPhilRule = (Rule)((Rule)stateSpace.getRules().get(0)).getModule().getUnit("createPhil");
            EngineImpl engine = new EngineImpl();
            System.out.println("Starting dining philosophers benchmark...");
            System.out.println("NumThreads: " + manager.getNumThreads());
            System.out.println("MaxMemory: " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB\n");
            System.out.println("Phils\tStates\tTrans\tTime");
            try {
                try {
                    int phils = 3;
                    while (phils <= maxPhils) {
                        manager.resetStateSpace(false);
                        long time = System.currentTimeMillis();
                        new StateSpaceExplorationHelper(manager).doExploration(-1, (IProgressMonitor)new NullProgressMonitor());
                        time = System.currentTimeMillis() - time;
                        int expectedStates = (int)Math.pow(3.0, phils);
                        if (stateSpace.getStateCount() != expectedStates || !stateSpace.getOpenStates().isEmpty()) {
                            throw new StateSpaceException("Unexpected number of states: " + stateSpace.getStateCount() + "(" + stateSpace.getOpenStates().size() + ")");
                        }
                        System.out.println(String.valueOf(phils) + "\t" + stateSpace.getStateCount() + "\t" + stateSpace.getTransitionCount() + "\t" + time);
                        EGraph initialStateGraph = manager.getModel((State)stateSpace.getInitialStates().get(0)).getEGraph();
                        RuleApplicationImpl app = new RuleApplicationImpl((Engine)engine);
                        app.setEGraph(initialStateGraph);
                        app.setRule(createPhilRule);
                        if (!app.execute(null)) {
                            throw new RuntimeException("Error adding philosopher");
                        }
                        ++phils;
                    }
                }
                catch (StateSpaceException e) {
                    e.printStackTrace();
                    manager.shutdown();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                manager.shutdown();
                throw throwable;
            }
            manager.shutdown();
        }
        System.out.println();
    }

    public static void main(String[] args) {
        System.out.println("\n******* WARMUP PHASE ********\n");
        DiningPhilsBenchmark.run(PATH, 8);
        System.out.println("\n******* BENCHMARK ********\n");
        DiningPhilsBenchmark.run(PATH, 13);
    }
}

