/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class CreateStateSpacePage
extends WizardNewFileCreationPage {
    private final IWorkbench workbench;
    private Resource stateSpaceResource;
    private ResourceSet resourceSet;
    private List<Rule> rules;

    public CreateStateSpacePage(ResourceSet resourceSet, IWorkbench workbench, IStructuredSelection selection) {
        super("Create Statespace", selection);
        this.workbench = workbench;
        this.resourceSet = resourceSet;
        this.rules = new ArrayList<Rule>();
        this.setTitle("Create a new henshin_statespace file");
        this.setDescription("Create a new henshin_statespace file");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("default.henshin_statespace");
        this.setPageComplete(this.validatePage());
    }

    protected boolean finish() {
        IFile newFile = this.createNewFile();
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        if (newFile != null && page != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
            catch (PartInitException e) {
                StateSpaceExplorerPlugin.getInstance().logError("Error opening exported file.", e);
                return false;
            }
        }
        return true;
    }

    protected InputStream getInitialContents() {
        IPath containerPath = this.getContainerFullPath();
        IPath filePath = containerPath.append(this.getFileName());
        try {
            StateSpace stateSpace = StateSpaceFactory.eINSTANCE.createStateSpace();
            stateSpace.getRules().addAll(this.rules);
            URI uri = URI.createPlatformResourceURI((String)filePath.toString(), (boolean)false);
            this.stateSpaceResource = this.resourceSet.createResource(uri);
            this.stateSpaceResource.getContents().add((Object)stateSpace);
            this.stateSpaceResource.save(null);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
            file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            return file.getContents();
        }
        catch (Throwable t) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Create new state space file", (String)("Error creating file: " + t.getMessage()));
            return null;
        }
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String fileName = this.getFileName();
        if (fileName == null || !fileName.endsWith(".henshin_statespace")) {
            this.setErrorMessage("The file name must end with henshin_statespace");
            return false;
        }
        return true;
    }

    public Resource getStateSpaceResource() {
        return this.stateSpaceResource;
    }

    public List<Rule> getRules() {
        return this.rules;
    }
}

