/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.migration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.migration.DiagramTransformation;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.henshin.model.impl.HenshinPackageImpl;
import org.eclipse.emf.henshin.model.resource.HenshinResourceFactory;
import org.eclipse.emf.henshin.testframework.Tools;

public class Transformation {
    private Map<EObject, EObject> newElements = new HashMap<EObject, EObject>();
    private ArrayList<EObject> createdElements = new ArrayList();
    private ArrayList<NestedCondition> nacList = new ArrayList();
    private ArrayList<String> errorList = new ArrayList();
    private Map<Rule, Rule> amalgamationUnitRuleCopies = new HashMap<Rule, Rule>();
    private ArrayList<RuleReplacementHelper> ruleReplacements = new ArrayList();
    private boolean retainKernelAndMultiRules;
    private ArrayList<AmalgamationUnitHelper> amuList = new ArrayList();
    private ArrayList<CountedUnitHelper> cuList = new ArrayList();
    private TransformationSystem newRoot;

    public void migrate(java.net.URI henshinFileUri, boolean optimizeNcs, boolean retainRules, IProgressMonitor pm) throws ClassNotFoundException, IOException, FileNotFoundException {
        this.migrate(henshinFileUri, null, optimizeNcs, retainRules, pm);
    }

    public void migrate(java.net.URI fileUri, java.net.URI henshinDiagramUri, boolean optimizeNcs, boolean retainRules, IProgressMonitor pm) throws ClassNotFoundException, IOException, FileNotFoundException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        pm.beginTask("migrating to new model", 100);
        URI eFileUri = URI.createURI((String)fileUri.toString());
        URI diagramUri = henshinDiagramUri != null ? URI.createURI((String)henshinDiagramUri.toString()) : null;
        System.out.println("diagram: " + diagramUri);
        URI backupUri = eFileUri.appendFileExtension("bak");
        URI newUri = eFileUri;
        HenshinPackageImpl.init();
        HenshinPackage.eINSTANCE.getClass();
        URI henshinUri = URI.createPlatformPluginURI((String)"org.eclipse.emf.henshin.migration/model/henshin-080.ecore", (boolean)false);
        EPackage result = null;
        Resource packageResource = resourceSet.createResource(CommonPlugin.resolve((URI)henshinUri));
        if (packageResource != null) {
            EObject tmpR;
            try {
                packageResource.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                result = null;
            }
            if (packageResource.getContents() != null && packageResource.getContents().size() > 0 && (tmpR = (EObject)packageResource.getContents().get(0)) != null && tmpR instanceof EPackage) {
                result = (EPackage)tmpR;
                resourceSet.getPackageRegistry().put((Object)result.getNsURI(), (Object)result);
            }
        }
        if (result != null) {
            EPackage.Registry.INSTANCE.put((Object)result.getNsURI(), result);
        }
        this.retainKernelAndMultiRules = retainRules;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("henshin", new HenshinResourceFactory());
        Resource oldHenshinResource = resourceSet.getResource(URI.createFileURI((String)eFileUri.toFileString()), true);
        EObject graphRoot = (EObject)oldHenshinResource.getContents().get(0);
        if (diagramUri != null && diagramUri.isFile()) {
            resourceSet.getResource(diagramUri, true);
        }
        pm.subTask("Analyzing transformation system");
        this.addRootObjectToMap(graphRoot);
        pm.worked(20);
        this.collectRuleReferences();
        pm.worked(10);
        System.out.println("\n\n\n");
        for (RuleReplacementHelper rrh : this.ruleReplacements) {
            System.out.println(rrh);
        }
        pm.subTask("updating references");
        this.updateAmalgamationUnitReferences();
        pm.worked(10);
        this.processCountedUnits();
        pm.worked(10);
        System.out.println("\n ****** \n");
        this.newRoot = (TransformationSystem)this.newElements.get(graphRoot);
        Resource newHenshinResource = new HenshinResourceFactory().createResource(null);
        newHenshinResource.getContents().add((Object)this.newRoot);
        resourceSet.getResources().add((Object)newHenshinResource);
        this.updateReferences();
        pm.worked(20);
        this.buildAmalgamationUnits();
        pm.worked(10);
        this.wrapNACs();
        pm.worked(2);
        if (optimizeNcs) {
            this.cleanUpNotFormulas();
            pm.worked(2);
        }
        this.moveRulesToRulesReference();
        pm.worked(2);
        for (TransformationUnit tu : this.newRoot.getTransformationUnits()) {
            System.out.println("updating amalgamation unit references for " + tu.getName());
            this.updateAmalgamationUnitReferences(tu);
        }
        pm.worked(10);
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        this.newElements.put(graphRoot, (EObject)this.newRoot);
        System.out.println("\n\n####################");
        System.out.println(this.newRoot);
        Tools.printCollection((Collection)this.newRoot.getRules());
        pm.subTask("creating backup");
        File oldHenshinFile = new File(fileUri);
        File oldHenshinFileBackup = new File(backupUri.toFileString());
        if (!oldHenshinFile.renameTo(oldHenshinFileBackup)) {
            throw new FileNotFoundException();
        }
        pm.subTask("write new file");
        newHenshinResource.setURI(newUri);
        newHenshinResource.save(null);
        if (diagramUri != null) {
            try {
                boolean diagramTransformationSuccess = DiagramTransformation.transformDiagram(this.newElements, this.amalgamationUnitRuleCopies, (ResourceSet)resourceSet, diagramUri);
                System.out.println("Diagram transformation " + (diagramTransformationSuccess ? "successful" : "failed"));
            }
            catch (Exception e) {
                System.err.println("Problems during diagram migration:");
                e.printStackTrace();
            }
        }
        if (!retainRules) {
            System.out.println("Deleting rules and saving ...");
            this.deleteKernelAndMultiRules();
            newHenshinResource.save(null);
        }
        System.out.println("naclist:");
        Tools.printCollection(this.nacList);
        if (this.nacList.size() != 0) {
            this.addError("Some NACs couldn't be converted.");
        }
        for (Map.Entry<EObject, EObject> entry : this.newElements.entrySet()) {
            System.out.println(entry.getKey() + " -> " + entry.getValue());
        }
        System.out.println("\n\n\n");
        for (AmalgamationUnitHelper auh : this.amuList) {
            System.out.println(auh);
        }
        System.out.println("\n\n");
        for (RuleReplacementHelper rrh : this.ruleReplacements) {
            System.out.println(rrh);
        }
    }

    private void collectRuleReferences() {
        for (Map.Entry<EObject, EObject> e : this.newElements.entrySet()) {
            Object subUnit;
            if (!(e.getValue() instanceof TransformationUnit) || e.getValue() instanceof Rule) continue;
            System.out.println("NOW working on " + e.getKey() + " -> " + e.getValue());
            if (e.getValue() instanceof LoopUnit) {
                subUnit = e.getKey().eGet((EStructuralFeature)this.getEReferenceByName("subUnit", e.getKey().eClass()));
                if (!(this.newElements.get(subUnit) instanceof Rule)) continue;
                this.addRuleReplacement(this.newElements.get(subUnit), e.getValue(), 0);
                continue;
            }
            if (e.getValue() instanceof ConditionalUnit) {
                Object subIf = e.getKey().eGet((EStructuralFeature)this.getEReferenceByName("if", e.getKey().eClass()));
                Object subThen = e.getKey().eGet((EStructuralFeature)this.getEReferenceByName("then", e.getKey().eClass()));
                Object subElse = e.getKey().eGet((EStructuralFeature)this.getEReferenceByName("else", e.getKey().eClass()));
                if (this.newElements.get(subIf) instanceof Rule) {
                    this.addRuleReplacement(this.newElements.get(subIf), e.getValue(), 0);
                }
                if (this.newElements.get(subThen) instanceof Rule) {
                    this.addRuleReplacement(this.newElements.get(subThen), e.getValue(), 0);
                }
                if (!(this.newElements.get(subElse) instanceof Rule)) continue;
                this.addRuleReplacement(this.newElements.get(subElse), e.getValue(), 0);
                continue;
            }
            if ("CountedUnit".equals(e.getKey().eClass().getName())) {
                subUnit = e.getKey().eGet((EStructuralFeature)this.getEReferenceByName("subUnit", e.getKey().eClass()));
                if (!(this.newElements.get(subUnit) instanceof Rule)) continue;
                this.addRuleReplacement(this.newElements.get(subUnit), e.getValue(), 0);
                continue;
            }
            EList subUnits = (EList)e.getKey().eGet((EStructuralFeature)this.getEReferenceByName("subUnits", e.getKey().eClass()));
            int i = 0;
            while (i < subUnits.size()) {
                if (this.newElements.get(subUnits.get(i)) instanceof Rule) {
                    this.addRuleReplacement(this.newElements.get(subUnits.get(i)), e.getValue(), i);
                }
                ++i;
            }
        }
    }

    private void moveRulesToRulesReference() {
        ArrayList<TransformationUnit> ruleList = new ArrayList<TransformationUnit>();
        for (TransformationUnit tu : this.newRoot.getTransformationUnits()) {
            if (!(tu instanceof Rule)) continue;
            ruleList.add(tu);
        }
        for (TransformationUnit tu : ruleList) {
            this.newRoot.getTransformationUnits().remove((Object)tu);
            this.newRoot.getRules().add((Object)((Rule)tu));
        }
    }

    private void updateAmalgamationUnitReferences(TransformationUnit tu) {
        this.updateAmalgamationUnitReferences(new ArrayList<TransformationUnit>(), tu);
    }

    private void updateAmalgamationUnitReferences(ArrayList<TransformationUnit> stack, TransformationUnit tu) {
        block14: {
            block15: {
                Unit suElse;
                Unit suIf;
                ConditionalUnit cu;
                block16: {
                    block12: {
                        Unit su;
                        block13: {
                            if (stack.contains(tu)) {
                                return;
                            }
                            stack.add(tu);
                            if (!(tu instanceof LoopUnit)) break block12;
                            su = ((LoopUnit)tu).getSubUnit();
                            if (!(su instanceof TransformationUnit) || su instanceof Rule) break block13;
                            this.updateAmalgamationUnitReferences(stack, (TransformationUnit)su);
                            break block14;
                        }
                        if (this.amalgamationUnitRuleCopies.get(su) == null || this.searchForRuleReplacement(tu, (Rule)su) != null) break block14;
                        ((LoopUnit)tu).setSubUnit((Unit)this.amalgamationUnitRuleCopies.get(su));
                        break block14;
                    }
                    if (tu instanceof Rule) break block14;
                    if (!(tu instanceof ConditionalUnit)) break block15;
                    cu = (ConditionalUnit)tu;
                    suIf = cu.getIf();
                    Unit suThen = cu.getThen();
                    suElse = cu.getElse();
                    if (suIf instanceof TransformationUnit && !(suIf instanceof Rule)) {
                        this.updateAmalgamationUnitReferences(stack, (TransformationUnit)suIf);
                    } else if (this.amalgamationUnitRuleCopies.get(suIf) != null && this.searchForRuleReplacement(tu, (Rule)suIf) == null) {
                        cu.setIf((Unit)this.amalgamationUnitRuleCopies.get(suIf));
                    }
                    if (suThen instanceof TransformationUnit && !(suThen instanceof Rule)) {
                        this.updateAmalgamationUnitReferences(stack, (TransformationUnit)suThen);
                    } else if (this.amalgamationUnitRuleCopies.get(suThen) != null && this.searchForRuleReplacement(tu, (Rule)suIf) == null) {
                        cu.setThen((Unit)this.amalgamationUnitRuleCopies.get(suThen));
                    }
                    if (!(suElse instanceof TransformationUnit) || suElse instanceof Rule) break block16;
                    this.updateAmalgamationUnitReferences(stack, (TransformationUnit)suElse);
                    break block14;
                }
                if (this.amalgamationUnitRuleCopies.get(suElse) == null || this.searchForRuleReplacement(tu, (Rule)suIf) != null) break block14;
                cu.setElse((Unit)this.amalgamationUnitRuleCopies.get(suElse));
                break block14;
            }
            EList subUnits = (EList)tu.eGet((EStructuralFeature)this.getEReferenceByName("subUnits", tu.eClass()));
            int i = 0;
            while (i < subUnits.size()) {
                TransformationUnit su = (TransformationUnit)subUnits.get(i);
                System.out.println("I=" + i + " SU=" + su);
                if (su instanceof TransformationUnit && !(su instanceof Rule)) {
                    this.updateAmalgamationUnitReferences(stack, su);
                } else if (this.amalgamationUnitRuleCopies.get(su) != null) {
                    RuleReplacementHelper rrh = this.searchForRuleReplacement(tu, (Rule)su);
                    System.out.println("idx::" + i + " Rule replacement ::: " + rrh);
                    if (rrh == null || !rrh.ruleInTuIndices.contains(i)) {
                        System.out.println("replacing!");
                        subUnits.set(i, (Object)((TransformationUnit)this.amalgamationUnitRuleCopies.get(su)));
                    }
                }
                ++i;
            }
        }
    }

    private void buildAmalgamationUnits() {
        for (AmalgamationUnitHelper amu : this.amuList) {
            Rule krlRuleTmp = (Rule)this.newElements.get(amu.kernelRule);
            Rule krlRule = (Rule)EcoreUtil.copy((EObject)krlRuleTmp);
            krlRule.getMultiRules().clear();
            this.amalgamationUnitRuleCopies.put(krlRuleTmp, krlRule);
            krlRule.setName(amu.amalgamationUnitName);
            System.out.println("\n\n\n\nKERNEL RULE: " + krlRule);
            this.newRoot.getRules().add((Object)krlRule);
            for (EObject mr : amu.multiRules) {
                Rule multiRuleTmp = (Rule)this.newElements.get(mr);
                Rule multiRule = (Rule)EcoreUtil.copy((EObject)multiRuleTmp);
                this.amalgamationUnitRuleCopies.put(multiRuleTmp, multiRule);
                System.out.println("multi rule: " + multiRule);
                System.out.println("######################## " + krlRule.getMultiRules().remove((Object)multiRuleTmp));
                this.newRoot.getRules().add((Object)multiRuleTmp);
                krlRule.getMultiRules().add((Object)multiRule);
            }
            System.out.println("lhs mappings:");
            ArrayList[] arrayListArray = new ArrayList[]{amu.lhsMappings, amu.rhsMappings};
            int n = arrayListArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayList al = arrayListArray[n2];
                System.out.println("***!");
                for (EObject mp : al) {
                    Node newImageNode;
                    int nodeIndex;
                    Node newOriginNode;
                    int nodeIndex2;
                    Mapping newMp = (Mapping)this.newElements.get(mp);
                    System.out.println("\tnew mapping:" + newMp + " : " + newMp.getOrigin().getGraph().getRule().getName() + " -> " + newMp.getImage().getGraph().getRule().getName());
                    Node originNodeTmp = newMp.getOrigin();
                    Rule originNodeContainerRuleTmp = originNodeTmp.getGraph().getRule();
                    Rule originNodeContainerRule = this.amalgamationUnitRuleCopies.get(originNodeContainerRuleTmp);
                    System.out.println("\tor:" + originNodeContainerRule);
                    if (originNodeContainerRuleTmp.getLhs().equals(originNodeTmp.getGraph())) {
                        nodeIndex2 = originNodeContainerRuleTmp.getLhs().getNodes().indexOf((Object)originNodeTmp);
                        newOriginNode = (Node)originNodeContainerRule.getLhs().getNodes().get(nodeIndex2);
                        System.out.println("node in LHS @ index " + nodeIndex2);
                    } else {
                        nodeIndex2 = originNodeContainerRuleTmp.getRhs().getNodes().indexOf((Object)originNodeTmp);
                        newOriginNode = (Node)originNodeContainerRule.getRhs().getNodes().get(nodeIndex2);
                        System.out.println("node in RHS @ index " + nodeIndex2);
                    }
                    System.out.println(originNodeTmp + " ==> " + newOriginNode);
                    newMp.setOrigin(newOriginNode);
                    Node imageNodeTmp = newMp.getImage();
                    Rule imageNodeContainerRuleTmp = imageNodeTmp.getGraph().getRule();
                    Rule imageNodeContainerRule = this.amalgamationUnitRuleCopies.get(imageNodeContainerRuleTmp);
                    if (imageNodeContainerRuleTmp.getLhs().equals(imageNodeTmp.getGraph())) {
                        nodeIndex = imageNodeContainerRuleTmp.getLhs().getNodes().indexOf((Object)imageNodeTmp);
                        newImageNode = (Node)imageNodeContainerRule.getLhs().getNodes().get(nodeIndex);
                        System.out.println("node in LHS @ index " + nodeIndex);
                    } else {
                        nodeIndex = imageNodeContainerRuleTmp.getRhs().getNodes().indexOf((Object)imageNodeTmp);
                        newImageNode = (Node)imageNodeContainerRule.getRhs().getNodes().get(nodeIndex);
                        System.out.println("node in RHS @ index " + nodeIndex);
                    }
                    System.out.println("\tim:" + imageNodeContainerRule);
                    newMp.setImage(newImageNode);
                    imageNodeContainerRule.getMultiMappings().add((Object)newMp);
                    System.out.println("mapping container:" + newMp.eContainer());
                }
                ++n2;
            }
        }
    }

    private void deleteKernelAndMultiRules() {
        for (AmalgamationUnitHelper amu : this.amuList) {
            System.out.println("\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdremoving kernel rule from transformation system " + this.newElements.get(amu.kernelRule) + " \u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd " + this.newRoot.getRules().remove((Object)this.newElements.get(amu.kernelRule)));
            for (EObject mr : amu.multiRules) {
                System.out.println("\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd \tremoving multi-rule from transformation system " + this.newElements.get(mr) + " \u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd " + this.newRoot.getRules().remove((Object)this.newElements.get(mr)));
            }
        }
    }

    private void updateReferences() {
        for (Map.Entry<EObject, EObject> e : this.newElements.entrySet()) {
            System.out.println("\nREFERENCES FOR " + e.getKey() + "\t\t\t (new object: " + e.getValue() + ")");
            for (EReference er : e.getKey().eClass().getEAllReferences()) {
                System.out.println("\t" + er);
            }
            for (EReference er : e.getValue().eClass().getEAllReferences()) {
                System.out.println("#\t" + er);
                EReference oldErefType = this.getEReferenceByName(er.getName(), e.getKey().eClass());
                if (er.isChangeable()) {
                    if (oldErefType != null) {
                        if (e.getKey().eGet((EStructuralFeature)oldErefType) instanceof EList) {
                            EList oldReferencedObjects = (EList)e.getKey().eGet((EStructuralFeature)oldErefType);
                            System.out.println("lst:: " + oldReferencedObjects);
                            if (oldReferencedObjects == null) continue;
                            EList newReferencedObjects = (EList)e.getValue().eGet((EStructuralFeature)er);
                            if (er.getName().equals("imports")) {
                                System.out.println("special case for imports");
                                e.getValue().eSet((EStructuralFeature)er, (Object)oldReferencedObjects);
                                continue;
                            }
                            if (er.getName().equals("parameterMappings")) {
                                if (e.getKey().eClass().getName().equals("AmalgamationUnit")) continue;
                                this.convertObjectList((EList<EObject>)oldReferencedObjects, (EList<EObject>)newReferencedObjects);
                                continue;
                            }
                            if (er.getName().equals("parameters")) {
                                if (e.getKey().eClass().getName().equals("AmalgamationUnit")) continue;
                                this.convertObjectList((EList<EObject>)oldReferencedObjects, (EList<EObject>)newReferencedObjects);
                                continue;
                            }
                            this.convertObjectList((EList<EObject>)oldReferencedObjects, (EList<EObject>)newReferencedObjects);
                            System.out.println("NEW:: " + newReferencedObjects);
                            System.out.println("new:: " + e.getValue().eGet((EStructuralFeature)er) + " // " + newReferencedObjects);
                            System.out.println("non-null");
                            continue;
                        }
                        if (er.getName().equals("type")) {
                            System.out.println("special case for types");
                            EObject objectType = (EObject)e.getKey().eGet((EStructuralFeature)oldErefType);
                            e.getValue().eSet((EStructuralFeature)er, (Object)objectType);
                            continue;
                        }
                        if (e.getKey().eGet((EStructuralFeature)oldErefType) instanceof EObject) {
                            if (e.getValue() instanceof LoopUnit) {
                                System.err.println("*********");
                                System.out.println("**********" + e.getValue());
                                System.out.println("**********" + e.getKey());
                                System.out.flush();
                            }
                            EObject oldReferencedObject = (EObject)e.getKey().eGet((EStructuralFeature)oldErefType);
                            System.out.println("obj:: " + oldReferencedObject);
                            if (oldReferencedObject == null) continue;
                            EObject newReferencedObject = this.newElements.get(oldReferencedObject);
                            e.getValue().eSet((EStructuralFeature)er, (Object)newReferencedObject);
                            System.out.println("~>" + newReferencedObject);
                            System.out.println("non-null");
                            continue;
                        }
                        System.out.println("no list, no single object ... ??? ->" + e.getKey().eGet((EStructuralFeature)oldErefType));
                        continue;
                    }
                    System.out.println(er + " has no old reference equivalent");
                    continue;
                }
                System.out.println("reference not changeable");
            }
        }
    }

    private void convertObjectList(EList<EObject> oldList, EList<EObject> newList) {
        System.out.print("{");
        int i = 0;
        while (i < oldList.size()) {
            System.out.print(this.newElements.get(oldList.get(i)) + " ?->");
            System.out.print(String.valueOf(newList.add((Object)this.newElements.get(oldList.get(i)))) + ", ");
            ++i;
        }
        i = oldList.size() - 1;
        while (i > 0) {
            newList.move(i, (Object)this.newElements.get(oldList.get(i)));
            --i;
        }
        System.out.println("} => " + newList);
    }

    private void updateAmalgamationUnitReferences() {
        for (Map.Entry<EObject, EObject> e : this.newElements.entrySet()) {
            if (!this.newElements.containsKey(e.getValue())) continue;
            EObject ruleReplacingAmalgamationUnit = this.newElements.get(e.getValue());
            this.newElements.put(e.getKey(), ruleReplacingAmalgamationUnit);
        }
    }

    private void processCountedUnits() {
        for (CountedUnitHelper cuh : this.cuList) {
            SequentialUnit su = (SequentialUnit)this.newElements.get(cuh.countedUnit);
            EObject subUnit = this.newElements.get(cuh.subUnit);
            int i = 0;
            while (i < cuh.count) {
                su.getSubUnits().add((Object)((Unit)subUnit));
                ++i;
            }
        }
    }

    private void fillMap(EObject rootObject) {
        HenshinPackage henshinNew = HenshinPackageImpl.eINSTANCE;
        for (EObject eo : rootObject.eContents()) {
            Object val;
            boolean detectedNC = false;
            String type = eo.eClass().getName();
            System.out.println(type);
            if ("AmalgamationUnit".equals(type)) {
                EClass cfr_ignored_0 = (EClass)henshinNew.getEClassifier(type);
                EObject amalgamationUnitKernelRule = (EObject)eo.eGet((EStructuralFeature)this.getEReferenceByName("kernelRule", eo.eClass()));
                AmalgamationUnitHelper amu = new AmalgamationUnitHelper();
                amu.kernelRule = amalgamationUnitKernelRule;
                amu.amalgamationUnitName = (String)eo.eGet((EStructuralFeature)this.getEAttributeForName("name", eo.eClass()));
                EList amalgamationUnitMultiRules = (EList)eo.eGet((EStructuralFeature)this.getEReferenceByName("multiRules", eo.eClass()));
                for (EObject multiRule : amalgamationUnitMultiRules) {
                    amu.multiRules.add(multiRule);
                }
                EList amalgamationUnitLhsMappings = (EList)eo.eGet((EStructuralFeature)this.getEReferenceByName("lhsMappings", eo.eClass()));
                for (EObject lhsMapping : amalgamationUnitLhsMappings) {
                    amu.lhsMappings.add(lhsMapping);
                    Mapping newLhsMapping = HenshinFactory.eINSTANCE.createMapping();
                    this.newElements.put(lhsMapping, (EObject)newLhsMapping);
                }
                EList amalgamationUnitRhsMappings = (EList)eo.eGet((EStructuralFeature)this.getEReferenceByName("rhsMappings", eo.eClass()));
                for (EObject rhsMapping : amalgamationUnitRhsMappings) {
                    amu.rhsMappings.add(rhsMapping);
                    Mapping newRhsMapping = HenshinFactory.eINSTANCE.createMapping();
                    this.newElements.put(rhsMapping, (EObject)newRhsMapping);
                }
                this.amuList.add(amu);
                this.newElements.put(eo, amalgamationUnitKernelRule);
                continue;
            }
            if ("NestedCondition".equals(type)) {
                detectedNC = true;
            } else if ("CountedUnit".equals(type)) {
                LoopUnit cuReplacement;
                EList countedUnitParameters = (EList)eo.eGet((EStructuralFeature)this.getEReferenceByName("parameters", eo.eClass()));
                for (EObject parameter : countedUnitParameters) {
                    Parameter newParameter = HenshinFactory.eINSTANCE.createParameter();
                    newParameter.setName((String)this.getEAttributeValue(parameter, "name"));
                    newParameter.setDescription((String)this.getEAttributeValue(parameter, "description"));
                    this.newElements.put(parameter, (EObject)newParameter);
                }
                EList countedUnitParameterMappings = (EList)eo.eGet((EStructuralFeature)this.getEReferenceByName("parameterMappings", eo.eClass()));
                for (EObject parameterMapping : countedUnitParameterMappings) {
                    ParameterMapping newParameterMapping = HenshinFactory.eINSTANCE.createParameterMapping();
                    this.newElements.put(parameterMapping, (EObject)newParameterMapping);
                }
                EAttribute attr = this.getEAttributeForName("count", eo.eClass());
                int count = (Integer)eo.eGet((EStructuralFeature)attr);
                if (count < 1) {
                    LoopUnit countedUnitReplacement = HenshinFactoryImpl.eINSTANCE.createLoopUnit();
                    countedUnitReplacement.setName((String)eo.eGet((EStructuralFeature)this.getEAttributeForName("name", eo.eClass())));
                    countedUnitReplacement.setDescription((String)eo.eGet((EStructuralFeature)this.getEAttributeForName("description", eo.eClass())));
                    if (count != 0) {
                        countedUnitReplacement.setActivated(((Boolean)eo.eGet((EStructuralFeature)this.getEAttributeForName("activated", eo.eClass()))).booleanValue());
                    } else if (count == 0) {
                        countedUnitReplacement.setActivated(false);
                    }
                    cuReplacement = countedUnitReplacement;
                } else {
                    CountedUnitHelper cuHelper = new CountedUnitHelper(eo, (EObject)eo.eGet((EStructuralFeature)this.getEReferenceByName("subUnit", eo.eClass())), (Integer)eo.eGet((EStructuralFeature)this.getEAttributeForName("count", eo.eClass())));
                    SequentialUnit countedUnitReplacementSeqUnit = HenshinFactory.eINSTANCE.createSequentialUnit();
                    countedUnitReplacementSeqUnit.setName((String)eo.eGet((EStructuralFeature)this.getEAttributeForName("name", eo.eClass())));
                    countedUnitReplacementSeqUnit.setDescription((String)eo.eGet((EStructuralFeature)this.getEAttributeForName("description", eo.eClass())));
                    countedUnitReplacementSeqUnit.setActivated(((Boolean)eo.eGet((EStructuralFeature)this.getEAttributeForName("activated", eo.eClass()))).booleanValue());
                    this.cuList.add(cuHelper);
                    cuReplacement = countedUnitReplacementSeqUnit;
                }
                this.newElements.put(eo, (EObject)cuReplacement);
                continue;
            }
            EClass ec = (EClass)henshinNew.getEClassifier(type);
            EObject newObject = HenshinFactoryImpl.eINSTANCE.create(ec);
            for (EAttribute attr : eo.eClass().getEAllAttributes()) {
                val = eo.eGet((EStructuralFeature)attr);
                EAttribute newAttr = this.getEAttributeForName(attr.getName(), ec);
                if (detectedNC && attr.getName().equals("negated")) {
                    if (!((Boolean)val).booleanValue()) continue;
                    this.nacList.add((NestedCondition)newObject);
                    continue;
                }
                if (newAttr != null) {
                    newObject.eSet((EStructuralFeature)newAttr, val);
                } else {
                    System.err.println("deleted attribute: " + attr.getName());
                }
                System.out.println("OLD-> " + attr.getName() + " : " + val);
            }
            for (EAttribute attr : newObject.eClass().getEAllAttributes()) {
                val = newObject.eGet((EStructuralFeature)attr);
                System.out.println("NEW-> " + attr.getName() + " : " + val);
            }
            System.out.println(newObject);
            this.newElements.put(eo, newObject);
            System.out.println(" --- ");
            this.fillMap(eo);
        }
    }

    private void addRootObjectToMap(EObject eo) {
        Object val;
        HenshinPackage henshinNew = HenshinPackageImpl.eINSTANCE;
        String type = eo.eClass().getName();
        System.out.println(type);
        if ("AmalgamationUnit".equals(type)) {
            return;
        }
        EClass ec = (EClass)henshinNew.getEClassifier(type);
        EObject newObject = HenshinFactoryImpl.eINSTANCE.create(ec);
        for (EAttribute attr : eo.eClass().getEAllAttributes()) {
            val = eo.eGet((EStructuralFeature)attr);
            EAttribute newAttr = this.getEAttributeForName(attr.getName(), ec);
            if (newAttr != null) {
                newObject.eSet((EStructuralFeature)newAttr, val);
            } else {
                System.err.println("deleted attribute: " + attr.getName());
            }
            System.out.println("OLD-> " + attr.getName() + " : " + val);
        }
        for (EAttribute attr : newObject.eClass().getEAllAttributes()) {
            val = newObject.eGet((EStructuralFeature)attr);
            System.out.println("NEW-> " + attr.getName() + " : " + val);
        }
        System.out.println(newObject);
        this.newElements.put(eo, newObject);
        System.out.println(" --- ");
        this.fillMap(eo);
    }

    private Object getEAttributeValue(EObject object, String name) {
        EAttribute attr = this.getEAttributeForName(name, object.eClass());
        if (attr != null) {
            return object.eGet((EStructuralFeature)attr);
        }
        return null;
    }

    private EAttribute getEAttributeForName(String name, EClass ec) {
        for (EAttribute attr : ec.getEAllAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    private EReference getEReferenceByName(String name, EClass ec) {
        for (EReference eref : ec.getEAllReferences()) {
            System.out.println("\t" + eref.getName());
            if (!eref.getName().equals(name)) continue;
            return eref;
        }
        return null;
    }

    private void wrapNACs() {
        System.out.println("\n\n --- wrap nacs ---");
        for (Map.Entry<EObject, EObject> entry : this.newElements.entrySet()) {
            if (!(entry.getValue() instanceof Graph)) continue;
            Formula nacCandidate = ((Graph)entry.getValue()).getFormula();
            if (nacCandidate instanceof NestedCondition) {
                if (!this.nacList.contains(nacCandidate)) continue;
                NestedCondition nac = (NestedCondition)nacCandidate;
                this.nacList.remove(nac);
                Not nacNotWrapper = HenshinFactory.eINSTANCE.createNot();
                nacNotWrapper.setChild((Formula)nac);
                ((Graph)entry.getValue()).setFormula((Formula)nacNotWrapper);
                this.createdElements.add((EObject)nacNotWrapper);
                continue;
            }
            if (nacCandidate == null) continue;
            System.out.println("traverse formula!" + nacCandidate);
            this.traverseFormula(nacCandidate);
        }
    }

    private void traverseFormula(Formula f) {
        System.out.println("... traversing formula " + f);
        if (f instanceof Not) {
            if (((Not)f).getChild() instanceof NestedCondition) {
                if (this.nacList.contains((NestedCondition)((Not)f).getChild())) {
                    ((Not)f).setChild((Formula)this.wrapNac((NestedCondition)((Not)f).getChild()));
                }
            } else {
                this.traverseFormula(((Not)f).getChild());
            }
        } else if (f instanceof BinaryFormula) {
            BinaryFormula binF = (BinaryFormula)f;
            System.out.println(".. binary formula: <<" + binF.getLeft() + " ; " + binF.getRight() + ">>");
            if (binF.getLeft() instanceof NestedCondition) {
                if (this.nacList.contains((NestedCondition)binF.getLeft())) {
                    binF.setLeft((Formula)this.wrapNac((NestedCondition)binF.getLeft()));
                }
            } else {
                this.traverseFormula(binF.getLeft());
            }
            if (binF.getRight() instanceof NestedCondition) {
                if (this.nacList.contains((NestedCondition)binF.getRight())) {
                    binF.setRight((Formula)this.wrapNac((NestedCondition)binF.getRight()));
                }
            } else {
                this.traverseFormula(binF.getRight());
            }
        }
    }

    private Not wrapNac(NestedCondition nac) {
        this.nacList.remove(nac);
        Not nacNotWrapper = HenshinFactory.eINSTANCE.createNot();
        nacNotWrapper.setChild((Formula)nac);
        this.createdElements.add((EObject)nacNotWrapper);
        return nacNotWrapper;
    }

    private void cleanUpNotFormulas() {
        ArrayList<EObject> newObjectList = new ArrayList<EObject>();
        newObjectList.addAll(this.newElements.values());
        newObjectList.addAll(this.createdElements);
        for (EObject val : newObjectList) {
            if (!(val instanceof Not)) continue;
            Not tempN = (Not)val;
            System.out.println("tempn container::::::: " + tempN.eContainer());
            if (!(tempN.getChild() instanceof Not)) continue;
            if (tempN.eContainer() instanceof Graph) {
                Graph ncContainer = (Graph)tempN.eContainer();
                ncContainer.setFormula(((Not)tempN.getChild()).getChild());
                continue;
            }
            if (!(tempN.eContainer() instanceof BinaryFormula)) continue;
            BinaryFormula binF = (BinaryFormula)tempN.eContainer();
            if (binF.getLeft() != null && binF.getLeft().equals(tempN)) {
                binF.setLeft(((Not)tempN.getChild()).getChild());
                continue;
            }
            if (binF.getRight() == null || !binF.getRight().equals(tempN)) continue;
            binF.setRight(((Not)tempN.getChild()).getChild());
        }
    }

    private void addError(String errorText) {
        this.errorList.add(errorText);
    }

    private RuleReplacementHelper searchForRuleReplacement(TransformationUnit tu, Rule r) {
        for (RuleReplacementHelper rrh : this.ruleReplacements) {
            if (!r.equals(rrh.rule) || !tu.equals(rrh.tu)) continue;
            return rrh;
        }
        return null;
    }

    private void addRuleReplacement(EObject rule, EObject tu, int index) {
        RuleReplacementHelper rrh = this.searchForRuleReplacement((TransformationUnit)tu, (Rule)rule);
        if (rrh == null) {
            this.ruleReplacements.add(new RuleReplacementHelper((EObject)((Rule)rule), (EObject)((TransformationUnit)tu), index));
        } else {
            rrh.ruleInTuIndices.add(index);
        }
    }

    private class AmalgamationUnitHelper {
        EObject kernelRule;
        ArrayList<EObject> multiRules = new ArrayList();
        ArrayList<EObject> lhsMappings = new ArrayList();
        ArrayList<EObject> rhsMappings = new ArrayList();
        String amalgamationUnitName = "";

        private AmalgamationUnitHelper() {
        }

        public String toString() {
            String mrString = "";
            for (EObject eo : this.multiRules) {
                mrString = String.valueOf(mrString) + eo + "\t";
            }
            return "kernel: " + this.kernelRule + "  ;;; multi: " + mrString;
        }
    }

    private class CountedUnitHelper {
        EObject countedUnit;
        EObject subUnit;
        int count;

        public CountedUnitHelper(EObject countedUnit, EObject subUnit, int count) {
            this.countedUnit = countedUnit;
            this.subUnit = subUnit;
            this.count = count;
        }
    }

    private class RuleReplacementHelper {
        EObject rule;
        EObject tu;
        ArrayList<Integer> ruleInTuIndices = new ArrayList();

        public RuleReplacementHelper(EObject rule, EObject tu, int ruleInTuIndex) {
            this.rule = rule;
            this.tu = tu;
            this.ruleInTuIndices.add(ruleInTuIndex);
        }

        public String toString() {
            return "@idx=" + this.getIndicesString() + "    " + this.rule + "      in " + this.tu;
        }

        private String getIndicesString() {
            String s = "";
            for (Integer i : this.ruleInTuIndices) {
                s = String.valueOf(s) + i + " ";
            }
            return s;
        }
    }
}

