/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.parts;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public class StateSpaceToolsMenuFactory {
    public static Composite newExpandItemComposite(Composite bar, int columns) {
        Composite composite = new Composite(bar, 2048);
        composite.setLayout((Layout)new GridLayout(columns, false));
        return composite;
    }

    public static ExpandItem newExpandItem(ExpandBar bar, Composite composite, String name, int index) {
        ExpandItem item = new ExpandItem(bar, 0, index);
        item.setText(name);
        item.setHeight(composite.computeSize((int)-1, (int)-1).y);
        item.setControl((Control)composite);
        item.setExpanded(true);
        return item;
    }

    public static Label newLabel(Composite parent, String text, int align) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(align));
        return label;
    }

    public static Label newDoubleLabel(Composite parent, String text1, String text2) {
        StateSpaceToolsMenuFactory.newLabel(parent, text1, 128);
        return StateSpaceToolsMenuFactory.newLabel(parent, text2, 768);
    }

    public static Scale newScale(Composite parent, String name, int min, int max, int inc, int pageInc, boolean wrap, String unit) {
        if (unit == null) {
            unit = "";
        }
        Label label = new Label(parent, 0);
        label.setText(wrap ? name : String.valueOf(name) + " " + min + unit);
        GridData data = new GridData(32);
        if (wrap) {
            data.horizontalSpan = 3;
        }
        label.setLayoutData((Object)data);
        if (wrap) {
            label = new Label(parent, 0);
            label.setText(String.valueOf(min) + unit);
        }
        Scale scale = new Scale(parent, 0);
        scale.setLayoutData((Object)new GridData(768));
        scale.setIncrement(inc);
        scale.setPageIncrement(pageInc);
        scale.setMinimum(min);
        scale.setMaximum(max);
        scale.setSelection((max - min) / 2);
        label = new Label(parent, 0);
        label.setText(String.valueOf(max) + unit);
        return scale;
    }

    public static Text newMultiText(Composite parent, int horSpan, int minHeight) {
        Text text = new Text(parent, 2050);
        GridData data = new GridData(1808);
        data.horizontalSpan = horSpan;
        if (minHeight >= 0) {
            data.minimumHeight = minHeight;
        }
        text.setLayoutData((Object)data);
        return text;
    }

    public static void newHorizontalFill(Composite parent) {
        Label composite = new Label(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
    }

    public static Button newButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(32));
        button.setText(text);
        return button;
    }

    public static Link newLink(Composite parent, String text) {
        Link link = new Link(parent, 0);
        link.setText(text);
        return link;
    }
}

