/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class CodeGenTagCompletionProposalComputer implements
		IJavaCompletionProposalComputer {

	private Image image;

	private String errorMessage;

	public List<?> computeCompletionProposals(
			ContentAssistInvocationContext ctx, IProgressMonitor monitor) {
		if (!(ctx instanceof JavaContentAssistInvocationContext))
			return Collections.emptyList();

		JavaContentAssistInvocationContext javaCtx = (JavaContentAssistInvocationContext) ctx;
		CompletionContext coreCtx = javaCtx.getCoreContext();
		if (coreCtx == null || !coreCtx.isInJavadoc())
			return Collections.emptyList();

		ICompilationUnit cu = javaCtx.getCompilationUnit();
		if (cu == null)
			return Collections.emptyList();

		int offset = javaCtx.getInvocationOffset();
		try {
			IJavaElement element = cu.getElementAt(offset);
			if (!(element instanceof IMember))
				return Collections.emptyList();

			IMember member = (IMember) element;
			List<CodeGenTag> tags = CodeGenTag.getTags(member);
			if (tags == null)
				return Collections.emptyList();

			if (image == null) {
				CompletionProposal proposal = CompletionProposal.create(
						CompletionProposal.JAVADOC_BLOCK_TAG, offset);
				ImageDescriptor desc = javaCtx.getLabelProvider()
						.createImageDescriptor(proposal);
				if (desc != null)
					image = desc.createImage();
			}

			String prefix = String.valueOf(coreCtx.getToken());
			ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
			for (CodeGenTag tag : tags) {
				if (tag.getTag().startsWith(prefix))
					list.add(new CodeGenTagCompletionProposal(coreCtx, image,
							tag.getTag(), tag.getTag(), tag.getDescription()));
			}

			return list;
		} catch (JavaModelException e) {
			errorMessage = e.getMessage();
		}

		return Collections.emptyList();
	}

	public List<?> computeContextInformation(
			ContentAssistInvocationContext context, IProgressMonitor monitor) {
		return Collections.emptyList();
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void sessionStarted() {
		errorMessage = null;
	}

	public void sessionEnded() {
		errorMessage = null;
		if (image != null) {
			image.dispose();
			image = null;
		}
	}
}
