/*******************************************************************************
 * Copyright (c) 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.examples.ext.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.util.ItemJavaElementDescriptor;

public class GenModelItemProvider extends JavaElementItemProviderAdapter
		implements IItemJavaElementSource {

	protected static final List<EStructuralFeature> OBSERVED_FEATURES = Arrays
			.asList((EStructuralFeature) GenModelPackage.Literals.GEN_MODEL__MODEL_DIRECTORY);

	public GenModelItemProvider(
			ValidatorJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenModel genModel = (GenModel) object;
		IPath path = new Path(genModel.getModelProjectDirectory());
		IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(
				path.append("text/description.txt"));
		IItemJavaElementDescriptor descriptor = new ItemJavaElementDescriptor(
				file, CAT_VALIDATOR, "Model description", "Description", null);
		return Collections.singletonList(descriptor);
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new ObservedFeatureGenModelSwitch() {
			@Override
			public List<EStructuralFeature> caseGenModel(GenModel object) {
				return OBSERVED_FEATURES;
			}
		};
	}
}
