/*******************************************************************************
 * Copyright (c) 2009 - 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.examples.ext.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;

public class GenClassItemProvider extends JavaElementItemProviderAdapter
		implements IItemJavaElementSource {

	protected static final List<EReference> GROUP_REFERENCES = Arrays.asList(
			GenModelPackage.Literals.GEN_CLASSIFIER__GEN_PACKAGE,
			GenModelPackage.Literals.GEN_CLASS__ECORE_CLASS);

	protected static final List<EReference> GROUP_REFERENCES__GEN_PACKAGE = Arrays
			.asList(GenModelPackage.Literals.GEN_PACKAGE__GEN_MODEL,
					GenModelPackage.Literals.GEN_PACKAGE__ECORE_PACKAGE);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__GEN_PACKAGE = Arrays
			.asList(
					(EStructuralFeature) GenModelPackage.Literals.GEN_PACKAGE__PREFIX,
					GenModelPackage.Literals.GEN_PACKAGE__BASE_PACKAGE,
					GenModelPackage.Literals.GEN_PACKAGE__INTERFACE_PACKAGE_SUFFIX);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__GEN_PACKAGE__GEN_MODEL = Arrays
			.asList((EStructuralFeature) GenModelPackage.Literals.GEN_MODEL__MODEL_DIRECTORY);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__ECORE_CLASSIFIER = Arrays
			.asList((EStructuralFeature) EcorePackage.Literals.ENAMED_ELEMENT__NAME);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__GEN_PACKAGE__ECORE_PACKAGE = Arrays
			.asList((EStructuralFeature) EcorePackage.Literals.ENAMED_ELEMENT__NAME);

	public GenClassItemProvider(
			ValidatorJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenClass genClass = (GenClass) object;
		if (!isFullyResolved(genClass))
			return Collections.emptyList();

		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		GenModel genModel = genClass.getGenModel();
		String modelDir = genModel.getModelDirectory();

		String basePackage = genClass.getGenPackage().getInterfacePackageName();
		String validationPackage = basePackage == null ? "validation."
				: basePackage + ".validation.";
		String validator = validationPackage + genClass.getInterfaceName()
				+ "Validator";
		addType(modelDir, validator, CAT_VALIDATOR, "Validator interface",
				"Validator Interface",
				GenModelPackage.Literals.GEN_CLASS__ECORE_CLASS, true, list);

		addMethod(modelDir,
				validator,
				"validate",
				CAT_VALIDATOR, "Validate method declaration",
				"Validate Method",
				GenModelPackage.Literals.GEN_CLASS__ECORE_CLASS, true, list);

		return list;
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GenClassGroupReferenceGenModelSwitch();
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new GenClassObservedFeatureGenModelSwitch();
	}

	protected static class GenClassGroupReferenceGenModelSwitch extends
			GroupReferenceGenModelSwitch {

		@Override
		public List<EReference> caseGenClass(GenClass object) {
			return GROUP_REFERENCES;
		}

		@Override
		public List<EReference> caseGenPackage(GenPackage object) {
			return GROUP_REFERENCES__GEN_PACKAGE;
		}
	}

	protected static class GenClassObservedFeatureGenModelSwitch extends
			ObservedFeatureGenModelSwitch {

		@Override
		public List<EStructuralFeature> caseGenPackage(GenPackage object) {
			return OBSERVED_FEATURES__GEN_PACKAGE;
		}

		@Override
		public List<EStructuralFeature> caseGenModel(GenModel object) {
			return OBSERVED_FEATURES__GEN_PACKAGE__GEN_MODEL;
		}

		@Override
		protected ObservedFeatureEcoreSwitch createObservedFeatureEcoreSwitch() {
			return new GenClassObservedFeatureEcoreSwitch();
		}
	}

	protected static class GenClassObservedFeatureEcoreSwitch extends
			ObservedFeatureEcoreSwitch {

		@Override
		public List<EStructuralFeature> caseEClass(EClass object) {
			return OBSERVED_FEATURES__ECORE_CLASSIFIER;
		}

		@Override
		public List<EStructuralFeature> caseEPackage(EPackage object) {
			return OBSERVED_FEATURES__GEN_PACKAGE__ECORE_PACKAGE;
		}
	}
}
