/******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/

package org.eclipse.gmf.runtime.common.ui.action.internal.l10n;

/**
 * Bundle of all images used by the org.eclipse.gmf.runtime.common.ui.action plugin.
 */
public class CommonUIActionPluginImages {

	// Prefixes
	private static final String PREFIX_FULL_ETOOL16 = "icons/full/etool16/"; //$NON-NLS-1$
	private static final String PREFIX_FULL_DTOOL16 = "icons/full/dtool16/"; //$NON-NLS-1$

	// Note: The following images will eventually become available in org.eclipse.ui.ISharedImages
	// See Bugzilla 115551
	
	// Images for print action
	public static final String IMG_PRINT_EDIT_ETOOL16 = PREFIX_FULL_ETOOL16 + "print_edit.gif"; //$NON-NLS-1$
	public static final String IMG_PRINT_EDIT_DTOOL16 = PREFIX_FULL_DTOOL16 + "print_edit.gif"; //$NON-NLS-1$
	
	// Images for move action
	public static final String IMG_MOVE_EDIT_ETOOL16 = PREFIX_FULL_ETOOL16 + "move_edit.gif"; //$NON-NLS-1$
	public static final String IMG_MOVE_EDIT_DTOOL16 = PREFIX_FULL_DTOOL16 + "move_edit.gif"; //$NON-NLS-1$

	// Images for rename action
	public static final String IMG_RENAME_EDIT_ETOOL16 = PREFIX_FULL_ETOOL16 + "rename_edit.gif"; //$NON-NLS-1$
	public static final String IMG_RENAME_EDIT_DTOOL16 = PREFIX_FULL_DTOOL16 + "rename_edit.gif"; //$NON-NLS-1$
	
	// Images for save action
	public static final String IMG_SAVE_EDIT_ETOOL16 = PREFIX_FULL_ETOOL16 + "save_edit.gif"; //$NON-NLS-1$
	public static final String IMG_SAVE_EDIT_DTOOL16 = PREFIX_FULL_DTOOL16 + "save_edit.gif"; //$NON-NLS-1$
	
	// Images for refresh action
	public static final String IMG_REFRESH_NAV_ETOOL16 = PREFIX_FULL_ETOOL16 + "refresh_nav.gif"; //$NON-NLS-1$
	public static final String IMG_REFRESH_NAV_DTOOL16 = PREFIX_FULL_DTOOL16 + "refresh_nav.gif"; //$NON-NLS-1$
}
