/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.swt.events.KeyEvent;

public class DiagramGraphicalViewerKeyHandler
extends GraphicalViewerKeyHandler {
    public DiagramGraphicalViewerKeyHandler(GraphicalViewer viewer) {
        super(viewer);
    }

    public boolean keyPressed(KeyEvent event) {
        switch (event.keyCode) {
            case 0x1000007: {
                if (!((event.stateMask & 0x10000) != 0 ? this.navigateEndSibling(event, 8) : this.navigateEndSibling(event, 1))) break;
                return true;
            }
            case 0x1000008: {
                if (!((event.stateMask & 0x10000) != 0 ? this.navigateEndSibling(event, 16) : this.navigateEndSibling(event, 4))) break;
                return true;
            }
            case 0x1000005: {
                if (!((event.stateMask & 0x10000) != 0 ? this.navigatePageSibling(event, 8) : this.navigatePageSibling(event, 1))) break;
                return true;
            }
            case 0x1000006: {
                if (!((event.stateMask & 0x10000) != 0 ? this.navigatePageSibling(event, 16) : this.navigatePageSibling(event, 4))) break;
                return true;
            }
            case 9: {
                if (!((event.stateMask & 0x20000) != 0 ? this.navigateNextHorizontalSibling(this.isViewerMirrored() ? 16 : 8) : this.navigateNextHorizontalSibling(this.isViewerMirrored() ? 8 : 16))) break;
                return true;
            }
        }
        return super.keyPressed(event);
    }

    protected GraphicalEditPart getFocusPart() {
        return (GraphicalEditPart)this.getViewer().getFocusEditPart();
    }

    protected void navigateToPart(EditPart part, KeyEvent event) {
        if (part == null) {
            return;
        }
        if (!part.isSelectable()) {
            this.getViewer().deselectAll();
            this.getViewer().setFocus(part);
        } else if ((event.stateMask & 0x20000) != 0) {
            this.getViewer().appendSelection(part);
            this.getViewer().setFocus(part);
        } else if ((event.stateMask & 0x40000) != 0) {
            this.getViewer().setFocus(part);
        } else {
            this.getViewer().select(part);
        }
        this.getViewer().reveal(part);
    }

    protected List getPartNavigationSiblings() {
        EditPart epParent = this.findParent((EditPart)this.getFocusPart());
        if (epParent != null) {
            return epParent.getChildren();
        }
        return null;
    }

    protected Point getFigureInterestingPoint(IFigure figure) {
        return figure.getBounds().getCenter();
    }

    protected Viewport findViewport(GraphicalEditPart part) {
        if (part == null) {
            return null;
        }
        IFigure figure = null;
        Viewport port = null;
        do {
            if (!((figure = figure == null ? part.getContentPane() : figure.getParent()) instanceof Viewport)) continue;
            port = (Viewport)figure;
            break;
        } while (figure != null);
        return port;
    }

    protected boolean navigatePageSibling(KeyEvent event, int direction) {
        List<GraphicalEditPart> editParts;
        GraphicalEditPart epStart = this.getFocusPart();
        IFigure figure = epStart.getFigure();
        Point pStart = this.getFigureInterestingPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        GraphicalEditPart epParent = (GraphicalEditPart)this.findParent((EditPart)epStart);
        Viewport viewport = this.findViewport(epParent);
        Rectangle bounds = viewport != null ? new Rectangle(viewport.getBounds()) : epParent.getFigure().getClientArea();
        int pageDistance = 0;
        switch (direction) {
            case 1: 
            case 4: {
                pageDistance = bounds.height;
                break;
            }
            case 8: 
            case 16: {
                pageDistance = bounds.width;
            }
        }
        if (epStart instanceof DiagramEditPart) {
            Point location = viewport.getViewLocation().getCopy();
            switch (direction) {
                case 1: {
                    location.translate(0, -pageDistance);
                    break;
                }
                case 4: {
                    location.translate(0, pageDistance);
                    break;
                }
                case 16: {
                    location.translate(pageDistance, 0);
                    break;
                }
                case 8: {
                    location.translate(-pageDistance, 0);
                }
            }
            viewport.setViewLocation(location);
        }
        if ((editParts = this.findPageSibling(this.getPartNavigationSiblings(), pStart, pageDistance, direction, (EditPart)epStart)).isEmpty()) {
            return false;
        }
        if ((event.stateMask & 0x20000) != 0) {
            Iterator<GraphicalEditPart> parts = editParts.iterator();
            while (parts.hasNext()) {
                this.navigateToPart((EditPart)parts.next(), event);
            }
        } else {
            EditPart part = (EditPart)editParts.get(editParts.size() - 1);
            this.navigateToPart(part, event);
        }
        return true;
    }

    protected boolean navigateEndSibling(KeyEvent event, int direction) {
        GraphicalEditPart epStart = this.getFocusPart();
        if (epStart instanceof DiagramEditPart) {
            Viewport viewport = this.findViewport(epStart);
            switch (direction) {
                case 1: 
                case 8: {
                    viewport.setViewLocation(viewport.getHorizontalRangeModel().getMinimum(), viewport.getVerticalRangeModel().getMinimum());
                    break;
                }
                case 4: 
                case 16: {
                    viewport.setViewLocation(viewport.getHorizontalRangeModel().getMaximum(), viewport.getVerticalRangeModel().getMaximum());
                }
            }
        }
        IFigure figure = epStart.getFigure();
        Point pStart = this.getFigureInterestingPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        List<GraphicalEditPart> editParts = this.findEndSibling(this.getPartNavigationSiblings(), pStart, direction, (EditPart)epStart);
        if (editParts.isEmpty()) {
            return false;
        }
        if ((event.stateMask & 0x20000) != 0) {
            Iterator<GraphicalEditPart> parts = editParts.iterator();
            while (parts.hasNext()) {
                this.navigateToPart((EditPart)parts.next(), event);
            }
        } else {
            EditPart part = (EditPart)editParts.get(editParts.size() - 1);
            this.navigateToPart(part, event);
        }
        return true;
    }

    private List<GraphicalEditPart> findPageSibling(List siblings, Point pStart, int pageDistance, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        GraphicalEditPart epFurthest = null;
        ArrayList<GraphicalEditPart> selection = new ArrayList<GraphicalEditPart>();
        int distance = Integer.MAX_VALUE;
        int furthestDistance = 0;
        for (GraphicalEditPart epCurrent : siblings) {
            if (epCurrent == exclude || !epCurrent.getFigure().isVisible() || epCurrent.getFigure().getBounds().isEmpty()) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = this.getFigureInterestingPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (!this.isInDirection(direction, pStart, pCurrent)) continue;
            int d = pCurrent.getDistanceOrthogonal(pStart);
            if (d >= pageDistance) {
                selection.add(epCurrent);
                if (d < distance) {
                    distance = d;
                    epFinal = epCurrent;
                }
            }
            if (d > furthestDistance) {
                epFurthest = epCurrent;
            }
            if (epFinal == null) continue;
            selection.remove(epFinal);
            selection.add(epFinal);
        }
        if (selection.isEmpty() && epFurthest != null) {
            return Collections.singletonList(epFurthest);
        }
        return selection;
    }

    private List<GraphicalEditPart> findEndSibling(List siblings, Point pStart, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        ArrayList<GraphicalEditPart> selection = new ArrayList<GraphicalEditPart>();
        int distance = 0;
        for (GraphicalEditPart epCurrent : siblings) {
            if (epCurrent == exclude || !epCurrent.getFigure().isVisible() || epCurrent.getFigure().getBounds().isEmpty()) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = this.getFigureInterestingPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (!this.isInDirection(direction, pStart, pCurrent)) continue;
            selection.add(epCurrent);
            int d = pCurrent.getDistanceOrthogonal(pStart);
            if (d <= distance) continue;
            distance = d;
            epFinal = epCurrent;
        }
        if (epFinal != null) {
            selection.remove(epFinal);
            selection.add(epFinal);
        }
        return selection;
    }

    private EditPart findParent(EditPart child) {
        if (child instanceof RootEditPart) {
            return child;
        }
        return child.getParent();
    }

    private boolean navigateNextHorizontalSibling(int direction) {
        GraphicalEditPart epStart = this.getFocusEditPart();
        GraphicalEditPart next = null;
        if (epStart instanceof DiagramEditPart) {
            next = this.findClosestHorizontalSibling(epStart.getChildren(), new Point(0, 0), 16, null);
        } else {
            IFigure figure = epStart.getFigure();
            Point pStart = figure.getBounds().getCenter();
            figure.translateToAbsolute((Translatable)pStart);
            next = this.findClosestHorizontalSibling(this.getNavigationSiblings(), pStart, direction, (EditPart)epStart);
        }
        if (next == null) {
            return false;
        }
        this.getViewer().select((EditPart)next);
        this.getViewer().reveal((EditPart)next);
        return true;
    }

    private GraphicalEditPart findClosestHorizontalSibling(List siblings, Point pStart, int direction, EditPart exclude) {
        int xCycle;
        GraphicalEditPart epFinal = null;
        GraphicalEditPart epCycle = null;
        GraphicalEditPart epCycleVertical = null;
        int distanceX = Integer.MAX_VALUE;
        int distanceY = Integer.MAX_VALUE;
        int finalY = 0;
        boolean goVertical = false;
        int yCycle = xCycle = direction == 16 ? Integer.MAX_VALUE : 0;
        int yCycleVertical = xCycle;
        for (GraphicalEditPart epCurrent : siblings) {
            if (epCurrent == exclude || !epCurrent.isSelectable()) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = figure.getBounds().getCenter();
            figure.translateToAbsolute((Translatable)pCurrent);
            int dx = pCurrent.x - pStart.x;
            if (!goVertical && (direction == 16 && dx > 0 || direction == 8 && dx < 0)) {
                int abs_dx = Math.abs(dx);
                if (abs_dx < distanceX) {
                    distanceX = abs_dx;
                    finalY = pCurrent.y;
                    epFinal = epCurrent;
                } else if (abs_dx == distanceX && (direction == 16 && pCurrent.y < finalY || direction == 8 && pCurrent.y > finalY)) {
                    finalY = pCurrent.y;
                    epFinal = epCurrent;
                }
            }
            if (dx == 0) {
                int dy = pCurrent.y - pStart.y;
                if (direction == 16 && dy > 0 || direction == 8 && dy < 0) {
                    goVertical = true;
                    int abs_dy = Math.abs(dy);
                    if (abs_dy < distanceY) {
                        distanceY = abs_dy;
                        epFinal = epCurrent;
                    }
                }
            }
            if (epFinal != null) continue;
            if (dx == 0) {
                if (direction == 16 && pCurrent.y < yCycleVertical) {
                    yCycleVertical = pCurrent.y;
                    epCycleVertical = epCurrent;
                    continue;
                }
                if (direction != 8 || pCurrent.y <= yCycleVertical) continue;
                yCycleVertical = pCurrent.y;
                epCycleVertical = epCurrent;
                continue;
            }
            boolean assign = false;
            if (direction == 16) {
                if (pCurrent.x < xCycle) {
                    assign = true;
                } else if (pCurrent.x == xCycle && pCurrent.y < yCycle) {
                    assign = true;
                }
            } else if (direction == 8) {
                if (pCurrent.x > xCycle) {
                    assign = true;
                } else if (pCurrent.x == xCycle && pCurrent.y > yCycle) {
                    assign = true;
                }
            }
            if (!assign) continue;
            xCycle = pCurrent.x;
            yCycle = pCurrent.y;
            epCycle = epCurrent;
        }
        if (epFinal == null) {
            if (epCycle == null) {
                return epCycleVertical;
            }
            return epCycle;
        }
        return epFinal;
    }

    private boolean isInDirection(int direction, Point start, Point point) {
        switch (direction) {
            case 8: {
                return start.x > point.x;
            }
            case 16: {
                return start.x < point.x;
            }
            case 1: {
                return start.y > point.y;
            }
            case 4: {
                return start.y < point.y;
            }
        }
        return false;
    }
}

