/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests.framework;

import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RecursiveContaimentNotificationCreatorTest
extends TestCase {
    @Before
    public void setUp() {
        try {
            super.setUp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @After
    public void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateNotificationForComposites() {
        EPackage root = EcoreFactory.eINSTANCE.createEPackage();
        EClass containerCls = EcoreFactory.eINSTANCE.createEClass();
        root.getEClassifiers().add((Object)containerCls);
        EClass childCls = EcoreFactory.eINSTANCE.createEClass();
        root.getEClassifiers().add((Object)childCls);
        EReference conRef = EcoreFactory.eINSTANCE.createEReference();
        conRef.setContainment(true);
        conRef.setEType((EClassifier)childCls);
        conRef.setLowerBound(0);
        conRef.setUpperBound(1);
        conRef.setName("contained");
        EAttribute attr = EcoreFactory.eINSTANCE.createEAttribute();
        attr.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        childCls.getEStructuralFeatures().add((Object)attr);
        containerCls.getEStructuralFeatures().add((Object)conRef);
        DynamicEObjectImpl container = new DynamicEObjectImpl(containerCls);
        DynamicEObjectImpl child = new DynamicEObjectImpl(childCls);
        container.eSet((EStructuralFeature)conRef, (Object)child);
        child.eSet((EStructuralFeature)attr, (Object)2);
        ENotificationImpl noti = new ENotificationImpl((InternalEObject)container, 3, (EStructuralFeature)conRef, null, (Object)child);
        Collection list = EventManagerFactory.eINSTANCE.createNotificationForComposites((Notification)noti);
        RecursiveContaimentNotificationCreatorTest.assertTrue((String)("Get " + list.size() + " events, expected 2"), (list.size() == 2 ? 1 : 0) != 0);
    }

    public void testCreateNotificationForMultipleInsertedElements() {
        EPackage root = EcoreFactory.eINSTANCE.createEPackage();
        EClass container = EcoreFactory.eINSTANCE.createEClass();
        root.getEClassifiers().add((Object)container);
        container.setName("container");
        EReference conRef = EcoreFactory.eINSTANCE.createEReference();
        conRef.setName("conRef");
        conRef.setContainment(true);
        conRef.setLowerBound(0);
        conRef.setUpperBound(5);
        container.getEStructuralFeatures().add((Object)conRef);
        EClass child = EcoreFactory.eINSTANCE.createEClass();
        root.getEClassifiers().add((Object)child);
        child.setName("child");
        conRef.setEType((EClassifier)child);
        DynamicEObjectImpl con = new DynamicEObjectImpl(container);
        BasicEList list = new BasicEList();
        int i = 0;
        while (i < 5) {
            list.add((Object)new DynamicEObjectImpl(child));
            ++i;
        }
        con.eSet((EStructuralFeature)conRef, (Object)list);
        BasicEList l = new BasicEList();
        l.add((Object)con);
        ENotificationImpl n = new ENotificationImpl((InternalEObject)new DynamicEObjectImpl(container), 3, (EStructuralFeature)conRef, null, (Object)con);
        Collection result = EventManagerFactory.eINSTANCE.createNotificationForComposites((Notification)n);
        RecursiveContaimentNotificationCreatorTest.assertEquals((String)"Get not expected events", (int)2, (int)result.size());
        Iterator iterator = result.iterator();
        Notification n1 = (Notification)iterator.next();
        Notification n2 = (Notification)iterator.next();
        RecursiveContaimentNotificationCreatorTest.assertTrue((String)"Expect Add and Add_Many", (n1.getEventType() == 3 && n2.getEventType() == 5 || n2.getEventType() == 3 && n1.getEventType() == 5 ? 1 : 0) != 0);
        BasicEList list2 = new BasicEList();
        int i2 = 0;
        while (i2 < 1) {
            list2.add((Object)new DynamicEObjectImpl(child));
            ++i2;
        }
        con.eSet((EStructuralFeature)conRef, (Object)list2);
        n = new ENotificationImpl((InternalEObject)new DynamicEObjectImpl(container), 3, (EStructuralFeature)conRef, null, (Object)con);
        result = EventManagerFactory.eINSTANCE.createNotificationForComposites((Notification)n);
        RecursiveContaimentNotificationCreatorTest.assertEquals((String)"Get not expected Events", (int)2, (int)result.size());
        iterator = result.iterator();
        n1 = (Notification)iterator.next();
        n2 = (Notification)iterator.next();
        RecursiveContaimentNotificationCreatorTest.assertTrue((String)"Expect Add and Add", (n1.getEventType() == 3 && n2.getEventType() == 3 ? 1 : 0) != 0);
    }

    public void testContainmentAdapter() {
        ResourceSetImpl set = new ResourceSetImpl();
        ResourceImpl r = new ResourceImpl();
        set.getResources().add((Object)r);
        EClass cls = EcoreFactory.eINSTANCE.createEClass();
        EAttribute attr = EcoreFactory.eINSTANCE.createEAttribute();
        attr.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        cls.getEStructuralFeatures().add((Object)attr);
        EReference containmentRef = EcoreFactory.eINSTANCE.createEReference();
        containmentRef.setContainment(true);
        containmentRef.setEType((EClassifier)cls);
        cls.getEStructuralFeatures().add((Object)containmentRef);
        EPackage pkg = EcoreFactory.eINSTANCE.createEPackage();
        pkg.getEClassifiers().add((Object)cls);
        DynamicEObjectImpl anObject = new DynamicEObjectImpl(cls);
        DynamicEObjectImpl anotherObject = new DynamicEObjectImpl(cls);
        r.getContents().add((Object)anObject);
        r.getContents().add((Object)anotherObject);
        EventManager m = EventManagerFactory.eINSTANCE.createEventManagerFor((ResourceSet)set);
        EventFilter filter = EventManagerFactory.eINSTANCE.createStructuralFeatureFilter((EStructuralFeature)attr);
        class Adapter
        extends AdapterImpl {
            public int count = 0;

            Adapter() {
            }

            public void notifyChanged(Notification msg) {
                ++this.count;
            }
        }
        Adapter adapter = new Adapter();
        m.subscribe(filter, (org.eclipse.emf.common.notify.Adapter)adapter);
        anObject.eSet((EStructuralFeature)containmentRef, (Object)anotherObject);
        adapter.count = 0;
        anObject.eSet((EStructuralFeature)attr, (Object)10);
        anotherObject.eSet((EStructuralFeature)attr, (Object)10);
        RecursiveContaimentNotificationCreatorTest.assertEquals((String)"Expected to see both object modifications", (int)2, (int)adapter.count);
        anObject.eUnset((EStructuralFeature)containmentRef);
        RecursiveContaimentNotificationCreatorTest.assertTrue((boolean)r.getContents().contains((Object)anObject));
        RecursiveContaimentNotificationCreatorTest.assertTrue((boolean)r.getContents().contains((Object)anotherObject));
        adapter.count = 0;
        anObject.eSet((EStructuralFeature)attr, (Object)20);
        anotherObject.eSet((EStructuralFeature)attr, (Object)20);
        RecursiveContaimentNotificationCreatorTest.assertEquals((String)"Still expected to see both object modifications", (int)2, (int)adapter.count);
    }
}

