/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.filters;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.eventmanager.filters.AbstractEventFilter;

public class ClassFilter
extends AbstractEventFilter {
    protected EClass wantedClass;

    public ClassFilter(EClass clazz, boolean negated) {
        super(negated);
        this.setWantedClass(clazz);
    }

    public EClass getWantedClass() {
        return this.wantedClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.wantedClass == null ? 0 : this.wantedClass.hashCode());
        if (this.isNegated()) {
            result *= 31;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassFilter other = (ClassFilter)obj;
        if (this.wantedClass == null ? other.wantedClass != null : !this.wantedClass.equals(other.wantedClass)) {
            return false;
        }
        return this.isNegated() == other.isNegated();
    }

    public boolean matchesFor(Notification event) {
        Object notifier = event.getNotifier();
        if (notifier == null || !(notifier instanceof EObject)) {
            return false;
        }
        EClass cls = ((EObject)notifier).eClass();
        return this.matches(cls);
    }

    protected boolean matches(EClass cls) {
        return cls.equals(this.getWantedClass());
    }

    private void setWantedClass(EClass newWantedClass) {
        this.wantedClass = newWantedClass;
    }

    public String toString() {
        if (this.getWantedClass() != null) {
            return String.valueOf(this.isNegated() ? "negated " : "") + "wantedClass :" + this.getWantedClass().toString();
        }
        return "empty ClassFilter";
    }

    public ClassFilter clone() {
        return new ClassFilter(this.getWantedClass(), this.isNegated());
    }

    public Object getFilterCriterion() {
        return this.getWantedClass();
    }
}

