/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.clazz.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.sirius.uml.diagram.clazz.Activator;
import org.eclipse.papyrus.sirius.uml.diagram.clazz.internal.ui.dialog.AssociationSelectionDialog;
import org.eclipse.papyrus.sirius.uml.diagram.clazz.internal.utils.InstanceSpecificationLinkUtils;
import org.eclipse.papyrus.sirius.uml.diagram.clazz.services.AssociationEndDecoratorUtils;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AssociationClassServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AssociationServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.ElementServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.ILabelConstants;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.LabelServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.NodeInverseRefsServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.OperationServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.RepresentationQuerier;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.StereotypeServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.ElementDomainBasedEdgeCreationChecker;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeArrows;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.GeneralizationSet;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InformationItem;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.ValueSpecification;

public class ClassDiagramServices
extends AbstractDiagramServices {
    public static final ClassDiagramServices INSTANCE = new ClassDiagramServices();
    private static final String CANCEL_LABEL = "Cancel";
    private static final String OK_LABEL = "OK";
    private static final String ANNOTATION_GENERIC_SOURCE = "org.eclipse.papyrus";
    private static final String ANNOTATION_INSTANCE_END_SOURCE = "InstanceEnd";
    private static final int INSTANCE_SPECIFICATION_LINK__SOURCE_INDEX = 0;
    private static final int INSTANCE_SPECIFICATION_LINK__TARGET_INDEX = 1;
    private static final String ANNOTATION_DETAIL_KEY = "nature";
    private static final String ANNOTATION_DETAIL_VALUE = "UML_Nature";
    private static final String UNDERSCORE = "_";
    private static final int GENERALIZATION_SET__SOURCE_INDEX = 0;
    private static final int GENERALIZATION_SET__TARGET_INDEX = 1;
    private static final String NESTED_CLASSIFIER = "nestedClassifier";
    private static final String PACKAGED_ELEMENT = "packagedElement";

    public EObject dndElement(EObject semanticObjectToDrop, EObject targetContainerView) {
        if (targetContainerView instanceof DSemanticDecorator && semanticObjectToDrop instanceof PackageableElement) {
            PackageableElement element = (PackageableElement)semanticObjectToDrop;
            EObject target = ((DSemanticDecorator)targetContainerView).getTarget();
            Model targetModel = null;
            if (target instanceof Model) {
                targetModel = (Model)target;
            }
            if (targetModel != null) {
                targetModel.getPackagedElements().add((Object)element);
            }
        }
        return semanticObjectToDrop;
    }

    private static EObject getDiagramRoot(EObject sourceView) {
        DDiagramElement diagramElement = (DDiagramElement)sourceView;
        DSemanticDiagram diagram = (DSemanticDiagram)diagramElement.getParentDiagram();
        EObject root = diagram.getTarget();
        return root;
    }

    public EObject createStructuredClassifierCD(Element parent, String type, DSemanticDecorator targetView) {
        EObject result = null;
        if (parent == null) {
            Activator.log.warn("Unable to create an element on nothing");
        } else if (parent instanceof Package) {
            result = this.createCD(parent, type, PACKAGED_ELEMENT, targetView);
        } else if (parent instanceof Class) {
            result = this.createCD(parent, type, NESTED_CLASSIFIER, targetView);
        } else if (parent instanceof Interface) {
            result = this.createCD(parent, type, NESTED_CLASSIFIER, targetView);
        }
        return result;
    }

    public EObject createCD(Element parent, String type, String referenceName, DSemanticDecorator targetView) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        return commonDiagramServices.createElement(parent, type, referenceName, targetView);
    }

    public EObject createDomainBasedEdgeCD(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        return domainBasedEdgeServices.createDomainBasedEdge(source, target, type, containementReferenceName, sourceView, targetView, (IDomainBasedEdgeContainerProvider)new ElementDomainBasedEdgeContainerProvider((IEditableChecker)new EditableChecker()));
    }

    public EObject createSharedAssociation(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        EObject newObject = domainBasedEdgeServices.createDomainBasedEdge(source, target, type, containementReferenceName, sourceView, targetView, (IDomainBasedEdgeContainerProvider)new ElementDomainBasedEdgeContainerProvider((IEditableChecker)new EditableChecker()));
        if (newObject instanceof Association) {
            Association association = (Association)newObject;
            Property firstMember = (Property)association.getMemberEnds().get(0);
            firstMember.setAggregation(AggregationKind.SHARED_LITERAL);
        }
        return newObject;
    }

    public EObject createCompositeAssociation(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        EObject newObject = domainBasedEdgeServices.createDomainBasedEdge(source, target, type, containementReferenceName, sourceView, targetView, (IDomainBasedEdgeContainerProvider)new ElementDomainBasedEdgeContainerProvider((IEditableChecker)new EditableChecker()));
        if (newObject instanceof Association) {
            Association association = (Association)newObject;
            Property firstMember = (Property)association.getMemberEnds().get(0);
            firstMember.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        }
        return newObject;
    }

    public boolean canCreateCD(EObject container, EClass objectToCreate, String containmentReferenceName) {
        return super.canCreate(container, objectToCreate, containmentReferenceName);
    }

    public boolean canCreateDomainBasedEdgeCD(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        boolean canCreate = true;
        RepresentationQuerier representationQuery = new RepresentationQuerier((Object)((DDiagramElement)sourceView).getParentDiagram());
        CheckStatus canCreateStatus = new ElementDomainBasedEdgeCreationChecker().canCreate(source, target, type, containementReferenceName, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
        canCreate = canCreateStatus.isValid();
        if (canCreate) {
            ElementDomainBasedEdgeContainerProvider containerProvider = new ElementDomainBasedEdgeContainerProvider((IEditableChecker)new EditableChecker());
            EClass eClass = UMLHelper.toEClass((String)type);
            if (eClass != null) {
                EObject newInstance = UMLFactory.eINSTANCE.create(eClass);
                EObject container = containerProvider.getContainer(source, target, newInstance, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
                canCreate = container != null;
            }
        }
        return canCreate;
    }

    public Collection<Abstraction> abstraction_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return ClassDiagramServices.getAllAbstractions(pack);
        }
        return Collections.emptyList();
    }

    private static final Collection<Abstraction> getAllAbstractions(Package pack) {
        HashSet<Abstraction> abstractions = new HashSet<Abstraction>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                abstractions.addAll(ClassDiagramServices.getAllAbstractions((Package)current));
            }
            if (!(current instanceof Abstraction)) continue;
            abstractions.add((Abstraction)current);
        }
        return abstractions;
    }

    public boolean abstraction_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Enumeration || newSource instanceof Interface || newSource instanceof PrimitiveType;
    }

    public boolean abstraction_canReconnectTarget(Element context, Element newTarget) {
        return this.abstraction_canReconnectSource(context, newTarget);
    }

    public void abstraction_reconnectSource(Element context, Element oldSource, Element newSource) {
        this.dependency_reconnectSource(context, oldSource, newSource);
    }

    public void abstraction_reconnectTarget(Element context, Element oldTarget, Element newTarget) {
        this.dependency_reconnectTarget(context, oldTarget, newTarget);
    }

    public Collection<Association> association_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return ClassDiagramServices.getAllAssociations(pack);
        }
        return Collections.emptyList();
    }

    private static final Collection<Association> getAllAssociations(Package pack) {
        HashSet<Association> associations = new HashSet<Association>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                associations.addAll(ClassDiagramServices.getAllAssociations((Package)current));
            }
            if (!(current instanceof Association)) continue;
            associations.add((Association)current);
        }
        return associations;
    }

    public Type association_getSourceType(Association association) {
        return AssociationServices.INSTANCE.getSourceType(association);
    }

    public Type association_getTargetType(Association association) {
        return AssociationServices.INSTANCE.getTargetType(association);
    }

    public String association_getBeginLabel(Association association) {
        return LabelServices.INSTANCE.association_getBeginLabel(association);
    }

    public String association_getEndLabel(Association association) {
        return LabelServices.INSTANCE.association_getEndLabel(association);
    }

    public boolean association_canReconnectSource(Association context, Element newSource) {
        return AssociationServices.INSTANCE.canReconnectSource((Element)context, newSource);
    }

    public boolean association_canReconnectTarget(Association context, Element newTarget) {
        return AssociationServices.INSTANCE.canReconnectTarget((Element)context, newTarget);
    }

    public void association_reconnectSource(Association context, Classifier oldSource, Classifier newSource) {
        AssociationServices.INSTANCE.reconnectSource(context, oldSource, newSource);
    }

    public void association_reconnectTarget(Association context, Classifier oldTarget, Classifier newTarget) {
        AssociationServices.INSTANCE.reconnectTarget(context, oldTarget, newTarget);
    }

    public EdgeArrows association_getSourceDecorator(Association association) {
        return AssociationEndDecoratorUtils.getSourceDecorator(association);
    }

    public EdgeArrows association_getTargetDecorator(Association association) {
        return AssociationEndDecoratorUtils.getTargetDecorator(association);
    }

    public Collection<AssociationClass> associationClass_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return ClassDiagramServices.getAllAssociationClasses(pack);
        }
        return Collections.emptyList();
    }

    private static final Collection<AssociationClass> getAllAssociationClasses(Package pack) {
        HashSet<AssociationClass> associationClasses = new HashSet<AssociationClass>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                associationClasses.addAll(ClassDiagramServices.getAllAssociationClasses((Package)current));
            }
            if (!(current instanceof AssociationClass)) continue;
            associationClasses.add((AssociationClass)current);
        }
        return associationClasses;
    }

    public Type associationClass_getSourceType(AssociationClass associationClass) {
        return AssociationClassServices.INSTANCE.getSourceType(associationClass);
    }

    public Type associationClass_getTargetType(AssociationClass associationClass) {
        return AssociationClassServices.INSTANCE.getTargetType(associationClass);
    }

    public String associationClass_getBeginLabel(AssociationClass associationClass) {
        return LabelServices.INSTANCE.associationClass_getBeginLabel(associationClass);
    }

    public String associationClass_getEndLabel(AssociationClass associationClass) {
        return LabelServices.INSTANCE.associationClass_getEndLabel(associationClass);
    }

    public Collection<AssociationClass> associationClass_getVisibleAssociationClasses(EObject context, DSemanticDiagram diagram) {
        HashSet<AssociationClass> associationClasses = new HashSet<AssociationClass>();
        if (diagram.isSynchronized()) {
            associationClasses.addAll(this.associationClass_getSemanticCandidates(context));
        } else {
            for (DEdge current : diagram.getEdges()) {
                if (!"CD_AssociationClass_Link".equals(current.getMapping().getName()) || !(current.getTarget() instanceof AssociationClass)) continue;
                associationClasses.add((AssociationClass)current.getTarget());
            }
        }
        return associationClasses;
    }

    public boolean associationClass_canReconnectSource(AssociationClass context, Element newSource) {
        return AssociationClassServices.INSTANCE.canReconnectSource((Element)context, newSource);
    }

    public boolean associationClass_canReconnectTarget(AssociationClass context, Element newTarget) {
        return AssociationClassServices.INSTANCE.canReconnectTarget((Element)context, newTarget);
    }

    public void associationClass_reconnectSource(AssociationClass context, Classifier oldSource, Classifier newSource) {
        AssociationClassServices.INSTANCE.reconnectSource(context, oldSource, newSource);
    }

    public void associationClass_reconnectTarget(AssociationClass context, Classifier oldTarget, Classifier newTarget) {
        AssociationClassServices.INSTANCE.reconnectTarget(context, oldTarget, newTarget);
    }

    public Collection<EObject> constraint_getSemanticCandidates(EObject semanticContext, DDiagram diagram) {
        HashSet<EObject> constraints = new HashSet<EObject>();
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            constraints.addAll((Collection<EObject>)pack.getOwnedRules());
            for (PackageableElement current : pack.getPackagedElements()) {
                if (current instanceof Package || !(current instanceof Namespace)) continue;
                constraints.addAll((Collection<EObject>)((Namespace)current).getOwnedRules());
            }
        }
        return constraints;
    }

    public String constraint_getFirstSpecificationBody(Constraint constraint) {
        OpaqueExpression opaqueEsp;
        ValueSpecification valueSpec = constraint.getSpecification();
        if (valueSpec instanceof OpaqueExpression && !(opaqueEsp = (OpaqueExpression)valueSpec).getBodies().isEmpty()) {
            return (String)opaqueEsp.getBodies().get(0);
        }
        return "";
    }

    public void constraint_setFirstSpecificationBody(Constraint constraint, String newBody) {
        ValueSpecification valueSpec = constraint.getSpecification();
        if (valueSpec instanceof OpaqueExpression) {
            OpaqueExpression opaqueEsp = (OpaqueExpression)valueSpec;
            if (opaqueEsp.getBodies().isEmpty() && opaqueEsp.getLanguages().size() == 1) {
                opaqueEsp.getBodies().add((Object)newBody);
            } else if (opaqueEsp.getBodies().size() > 0 && opaqueEsp.getBodies().size() == opaqueEsp.getLanguages().size()) {
                opaqueEsp.getBodies().remove(0);
                opaqueEsp.getBodies().add(0, (Object)newBody);
            } else {
                Activator.log.info("We were not able to set the new body into the Constraint because the number of language is not the same than the number of body");
            }
        }
    }

    public static void containmentLink_creation(EObject context, Element source, Element target) {
        if (source instanceof Package && target instanceof PackageableElement) {
            ((Package)source).getPackagedElements().add((Object)((PackageableElement)target));
        } else if (source instanceof Class && target instanceof Classifier) {
            ((Class)source).getNestedClassifiers().add((Object)((Classifier)target));
        }
    }

    public boolean containmentLink_isValidSourceAndTarget(EObject context, EObject sourceView, EObject targetView, Element source, Element target) {
        boolean isValid = false;
        if (source == target) {
            return false;
        }
        if (source instanceof Package) {
            isValid = target instanceof PackageableElement;
        } else if (source instanceof Class) {
            isValid = target instanceof Classifier;
        }
        if (isValid) {
            isValid = !((Namespace)source).allNamespaces().contains((Object)target);
        }
        EObject graphicalParent = ((DNodeContainer)targetView).eContainer();
        isValid = graphicalParent instanceof DSemanticDiagram;
        return isValid;
    }

    public static List<?> containmentLink_getTarget(Element source) {
        if (source instanceof Class) {
            return ((Class)source).getNestedClassifiers();
        }
        if (source instanceof Package) {
            return ((Package)source).getPackagedElements();
        }
        return null;
    }

    public boolean containmentLink_canReconnectSource(Element oldSource, DNodeContainer newSourceView, Element newSource, DNodeContainer otherEnd) {
        Element target = (Element)otherEnd.getTarget();
        return this.containmentLink_isValidSourceAndTarget(null, null, (EObject)otherEnd, newSource, target);
    }

    public boolean containmentLink_canReconnectTarget(Element oldTarget, DNodeContainer newTargetView, Element newTarget, DNodeContainer otherEnd) {
        Element source = (Element)otherEnd.getTarget();
        return this.containmentLink_isValidSourceAndTarget(null, null, (EObject)newTargetView, source, newTarget);
    }

    public void containmentLink_reconnectSource(Element context, DEdge edgeView, EdgeTarget oldSourceView, EdgeTarget newSourceView, Element oldSource, Element newSource) {
        Element targetElement = (Element)((DNodeContainer)edgeView.getTargetNode()).getTarget();
        ClassDiagramServices.containmentLink_creation(null, newSource, targetElement);
    }

    public void containmentLink_reconnectTarget(Element context, DEdge edgeView, EdgeTarget oldTargetView, EdgeTarget newTargetView, Element oldTarget, Element newTarget) {
        EObject graphicalParent = ((DNodeContainer)oldTargetView).eContainer();
        Assert.isTrue((boolean)(graphicalParent instanceof DSemanticDiagram));
        EObject semanticGraphicalParent = ((DSemanticDiagram)graphicalParent).getTarget();
        Assert.isTrue((semanticGraphicalParent instanceof Package && oldTarget instanceof PackageableElement ? 1 : 0) != 0);
        ((Package)semanticGraphicalParent).getPackagedElements().add((Object)((PackageableElement)oldTarget));
        ClassDiagramServices.containmentLink_creation(null, context, newTarget);
    }

    public boolean contextLink_isValidSourceAndTarget(EObject context, EObject sourceView, EObject targetView, Element source, Element target) {
        boolean isValid = false;
        if (source == target) {
            return false;
        }
        if (source instanceof Constraint) {
            isValid = target instanceof Namespace;
        }
        return isValid;
    }

    public Collection<Dependency> dependency_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return ClassDiagramServices.getAllDependencies(pack);
        }
        return Collections.emptyList();
    }

    private static final Collection<Dependency> getAllDependencies(Package pack) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                dependencies.addAll(ClassDiagramServices.getAllDependencies((Package)current));
            }
            if (!(current instanceof Dependency)) continue;
            dependencies.add((Dependency)current);
        }
        return dependencies;
    }

    public boolean dependency_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Enumeration || newSource instanceof Interface || newSource instanceof Package || newSource instanceof PrimitiveType;
    }

    public boolean dependency_canReconnectTarget(Element context, Element newTarget) {
        return this.dependency_canReconnectSource(context, newTarget);
    }

    public void dependency_reconnectSource(Element context, Element oldSource, Element newSource) {
        Dependency dependency = (Dependency)context;
        dependency.getClients().remove((Object)oldSource);
        dependency.getClients().add((Object)((NamedElement)newSource));
        Package newOwner = newSource.getNearestPackage();
        if (dependency.getOwner() != newOwner) {
            newOwner.getPackagedElements().add((Object)dependency);
        }
    }

    public void dependency_reconnectTarget(Element context, Element oldTarget, Element newTarget) {
        Dependency dependencyEdge = (Dependency)context;
        dependencyEdge.getSuppliers().remove((Object)oldTarget);
        dependencyEdge.getSuppliers().add((Object)((NamedElement)newTarget));
    }

    public Collection<ElementImport> elementImport_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return ClassDiagramServices.getAllElementImports(namespace);
        }
        return Collections.emptyList();
    }

    private static final Collection<ElementImport> getAllElementImports(Namespace namespace) {
        HashSet<ElementImport> elementImports = new HashSet<ElementImport>();
        elementImports.addAll((Collection<ElementImport>)namespace.getElementImports());
        for (NamedElement current : namespace.getOwnedMembers()) {
            if (!(current instanceof Namespace)) continue;
            elementImports.addAll(ClassDiagramServices.getAllElementImports((Namespace)current));
        }
        return elementImports;
    }

    public boolean elementImport_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Enumeration || newSource instanceof Interface || newSource instanceof Package || newSource instanceof PrimitiveType;
    }

    public boolean elementImport_canReconnectTarget(Element context, Element newTarget) {
        return this.elementImport_canReconnectSource(context, newTarget);
    }

    public void elementImport_reconnectSource(Element context, Element oldSource, Element newSource) {
        ElementImport elementImport = (ElementImport)context;
        ((Namespace)oldSource).getElementImports().remove((Object)elementImport);
        ((Namespace)newSource).getElementImports().add((Object)elementImport);
    }

    public void elementImport_reconnectTarget(Element context, Element oldTarget, Element newTarget) {
        ElementImport elementImportEdge = (ElementImport)context;
        elementImportEdge.setImportedElement((PackageableElement)newTarget);
    }

    public Collection<Generalization> generalization_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return ClassDiagramServices.getAllGeneralizations(namespace);
        }
        return Collections.emptyList();
    }

    private static final Collection<Generalization> getAllGeneralizations(Namespace namespace) {
        HashSet<Generalization> generalizations = new HashSet<Generalization>();
        for (NamedElement current : namespace.getOwnedMembers()) {
            if (current instanceof Classifier) {
                generalizations.addAll((Collection<Generalization>)((Classifier)current).getGeneralizations());
            }
            if (!(current instanceof Namespace)) continue;
            generalizations.addAll(ClassDiagramServices.getAllGeneralizations((Namespace)current));
        }
        return generalizations;
    }

    public boolean generalization_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Interface || newSource instanceof Enumeration || newSource instanceof PrimitiveType;
    }

    public boolean generalization_canReconnectTarget(Element context, Element newTarget) {
        return this.generalization_canReconnectSource(context, newTarget);
    }

    public void generalization_reconnectSource(Element context, Element oldSource, Element newSource) {
        Generalization generalization = (Generalization)context;
        ((Classifier)oldSource).getGeneralizations().remove((Object)generalization);
        ((Classifier)newSource).getGeneralizations().add((Object)generalization);
    }

    public void generalization_reconnectTarget(Element context, Element oldTarget, Element newTarget) {
        Generalization generalizationEdge = (Generalization)context;
        generalizationEdge.setGeneral((Classifier)newTarget);
    }

    public Collection<GeneralizationSet> generalizationSet_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return ClassDiagramServices.getAllGeneralizationSets(pack);
        }
        return Collections.emptyList();
    }

    private static final Collection<GeneralizationSet> getAllGeneralizationSets(Package pack) {
        HashSet<GeneralizationSet> generalizationSets = new HashSet<GeneralizationSet>();
        for (NamedElement current : pack.getPackagedElements()) {
            if (current instanceof GeneralizationSet) {
                generalizationSets.add((GeneralizationSet)current);
            }
            if (!(current instanceof Package)) continue;
            generalizationSets.addAll(ClassDiagramServices.getAllGeneralizationSets((Package)current));
        }
        return generalizationSets;
    }

    public Generalization generalizationSet_getSource(GeneralizationSet generalizationSet) {
        if (generalizationSet.getGeneralizations().size() >= 1) {
            return (Generalization)generalizationSet.getGeneralizations().get(0);
        }
        return null;
    }

    public Generalization generalizationSet_getTarget(GeneralizationSet generalizationSet) {
        if (generalizationSet.getGeneralizations().size() >= 2) {
            return (Generalization)generalizationSet.getGeneralizations().get(1);
        }
        return null;
    }

    public void generalizationSet_reconnectSource(GeneralizationSet generalizationSet, Generalization oldSource, Generalization newSource) {
        generalizationSet.getGeneralizations().remove((Object)oldSource);
        generalizationSet.getGeneralizations().add(0, (Object)newSource);
        newSource.getNearestPackage().getPackagedElements().add((Object)generalizationSet);
        String oldSourceName = oldSource.getGeneral().getName();
        String newSourceName = newSource.getGeneral().getName();
        String newName = generalizationSet.getName().replace(oldSourceName, newSourceName);
        generalizationSet.setName(newName);
    }

    public void generalizationSet_reconnectTarget(GeneralizationSet generalizationSet, Generalization oldTarget, Generalization newTarget) {
        generalizationSet.getGeneralizations().remove((Object)oldTarget);
        generalizationSet.getGeneralizations().add(1, (Object)newTarget);
        String oldTargetName = oldTarget.getGeneral().getName();
        String newTargetName = newTarget.getGeneral().getName();
        String newName = generalizationSet.getName().replace(oldTargetName, newTargetName);
        generalizationSet.setName(newName);
    }

    public Collection<InformationFlow> informationFlow_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package namespace = (Package)semanticContext;
            return ClassDiagramServices.getAllInformationFlows(namespace);
        }
        return Collections.emptyList();
    }

    private static final Collection<InformationFlow> getAllInformationFlows(Package namespace) {
        HashSet<InformationFlow> informationFlows = new HashSet<InformationFlow>();
        for (NamedElement current : namespace.getPackagedElements()) {
            if (current instanceof InformationFlow) {
                informationFlows.add((InformationFlow)current);
            }
            if (!(current instanceof Package)) continue;
            informationFlows.addAll(ClassDiagramServices.getAllInformationFlows((Package)current));
        }
        return informationFlows;
    }

    public boolean informationFlow_canReconnectSource(InformationFlow context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Enumeration || newSource instanceof Interface || newSource instanceof Package || newSource instanceof PrimitiveType;
    }

    public boolean informationFlow_canReconnectTarget(InformationFlow context, Element newTarget) {
        return this.informationFlow_canReconnectSource(context, newTarget);
    }

    public void informationFlow_reconnectSource(InformationFlow context, NamedElement oldSource, NamedElement newSource) {
        context.getInformationSources().remove((Object)oldSource);
        context.getInformationSources().add((Object)newSource);
        Package owner = newSource.getNearestPackage();
        owner.getPackagedElements().add((Object)context);
    }

    public void informationFlow_reconnectTarget(InformationFlow context, NamedElement oldTarget, NamedElement newTarget) {
        context.getInformationTargets().remove((Object)oldTarget);
        context.getInformationTargets().add((Object)newTarget);
    }

    public Collection<InstanceSpecification> instanceSpecificationLink_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package namespace = (Package)semanticContext;
            return this.getAllInstanceSpecificationLinks(namespace);
        }
        return Collections.emptyList();
    }

    private final Collection<InstanceSpecification> getAllInstanceSpecificationLinks(Package pack) {
        HashSet<InstanceSpecification> instanceSpecifications = new HashSet<InstanceSpecification>();
        for (NamedElement current : pack.getPackagedElements()) {
            if (this.instanceSpecification_isLink((EObject)current)) {
                instanceSpecifications.add((InstanceSpecification)current);
            }
            if (!(current instanceof Package)) continue;
            instanceSpecifications.addAll(this.getAllInstanceSpecificationLinks((Package)current));
        }
        return instanceSpecifications;
    }

    public boolean instanceSpecification_isLink(EObject elem) {
        if (elem instanceof InstanceSpecification) {
            InstanceSpecification instanceSpecification = (InstanceSpecification)elem;
            return instanceSpecification.getEAnnotation(ANNOTATION_INSTANCE_END_SOURCE) != null;
        }
        return false;
    }

    public boolean instanceSpecification_isNode(Element elem) {
        return !this.instanceSpecification_isLink((EObject)elem);
    }

    public InstanceSpecification instanceSpecificationLink_createInstanceSpecificationLink(EObject context, EObject sourceView, InstanceSpecification source, InstanceSpecification target) {
        ServicesRegistry registry = this.getServiceRegistry(context);
        InstanceSpecification instanceSpecification = null;
        if (registry != null) {
            AssociationSelectionDialog dialog = new AssociationSelectionDialog(Display.getCurrent().getActiveShell(), 8, InstanceSpecificationLinkUtils.getModelAssociations(source, target), registry);
            dialog.open();
            Association selectedAssociation = dialog.getSelectedAssociation();
            if (selectedAssociation != null && !dialog.isCanceled()) {
                instanceSpecification = UMLFactory.eINSTANCE.createInstanceSpecification();
                Set<Classifier> sourceSpecificationClassifiersSet = InstanceSpecificationLinkUtils.getSpecificationClassifier(source);
                Set<Classifier> targetSpecificationClassifiersSet = InstanceSpecificationLinkUtils.getSpecificationClassifier(target);
                boolean revertEnds = false;
                if (selectedAssociation != null) {
                    instanceSpecification.getClassifiers().add((Object)selectedAssociation);
                    Type sourceType = ((Property)selectedAssociation.getMemberEnds().get(0)).getType();
                    boolean bl = revertEnds = !sourceSpecificationClassifiersSet.contains(sourceType);
                }
                if (revertEnds) {
                    InstanceSpecificationLinkUtils.addEnd(instanceSpecification, target);
                    InstanceSpecificationLinkUtils.addEnd(instanceSpecification, source);
                } else {
                    InstanceSpecificationLinkUtils.addEnd(instanceSpecification, source);
                    InstanceSpecificationLinkUtils.addEnd(instanceSpecification, target);
                }
                InstanceSpecificationLinkUtils.setupSlots(selectedAssociation, instanceSpecification, source, target, sourceSpecificationClassifiersSet, targetSpecificationClassifiersSet);
            }
        }
        source.getNearestPackage().getPackagedElements().add(instanceSpecification);
        return instanceSpecification;
    }

    public boolean instanceSpecificationLink_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof InstanceSpecification;
    }

    public boolean instanceSpecificationlink_canReconnectSource(Element context, Element newTarget) {
        return newTarget instanceof InstanceSpecification;
    }

    public void instanceSpecificationLink_reconnectSource(InstanceSpecification context, Element oldSource, Element newSource) {
        EAnnotation eAnnotation = context.getEAnnotation(ANNOTATION_INSTANCE_END_SOURCE);
        eAnnotation.getReferences().remove((Object)oldSource);
        eAnnotation.getReferences().add(0, (Object)((InstanceSpecification)newSource));
        Package newOwner = newSource.getNearestPackage();
        newOwner.getPackagedElements().add((Object)context);
    }

    public void instanceSpecificationLink_reconnectTarget(InstanceSpecification context, Element oldTarget, Element newTarget) {
        EAnnotation eAnnotation = context.getEAnnotation(ANNOTATION_INSTANCE_END_SOURCE);
        eAnnotation.getReferences().remove((Object)oldTarget);
        eAnnotation.getReferences().add(1, (Object)((InstanceSpecification)newTarget));
    }

    public Collection<InterfaceRealization> interfaceRealization_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllInterfaceRealizations(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<InterfaceRealization> getAllInterfaceRealizations(Package pack) {
        HashSet<InterfaceRealization> interfaceRealizations = new HashSet<InterfaceRealization>();
        for (NamedElement current : pack.getPackagedElements()) {
            if (current instanceof Package) {
                interfaceRealizations.addAll(this.getAllInterfaceRealizations((Package)current));
            }
            if (!(current instanceof BehavioredClassifier)) continue;
            interfaceRealizations.addAll((Collection<InterfaceRealization>)((BehavioredClassifier)current).getInterfaceRealizations());
        }
        return interfaceRealizations;
    }

    @Deprecated
    public InterfaceRealization interfaceRealization_createInterfaceRealization(EObject context, EObject sourceView, Element source, Element target) {
        InterfaceRealization interfaceRealization = null;
        if (sourceView instanceof DDiagramElement && source instanceof BehavioredClassifier && target instanceof Interface) {
            BehavioredClassifier sourceElement = (BehavioredClassifier)source;
            Interface targetElement = (Interface)target;
            interfaceRealization = UMLFactory.eINSTANCE.createInterfaceRealization();
            interfaceRealization.getClients().add((Object)sourceElement);
            interfaceRealization.getSuppliers().add((Object)targetElement);
            interfaceRealization.setContract(targetElement);
            sourceElement.getInterfaceRealizations().add((Object)interfaceRealization);
        }
        return interfaceRealization;
    }

    public boolean interfaceRealization_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof BehavioredClassifier;
    }

    public boolean interfaceRealization_canReconnectTarget(Element context, Element newTarget) {
        return newTarget instanceof Interface;
    }

    public void interfaceRealization_reconnectSource(InterfaceRealization interfaceRealization, BehavioredClassifier oldSource, BehavioredClassifier newSource) {
        interfaceRealization.getClients().remove((Object)oldSource);
        interfaceRealization.getClients().add((Object)newSource);
        oldSource.getInterfaceRealizations().remove((Object)interfaceRealization);
        newSource.getInterfaceRealizations().add((Object)interfaceRealization);
    }

    public void interfaceRealization_reconnectTarget(InterfaceRealization interfaceRealization, Interface oldTarget, Interface newTarget) {
        interfaceRealization.getSuppliers().remove((Object)oldTarget);
        interfaceRealization.getSuppliers().add((Object)newTarget);
        interfaceRealization.setContract(newTarget);
    }

    @Deprecated
    public void link_creation(EObject context, EObject sourceView, Element source, Element target) {
        if (source instanceof Comment) {
            ((Comment)source).getAnnotatedElements().add((Object)target);
        } else if (source instanceof Constraint) {
            ((Constraint)source).getConstrainedElements().add((Object)target);
        }
    }

    public static Collection<Element> link_getTarget(Element source) {
        if (source instanceof Constraint) {
            Constraint sourceElement = (Constraint)source;
            return sourceElement.getConstrainedElements();
        }
        if (source instanceof Comment) {
            Comment sourceElement = (Comment)source;
            return sourceElement.getAnnotatedElements();
        }
        return null;
    }

    public boolean link_canReconnectSource(Element context, Element newSource) {
        if (context instanceof Constraint && newSource instanceof Constraint) {
            return true;
        }
        return context instanceof Comment && newSource instanceof Comment;
    }

    public boolean link_canReconnectTarget(Element context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Comment || newSource instanceof Constraint || newSource instanceof Enumeration || newSource instanceof Interface || newSource instanceof Package || newSource instanceof PrimitiveType;
    }

    public void link_reconnectSource(Element context, Element oldSource, Element newSource, EObject otherEnd) {
        Element target = null;
        if (otherEnd instanceof DSemanticDecorator) {
            target = (Element)((DSemanticDecorator)otherEnd).getTarget();
        }
        if (oldSource instanceof Comment) {
            ((Comment)oldSource).getAnnotatedElements().remove((Object)target);
        } else if (oldSource instanceof Constraint) {
            ((Constraint)oldSource).getConstrainedElements().remove((Object)target);
        }
        if (newSource instanceof Comment) {
            ((Comment)newSource).getAnnotatedElements().add((Object)target);
        } else if (newSource instanceof Constraint) {
            ((Constraint)newSource).getConstrainedElements().add((Object)target);
        }
    }

    public void link_reconnectTarget(Element context, Element oldTarget, Element newTarget, EObject otherEnd) {
        Element source = null;
        if (otherEnd instanceof DSemanticDecorator) {
            source = (Element)((DSemanticDecorator)otherEnd).getTarget();
        }
        if (source instanceof Comment) {
            ((Comment)source).getAnnotatedElements().remove((Object)oldTarget);
            ((Comment)source).getAnnotatedElements().add((Object)newTarget);
        } else if (source instanceof Constraint) {
            ((Constraint)source).getConstrainedElements().remove((Object)oldTarget);
            ((Constraint)source).getConstrainedElements().add((Object)newTarget);
        }
    }

    public Collection<PackageImport> packageImport_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllPackageImports(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<PackageImport> getAllPackageImports(Package pack) {
        HashSet<PackageImport> packageImports = new HashSet<PackageImport>();
        packageImports.addAll((Collection<PackageImport>)pack.getPackageImports());
        for (NamedElement current : pack.getPackagedElements()) {
            if (!(current instanceof Package)) continue;
            packageImports.addAll(this.getAllPackageImports((Package)current));
        }
        return packageImports;
    }

    public boolean packageImport_canReconnectSource(Element context, Element newSource) {
        if (context instanceof PackageImport && newSource instanceof Package) {
            PackageImport pImport = (PackageImport)context;
            Package newOwner = (Package)newSource;
            Package importedPackage = pImport.getImportedPackage();
            return newOwner != null && newOwner != importedPackage;
        }
        return false;
    }

    public boolean packageImport_canReconnectTarget(Element context, Element newTarget) {
        if (context instanceof PackageImport && newTarget instanceof Package) {
            PackageImport pImport = (PackageImport)context;
            Package owner = (Package)pImport.getOwner();
            return newTarget != null && newTarget != owner;
        }
        return false;
    }

    public void packageImport_reconnectSource(PackageImport packageImport, Package oldSource, Package newSource) {
        oldSource.getPackageImports().remove((Object)packageImport);
        newSource.getPackageImports().add((Object)packageImport);
    }

    public void packageImport_reconnectTarget(PackageImport packageImport, Package oldTarget, Package newTarget) {
        packageImport.setImportedPackage(newTarget);
    }

    public Collection<PackageMerge> packageMerge_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllPackageMerges(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<PackageMerge> getAllPackageMerges(Package pack) {
        HashSet<PackageMerge> packageImports = new HashSet<PackageMerge>();
        packageImports.addAll((Collection<PackageMerge>)pack.getPackageMerges());
        for (NamedElement current : pack.getPackagedElements()) {
            if (!(current instanceof Package)) continue;
            packageImports.addAll(this.getAllPackageMerges((Package)current));
        }
        return packageImports;
    }

    public boolean packageMerge_canReconnectSource(Element context, Element newSource) {
        if (context instanceof PackageMerge && newSource instanceof Package) {
            PackageMerge pMerge = (PackageMerge)context;
            Package newOwner = (Package)newSource;
            Package mergedPackage = pMerge.getMergedPackage();
            return newOwner != null && newOwner != mergedPackage;
        }
        return false;
    }

    public boolean packageMerge_canReconnectTarget(Element context, Element newTarget) {
        if (context instanceof PackageMerge && newTarget instanceof Package) {
            PackageMerge pImport = (PackageMerge)context;
            Package owner = (Package)pImport.getOwner();
            return newTarget != null && newTarget != owner;
        }
        return false;
    }

    public void packageMerge_reconnectSource(PackageMerge packageMerge, Package oldSource, Package newSource) {
        oldSource.getPackageMerges().remove((Object)packageMerge);
        newSource.getPackageMerges().add((Object)packageMerge);
    }

    public void packageMerge_reconnectTarget(PackageMerge packageMerge, Package oldTarget, Package newTarget) {
        packageMerge.setMergedPackage(newTarget);
    }

    public Collection<Realization> realization_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllRealizations(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<Realization> getAllRealizations(Package pack) {
        HashSet<Realization> realizations = new HashSet<Realization>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                realizations.addAll(this.getAllRealizations((Package)current));
            }
            if (!(current instanceof Realization)) continue;
            realizations.add((Realization)current);
        }
        return realizations;
    }

    public boolean realization_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Enumeration || newSource instanceof Interface || newSource instanceof Package || newSource instanceof PrimitiveType || newSource instanceof InstanceSpecification;
    }

    public boolean realization_canReconnectTarget(Element context, Element newTarget) {
        return this.realization_canReconnectSource(context, newTarget);
    }

    public void realization_reconnectSource(Realization realization, NamedElement oldSource, NamedElement newSource) {
        realization.getClients().remove((Object)oldSource);
        realization.getClients().add((Object)newSource);
        Package newOwner = newSource.getNearestPackage();
        if (realization.getOwner() != newOwner) {
            newOwner.getPackagedElements().add((Object)realization);
        }
    }

    public void realization_reconnectTarget(Realization realization, NamedElement oldTarget, NamedElement newtarget) {
        realization.getSuppliers().remove((Object)oldTarget);
        realization.getSuppliers().add((Object)newtarget);
    }

    public Collection<Substitution> substitution_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllSubstitutions(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<Substitution> getAllSubstitutions(Package pack) {
        HashSet<Substitution> substitutions = new HashSet<Substitution>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                substitutions.addAll(this.getAllSubstitutions((Package)current));
            }
            if (!(current instanceof Class)) continue;
            substitutions.addAll((Collection<Substitution>)((Class)current).getSubstitutions());
        }
        return substitutions;
    }

    public boolean substitution_canReconnectSource(Substitution substitution, Element newSource) {
        if (newSource == substitution.getContract()) {
            return false;
        }
        return newSource instanceof Class || newSource instanceof Interface || newSource instanceof Enumeration || newSource instanceof PrimitiveType;
    }

    public boolean substitution_canReconnectTarget(Substitution substitution, Element newTarget) {
        if (newTarget == substitution.getOwner()) {
            return false;
        }
        return newTarget instanceof Class || newTarget instanceof Interface || newTarget instanceof Enumeration || newTarget instanceof PrimitiveType;
    }

    public void substitution_reconnectSource(Substitution substitution, Classifier oldSource, Classifier newSource) {
        substitution.getClients().remove((Object)oldSource);
        substitution.getClients().add((Object)newSource);
        oldSource.getSubstitutions().remove((Object)substitution);
        newSource.getSubstitutions().add((Object)substitution);
    }

    public void substitution_reconnectTarget(Substitution substitution, Classifier oldTarget, Classifier newTarget) {
        substitution.getSuppliers().remove((Object)oldTarget);
        substitution.getSuppliers().add((Object)newTarget);
        substitution.setContract(newTarget);
    }

    public Collection<TemplateBinding> templateBindings_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllTemplateBindings(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<TemplateBinding> getAllTemplateBindings(Package pack) {
        HashSet<TemplateBinding> templateBindings = new HashSet<TemplateBinding>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                templateBindings.addAll(this.getAllTemplateBindings((Package)current));
            }
            if (!(current instanceof TemplateableElement)) continue;
            templateBindings.addAll((Collection<TemplateBinding>)((TemplateableElement)current).getTemplateBindings());
        }
        return templateBindings;
    }

    public Collection<Usage> usage_getSemanticCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllUsages(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<Usage> getAllUsages(Package pack) {
        HashSet<Usage> usages = new HashSet<Usage>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                usages.addAll(this.getAllUsages((Package)current));
            }
            if (!(current instanceof Usage)) continue;
            usages.add((Usage)current);
        }
        return usages;
    }

    public boolean usage_canReconnectSource(Element context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Enumeration || newSource instanceof Interface || newSource instanceof Package || newSource instanceof PrimitiveType;
    }

    public boolean usage_canReconnectTarget(Element context, Element newTarget) {
        return this.usage_canReconnectSource(context, newTarget);
    }

    public void usage_reconnectSource(Usage usage, Element oldSource, Element newSource) {
        usage.getClients().remove((Object)oldSource);
        usage.getClients().add((Object)((NamedElement)newSource));
        Package oldOwner = oldSource.getNearestPackage();
        Package newOwner = newSource.getNearestPackage();
        if (oldOwner != newOwner) {
            oldOwner.getPackagedElements().remove((Object)usage);
            newOwner.getPackagedElements().add((Object)usage);
        }
    }

    public void usage_reconnectTarget(Usage usage, Element source, Element target) {
        usage.getSuppliers().remove((Object)source);
        usage.getSuppliers().add((Object)((NamedElement)target));
    }

    public boolean isDDiagram(EObject self) {
        return self instanceof DDiagram;
    }

    public boolean isDataType(EObject context) {
        return !(context instanceof Enumeration) && !(context instanceof PrimitiveType);
    }

    public String getTypeTarget(EObject context) {
        if (context instanceof Class || context instanceof Interface) {
            return NESTED_CLASSIFIER;
        }
        return PACKAGED_ELEMENT;
    }

    public String getTypeTarget(EObject context, EObject newContainerView) {
        if (newContainerView instanceof Class || newContainerView instanceof Interface) {
            return NESTED_CLASSIFIER;
        }
        return PACKAGED_ELEMENT;
    }

    public boolean isCurrentLinkType(EObject elem, String linkTypeName) {
        return elem.getClass().getSimpleName().equalsIgnoreCase(linkTypeName);
    }

    public String getConstraintLabel(Element elem) {
        Constraint constraint;
        ValueSpecification valueSpec;
        StringBuilder constLabel = new StringBuilder();
        String body = "";
        String lang = "";
        if (elem instanceof Constraint && (valueSpec = (constraint = (Constraint)elem).getSpecification()) instanceof OpaqueExpression) {
            EList appliedStereoTypes;
            OpaqueExpression opaqueEsp = (OpaqueExpression)valueSpec;
            if (!opaqueEsp.getBodies().isEmpty()) {
                body = (String)opaqueEsp.getBodies().get(0);
            }
            if (!opaqueEsp.getLanguages().isEmpty()) {
                lang = (String)opaqueEsp.getLanguages().get(0);
            }
            if (!(appliedStereoTypes = constraint.getAppliedStereotypes()).isEmpty()) {
                constLabel.append("\u00ab");
            }
            int i = 0;
            while (i < constraint.getAppliedStereotypes().size()) {
                Stereotype stereoType = (Stereotype)appliedStereoTypes.get(i);
                constLabel.append(stereoType.getName());
                if (i + 1 == appliedStereoTypes.size()) {
                    constLabel.append("\u00bb");
                } else {
                    constLabel.append(",");
                }
                ++i;
            }
            constLabel.append(constraint.getName());
            constLabel.append(ILabelConstants.NL);
            constLabel.append("{{" + lang + "} " + body + "}");
        }
        return constLabel.toString();
    }

    public String buildLabel(Element element) {
        StringBuilder labelBuilder = new StringBuilder();
        String name = LabelServices.INSTANCE.computeUmlLabel(element);
        Object prefix = element instanceof InformationItem ? "Information" : (element instanceof PrimitiveType ? "Primitive" : element.eClass().getName());
        if (!name.startsWith((String)(prefix = "\u00ab" + (String)prefix + "\u00bb"))) {
            labelBuilder.append((String)prefix);
            labelBuilder.append(ILabelConstants.NL);
            labelBuilder.append(name);
            return labelBuilder.toString();
        }
        return name;
    }

    private final ServicesRegistry getServiceRegistry(EObject eobject) {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(eobject);
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
        return registry;
    }

    private Model getRootModel(Element element) {
        Model currentModel = element.getModel();
        if (!element.equals(currentModel)) {
            currentModel = this.getRootModel((Element)currentModel);
        }
        return currentModel;
    }

    public EObject instanceSpecificationLink_getTarget(EObject elem) {
        EAnnotation eAnnotation;
        InstanceSpecification instanceSpecification;
        if (elem instanceof InstanceSpecification && !(instanceSpecification = (InstanceSpecification)elem).getEAnnotations().isEmpty() && !(eAnnotation = (EAnnotation)instanceSpecification.getEAnnotations().get(0)).getReferences().isEmpty()) {
            return (EObject)eAnnotation.getReferences().get(1);
        }
        return null;
    }

    public EObject instanceSpecificationLink_getSource(EObject elem) {
        EAnnotation eAnnotation;
        InstanceSpecification instanceSpecification;
        if (elem instanceof InstanceSpecification && !(instanceSpecification = (InstanceSpecification)elem).getEAnnotations().isEmpty() && !(eAnnotation = (EAnnotation)instanceSpecification.getEAnnotations().get(0)).getReferences().isEmpty()) {
            return (EObject)eAnnotation.getReferences().get(0);
        }
        return null;
    }

    public String computeInstanceSpecBeginLabel(EObject context) {
        InstanceSpecification instanceSpec = (InstanceSpecification)context;
        InstanceSpecification source = (InstanceSpecification)((EAnnotation)instanceSpec.getEAnnotations().get(0)).getReferences().get(0);
        return source.getName();
    }

    public String computeInstanceSpecEndLabel(EObject context) {
        InstanceSpecification instanceSpec = (InstanceSpecification)context;
        InstanceSpecification target = (InstanceSpecification)((EAnnotation)instanceSpec.getEAnnotations().get(0)).getReferences().get(1);
        return target.getName();
    }

    @Deprecated
    public boolean isNotAssociation(EObject elem) {
        return ((Property)elem).getAssociation() == null;
    }

    public Operation createOperation(Type type) {
        return OperationServices.INSTANCE.createOperation(type);
    }

    public Type findTypeByName(Collection<EObject> roots, String typeName) {
        return ElementServices.INSTANCE.findTypeByName(roots, typeName);
    }

    public Type findTypeByName(EObject object, String typeName) {
        return ElementServices.INSTANCE.findTypeByName(object, typeName);
    }

    public Collection<Object> getAllStereotypeApplications(DDiagram diagram) {
        return StereotypeServices.INSTANCE.getAllStereotypeApplications(diagram);
    }

    public Collection<EObject> getAssociationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getAssociationInverseRefs(diagram);
    }

    public Element getBaseClass(EObject stereotypeApplication) {
        return StereotypeServices.INSTANCE.getBaseClass(stereotypeApplication);
    }

    public boolean isNotTypeOfClass(EObject element) {
        return !this.isTypeOfClass(element);
    }

    public boolean isStatic(Feature feature) {
        return feature != null && feature.isStatic();
    }

    public boolean isTypeOfClass(EObject element) {
        return "Class".equals(element.eClass().getName());
    }
}

