/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy.IMultiPageEditorSite;
import org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy.MultiPageSelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.contexts.NestableContextService;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public class MultiPageEditorSite
implements IMultiPageEditorSite,
INestable {
    org.eclipse.ui.part.MultiPageEditorSite e;
    protected EditorActionBarContributor actionBarContributor;
    private IEditorPart editor;
    private List<PopupMenuExtender> menuExtenders;
    private final IEditorSite mainEditorSite;
    private ISelectionChangedListener postSelectionChangedListener = null;
    private ISelectionChangedListener selectionChangedListener = null;
    private ISelectionProvider selectionProvider = null;
    private IKeyBindingService service = null;
    private final ServiceLocator serviceLocator;
    private NestableContextService contextService;
    private IEclipseContext context;
    private boolean active = false;
    private PapyrusContextFunction contextFunction;

    public MultiPageEditorSite(IEditorSite mainEditorSite, IEditorPart editor, EditorActionBarContributor actionBarContributor) {
        Assert.isNotNull((Object)mainEditorSite);
        Assert.isNotNull((Object)editor);
        Assert.isLegal((boolean)(mainEditorSite instanceof PartSite));
        this.mainEditorSite = mainEditorSite;
        this.editor = editor;
        this.actionBarContributor = actionBarContributor;
        PartSite site = (PartSite)mainEditorSite;
        IServiceLocatorCreator slc = (IServiceLocatorCreator)mainEditorSite.getService(IServiceLocatorCreator.class);
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator((IServiceLocator)this.getMainEditorSite(), null, new IDisposable(){

            public void dispose() {
                PartSite partSite = (PartSite)MultiPageEditorSite.this.getMainEditorSite();
                MPart model = partSite.getModel();
                Widget widget = (Widget)model.getWidget();
                if (widget != null && !widget.isDisposed()) {
                    MultiPageEditorSite.this.getMainEditorSite().getPage().closeEditor(MultiPageEditorSite.this.getMultiPageEditorPart(), true);
                }
            }
        });
        this.context = site.getModel().getContext().createChild("MultiPageEditorSite");
        this.serviceLocator.setContext(this.context);
        this.initializeDefaultServices();
    }

    public IEditorPart getMultiPageEditorPart() {
        return (IEditorPart)this.mainEditorSite.getPart();
    }

    private IEditorSite getMainEditorSite() {
        return this.mainEditorSite;
    }

    private void initializeDefaultServices() {
        this.serviceLocator.registerService(IWorkbenchLocationService.class, (Object)new WorkbenchLocationService("org.eclipse.ui.part.MultiPageEditorSite", this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), (IWorkbenchPartSite)this.getMainEditorSite(), (IEditorSite)this, null, 3));
        this.contextFunction = new PapyrusContextFunction(this);
        this.context.set(IContextService.class.getName(), (Object)this.contextFunction);
        LegacyHandlerService handlerService = new LegacyHandlerService(this.context);
        this.context.set(IHandlerService.class, (Object)handlerService);
    }

    public final void activate() {
        this.active = true;
        this.context.activate();
        this.serviceLocator.activate();
        if (this.contextService != null) {
            this.contextService.activate();
        }
    }

    public final void deactivate() {
        this.active = false;
        if (this.contextService != null) {
            this.contextService.deactivate();
        }
        this.serviceLocator.deactivate();
        this.context.deactivate();
    }

    @Override
    public void dispose() {
        if (this.menuExtenders != null) {
            int i = 0;
            while (i < this.menuExtenders.size()) {
                this.menuExtenders.get(i).dispose();
                ++i;
            }
            this.menuExtenders = null;
        }
        if (this.service != null) {
            IKeyBindingService parentService = this.getMainEditorSite().getKeyBindingService();
            if (parentService instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableParent = (INestableKeyBindingService)parentService;
                nestableParent.removeKeyBindingService((IWorkbenchSite)this);
            }
            if (this.service instanceof KeyBindingService) {
                ((KeyBindingService)this.service).dispose();
            }
            this.service = null;
        }
        if (this.contextService != null) {
            this.contextService.dispose();
            this.contextService = null;
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.dispose();
        }
        this.context.remove(IContextService.class.getName());
        this.context.dispose();
        this.contextFunction.dispose();
        this.contextFunction = null;
        this.selectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
        if (this.selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.selectionProvider).removePostSelectionChangedListener(this.getPostSelectionChangedListener());
        } else {
            this.selectionProvider.removeSelectionChangedListener(this.getPostSelectionChangedListener());
        }
        this.postSelectionChangedListener = null;
        this.selectionChangedListener = null;
        this.editor = null;
        this.actionBarContributor = null;
    }

    public IEditorActionBarContributor getActionBarContributor() {
        if (this.actionBarContributor != null) {
            return this.actionBarContributor;
        }
        return this.getMainEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getMainEditorSite().getActionBars();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Deprecated
    public ILabelDecorator getDecoratorManager() {
        return this.getWorkbenchWindow().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public String getId() {
        return "";
    }

    public IKeyBindingService getKeyBindingService() {
        if (this.service == null) {
            this.service = this.getMainEditorSite().getKeyBindingService();
            if (this.service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)this.service;
                this.service = nestableService.getKeyBindingService((IWorkbenchSite)this);
            } else {
                WorkbenchPlugin.log((String)("MultiPageEditorSite.getKeyBindingService()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + this.service.getClass().getName() + " instead."));
            }
        }
        return this.service;
    }

    public IWorkbenchPage getPage() {
        return this.getMainEditorSite().getPage();
    }

    public IWorkbenchPart getPart() {
        return this.editor;
    }

    public String getPluginId() {
        return "";
    }

    private ISelectionChangedListener getPostSelectionChangedListener() {
        if (this.postSelectionChangedListener == null) {
            this.postSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MultiPageEditorSite.this.handlePostSelectionChanged(event);
                }
            };
        }
        return this.postSelectionChangedListener;
    }

    public String getRegisteredName() {
        return "";
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MultiPageEditorSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this.selectionChangedListener;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public final Object getService(Class key) {
        Object service = this.serviceLocator.getService(key);
        if (this.active && service instanceof INestable) {
            ((INestable)service).activate();
        }
        return service;
    }

    public Shell getShell() {
        return this.getMainEditorSite().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.getMainEditorSite().getWorkbenchWindow();
    }

    protected void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMainEditorSite().getSelectionProvider();
        if (parentProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            MultiPageSelectionProvider prov = (MultiPageSelectionProvider)parentProvider;
            prov.firePostSelectionChanged(newEvent);
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMainEditorSite().getSelectionProvider();
        if (parentProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            MultiPageSelectionProvider prov = (MultiPageSelectionProvider)parentProvider;
            prov.fireSelectionChanged(newEvent);
        }
    }

    public final boolean hasService(Class key) {
        return this.serviceLocator.hasService(key);
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selProvider) {
        this.getMainEditorSite().registerContextMenu(menuManager, selProvider);
    }

    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        this.registerContextMenu(this.getId(), menuManager, selectionProvider, includeEditorInput);
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList<PopupMenuExtender>(1);
        }
        PartSite.registerContextMenu((String)menuID, (MenuManager)menuMgr, (ISelectionProvider)selProvider, (boolean)true, (IWorkbenchPart)this.editor, (IEclipseContext)this.context, this.menuExtenders);
    }

    public final void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList<PopupMenuExtender>(1);
        }
        PartSite.registerContextMenu((String)menuId, (MenuManager)menuManager, (ISelectionProvider)selectionProvider, (boolean)includeEditorInput, (IWorkbenchPart)this.editor, (IEclipseContext)this.context, this.menuExtenders);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        this.selectionProvider = provider;
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
            if (oldSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)oldSelectionProvider).removePostSelectionChangedListener(this.getPostSelectionChangedListener());
            } else {
                oldSelectionProvider.removeSelectionChangedListener(this.getPostSelectionChangedListener());
            }
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
            if (this.selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.selectionProvider).addPostSelectionChangedListener(this.getPostSelectionChangedListener());
            } else {
                this.selectionProvider.addSelectionChangedListener(this.getPostSelectionChangedListener());
            }
        }
    }

    private static class PapyrusContextFunction
    extends ContextFunction {
        private MultiPageEditorSite editorSite;

        public PapyrusContextFunction(MultiPageEditorSite multiPageEditorSite4x) {
            this.editorSite = multiPageEditorSite4x;
        }

        public Object compute(IEclipseContext ctxt) {
            if (this.editorSite.contextService == null) {
                this.editorSite.contextService = new NestableContextService((IContextService)ctxt.getParent().get(IContextService.class), (Expression)new ActivePartExpression(this.editorSite.mainEditorSite.getPart()));
            }
            return this.editorSite.contextService;
        }

        public void dispose() {
            this.editorSite = null;
        }
    }
}

