/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.uml.types.core.commands.StereotypePropertyReferenceEdgeUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class StereotypePropertyReferenceReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;
    private final View view;
    private String sourceStereotypeQualifiedName;
    private String featureToSet;

    public StereotypePropertyReferenceReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        EAnnotation eAnnotation;
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
        Object value = request.getParameters().get("graphical_edge");
        View view = this.view = value instanceof View ? (View)value : null;
        if (this.view != null && (eAnnotation = this.view.getEAnnotation("StereotypePropertyReferenceEdge")) != null) {
            this.featureToSet = (String)eAnnotation.getDetails().get((Object)"featureToSet");
            this.sourceStereotypeQualifiedName = (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
        }
    }

    public boolean canExecute() {
        boolean canExecute = false;
        if (this.view != null && this.featureToSet != null && this.sourceStereotypeQualifiedName != null && this.referenceOwner instanceof Element) {
            if (this.reorientDirection == 1) {
                canExecute = this.canReorientSource();
            } else if (this.reorientDirection == 2) {
                canExecute = this.canReorientTarget();
            }
        }
        return canExecute;
    }

    protected boolean canReorientSource() {
        boolean canReorentSource = false;
        if (this.oldEnd instanceof Element && this.newEnd instanceof Element) {
            canReorentSource = ElementUtil.hasStereotypeApplied((Element)this.newEnd, this.sourceStereotypeQualifiedName);
        }
        return canReorentSource;
    }

    protected boolean canReorientTarget() {
        boolean canReorientTarget = false;
        if (this.newEnd instanceof Element) {
            Stereotype sourceStereotype = ((Element)this.referenceOwner).getApplicableStereotype(this.sourceStereotypeQualifiedName);
            Type type = sourceStereotype.getAttribute(this.featureToSet, null).getType();
            if (type instanceof Stereotype) {
                canReorientTarget = ElementUtil.hasStereotypeApplied((Element)this.newEnd, type.getQualifiedName());
            } else {
                EClassifier metaclass;
                EStructuralFeature eStructuralFeature;
                EObject stereotypeApplication;
                Stereotype appliedSubstereotype = UMLUtil.getAppliedSubstereotype((Element)((Element)this.referenceOwner), (Stereotype)sourceStereotype);
                if (appliedSubstereotype != null && (stereotypeApplication = ((Element)this.referenceOwner).getStereotypeApplication(appliedSubstereotype)) != null && (eStructuralFeature = stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)this.featureToSet))) != null && (metaclass = eStructuralFeature.getEType()) instanceof EClassifier) {
                    canReorientTarget = metaclass.isInstance((Object)this.newEnd);
                }
            }
        }
        return canReorientTarget;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        try {
            Stereotype stereotype = this.getOldSource().getApplicableStereotype(this.sourceStereotypeQualifiedName);
            Property attribute = stereotype.getAttribute(this.featureToSet, null);
            if (1 == attribute.getUpper()) {
                Object value = this.getOldSource().getValue(UMLUtil.getAppliedSubstereotype((Element)this.getOldSource(), (Stereotype)stereotype), this.featureToSet);
                if (this.noSimilarReferenceEdge()) {
                    this.getOldSource().setValue(UMLUtil.getAppliedSubstereotype((Element)this.getOldSource(), (Stereotype)stereotype), this.featureToSet, null);
                }
                this.getNewSource().setValue(UMLUtil.getAppliedSubstereotype((Element)this.getNewSource(), (Stereotype)stereotype), this.featureToSet, value);
                this.cleanOtherEdge(this.getNewSource(), value);
            } else {
                Object newlist;
                Object oldlist;
                Type targetType = attribute.getType();
                EObject oldValue = targetType instanceof Stereotype ? ElementUtil.getStereotypeApplication((Element)this.oldEnd, (Stereotype)targetType) : this.oldEnd;
                if (this.noSimilarReferenceEdge() && (oldlist = this.getOldSource().getValue(UMLUtil.getAppliedSubstereotype((Element)this.getOldSource(), (Stereotype)stereotype), this.featureToSet)) instanceof List) {
                    ((List)oldlist).remove(oldValue);
                }
                if ((newlist = this.getNewSource().getValue(UMLUtil.getAppliedSubstereotype((Element)this.getNewSource(), (Stereotype)stereotype), this.featureToSet)) instanceof List) {
                    ((List)newlist).add(oldValue);
                }
            }
        }
        catch (IllegalArgumentException e) {
            return CommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected boolean noSimilarReferenceEdge() {
        boolean noSimilar = true;
        if (this.view instanceof Edge) {
            for (Object edge : ViewUtil.getSourceConnections((View)((Edge)this.view).getSource())) {
                if (!(edge instanceof Edge) || !"StereotypePropertyReferenceEdge".equals(((View)edge).getType()) || edge.equals(this.view)) continue;
                EAnnotation eAnnotation = ((EModelElement)edge).getEAnnotation("StereotypePropertyReferenceEdge");
                String edgeFeatureToSet = (String)eAnnotation.getDetails().get((Object)"featureToSet");
                String edgeStereotypeToSet = (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
                if (!this.featureToSet.equals(edgeFeatureToSet) || !this.sourceStereotypeQualifiedName.equals(edgeStereotypeToSet)) continue;
                EObject sourceElement = ((Edge)edge).getSource().getElement();
                EObject targetElement = ((Edge)edge).getTarget().getElement();
                boolean bl = noSimilar = !((Edge)this.view).getSource().getElement().equals(sourceElement) || !((Edge)this.view).getTarget().getElement().equals(targetElement);
            }
        }
        return noSimilar;
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        try {
            Stereotype stereotype = this.getOldSource().getApplicableStereotype(this.sourceStereotypeQualifiedName);
            Property attribute = stereotype.getAttribute(this.featureToSet, null);
            Type targetType = attribute.getType();
            Object value = targetType instanceof Stereotype ? ElementUtil.getStereotypeApplication(this.getNewTarget(), (Stereotype)targetType) : this.getNewTarget();
            if (1 == attribute.getUpper()) {
                this.getOldSource().setValue(UMLUtil.getAppliedSubstereotype((Element)this.getOldSource(), (Stereotype)stereotype), this.featureToSet, value);
                this.cleanOtherEdge(this.getOldSource(), value);
            } else {
                EObject oldValue = targetType instanceof Stereotype ? ElementUtil.getStereotypeApplication((Element)this.oldEnd, (Stereotype)targetType) : this.oldEnd;
                Object list = this.getOldSource().getValue(UMLUtil.getAppliedSubstereotype((Element)this.getOldSource(), (Stereotype)stereotype), this.featureToSet);
                if (list instanceof List) {
                    ((List)list).add(value);
                    if (this.noSimilarReferenceEdge()) {
                        ((List)list).remove(oldValue);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            return CommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected void cleanOtherEdge(Element source, Object value) throws ExecutionException {
        ICommand cleanStereotypePropertyReferenceCommand = StereotypePropertyReferenceEdgeUtil.getCleanStereotypePropertyReferenceCommand((EObject)source, (Object)value, (String)this.sourceStereotypeQualifiedName, (String)this.featureToSet, (TransactionalEditingDomain)this.getEditingDomain(), (Edge)((Edge)this.view));
        if (cleanStereotypePropertyReferenceCommand != null && cleanStereotypePropertyReferenceCommand.canExecute()) {
            cleanStereotypePropertyReferenceCommand.execute(null, null);
        }
    }

    protected Element getOldSource() {
        return (Element)this.referenceOwner;
    }

    protected Element getNewSource() {
        return (Element)this.newEnd;
    }

    protected Element getOldTarget() {
        return (Element)this.oldEnd;
    }

    protected Element getNewTarget() {
        return (Element)this.newEnd;
    }
}

