/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.query.java.sdk.ui.internal.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.papyrus.emf.facet.query.java.sdk.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.core.internal.JavaUtils;
import org.eclipse.papyrus.emf.facet.util.pde.core.internal.exported.PluginUtils;

public final class JdtUtils {
    private JdtUtils() {
    }

    public static ICompilationUnit createJavaClass(EClassifier returnTypeClass, boolean multiValues, EClassifier scope, IPackageFragment packageFragment, IPackageFragmentRoot root, String typeName, String cuName) throws JavaModelException {
        IPackageFragment packgeFragment2 = packageFragment == null ? root.getPackageFragment("") : packageFragment;
        String packageName = packgeFragment2.getElementName();
        if (!packgeFragment2.exists()) {
            packgeFragment2 = root.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor());
        }
        StringBuilder contents = new StringBuilder();
        JdtUtils.createJavaClassContents(contents, typeName, packageName, returnTypeClass, multiValues, scope);
        return packgeFragment2.createCompilationUnit(cuName, contents.toString(), false, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void createJavaClassContents(StringBuilder contents, String name, String packageName, EClassifier returnTypeClass, boolean multiValues, EClassifier scope) {
        String shortScopeType;
        String scopeType;
        Object shortReturnType;
        String returnType;
        if (packageName.length() > 0) {
            contents.append("package ");
            contents.append(packageName);
            contents.append(";\n\n");
        }
        boolean importCollection = false;
        if (returnTypeClass == null) {
            returnType = "java.lang.Object";
            shortReturnType = "Object";
        } else {
            returnType = returnTypeClass.getInstanceClassName();
            returnType = JavaUtils.objectType((String)returnType);
            int lastDotPos = returnType.lastIndexOf(46);
            if (multiValues) {
                importCollection = true;
                shortReturnType = "Collection<" + returnType.substring(lastDotPos + 1) + ">";
            } else {
                shortReturnType = returnType.substring(lastDotPos + 1);
            }
        }
        if (scope == null) {
            scopeType = "org.eclipse.emf.ecore.EObject";
            shortScopeType = "EObject";
        } else {
            scopeType = scope.getInstanceClassName();
            scopeType = JavaUtils.objectType((String)scopeType);
            shortScopeType = scopeType.substring(scopeType.lastIndexOf(46) + 1);
        }
        if (importCollection) {
            contents.append("import java.util.Collection;\n");
        }
        if (JdtUtils.mustImport(returnType)) {
            contents.append("import " + returnType + ";\n");
        }
        if (!returnType.equals(scopeType) && JdtUtils.mustImport(scopeType)) {
            contents.append("import " + scopeType + ";\n");
        }
        contents.append("import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;\n");
        contents.append("import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;\n");
        contents.append("import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;\n");
        contents.append("import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList2;\n");
        contents.append("\n");
        contents.append("public class " + name + " implements IJavaQuery2<" + shortScopeType + ", " + (String)shortReturnType + "> {\n");
        contents.append("\tpublic " + (String)shortReturnType + " evaluate(final " + shortScopeType + " context, \n");
        contents.append("\t\t\tfinal IParameterValueList2 parameterValues,\n");
        contents.append("\t\t\tfinal IFacetManager facetManager)\n");
        contents.append("\t\t\tthrows DerivedTypedElementException {\n");
        contents.append("\t\t\n");
        contents.append("\t\treturn null;\n");
        contents.append("\t}\n");
        contents.append("}\n");
    }

    private static boolean mustImport(String type) {
        return type.contains(".") && !type.startsWith("java.lang.");
    }

    public static void setupProject(IProject project, EClassifier returnType, EClassifier scope) {
        try {
            String[] requiredBundles = JdtUtils.findRequiredBundles(returnType, scope);
            ArrayList<String> missingBundles = new ArrayList<String>();
            String[] stringArray = requiredBundles;
            int n = requiredBundles.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredBundle = stringArray[n2];
                missingBundles.add(requiredBundle);
                ++n2;
            }
            missingBundles.add("org.eclipse.papyrus.emf.facet.efacet.core");
            missingBundles.add("org.eclipse.papyrus.emf.facet.query.java.core");
            PluginUtils.configureAsPluginProject((IProject)project);
            IFile manifestResource = (IFile)project.findMember((IPath)new Path("/META-INF/MANIFEST.MF"));
            manifestResource.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            InputStream contents = manifestResource.getContents();
            Manifest manifest = new Manifest(contents);
            String requires = manifest.getMainAttributes().getValue("Require-Bundle");
            if (requires != null) {
                ManifestElement[] manifestElements;
                ManifestElement[] manifestElementArray = manifestElements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
                int n3 = manifestElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    ManifestElement manifestElement = manifestElementArray[n4];
                    missingBundles.remove(manifestElement.getValue());
                    ++n4;
                }
            }
            StringBuilder newRequires = new StringBuilder();
            if (requires != null) {
                newRequires.append(requires);
            }
            int i = 0;
            while (i < missingBundles.size()) {
                String missingBundle = (String)missingBundles.get(i);
                if (i != 0 || requires != null) {
                    newRequires.append(",");
                }
                newRequires.append(missingBundle);
                ++i;
            }
            manifest.getMainAttributes().putValue("Require-Bundle", newRequires.toString());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            manifest.write(outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            manifestResource.setContents((InputStream)inputStream, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private static String[] findRequiredBundles(EClassifier returnType, EClassifier scope) {
        HashSet<String> requiredBundles = new HashSet<String>();
        HashSet<EPackage> requiredEPackages = new HashSet<EPackage>();
        if (returnType != null) {
            requiredEPackages.add(returnType.getEPackage());
        }
        if (scope != null) {
            requiredEPackages.add(scope.getEPackage());
        }
        Map genModelLocMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        for (EPackage ePackage : requiredEPackages) {
            try {
                URI genModelURI = (URI)genModelLocMap.get(ePackage.getNsURI());
                if (genModelURI == null) {
                    Logger.logWarning((String)("Couldn't add the metamodel implementation plug-in to the dependencies automatically because the corresponding genmodel couldn't be found: " + ePackage.getNsURI()), (Plugin)Activator.getDefault());
                    continue;
                }
                ResourceSetImpl resourceSet = JdtUtils.createResource();
                Resource resource = resourceSet.createResource(genModelURI);
                resource.load(Collections.emptyMap());
                GenModel genModel = (GenModel)resource.getContents().get(0);
                String modelPluginID = genModel.getModelPluginID();
                if (modelPluginID == null) continue;
                requiredBundles.add(modelPluginID);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return requiredBundles.toArray(new String[requiredBundles.size()]);
    }

    private static ResourceSetImpl createResource() {
        return new ResourceSetImpl();
    }
}

