/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.BasicRelation2Mappings;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.NonTopRelation2Mappings;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Relation2Mappings;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.TopRelation2Mappings;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

public class RelationalTransformation2CoreTransformation
extends QVTcoreHelper {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull TransformationAnalysis transformationAnalysis;
    protected final @NonNull RelationalTransformation2TracePackage relationalTransformation2tracePackage;
    private @Nullable Transformation coreTransformation = null;
    private @NonNull Map<@NonNull RelationAnalysis, @NonNull Relation2Mappings> relationAnalysis2relation2mapping = new HashMap<RelationAnalysis, Relation2Mappings>();

    public RelationalTransformation2CoreTransformation(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull TransformationAnalysis transformationAnalysis) {
        super(qvtr2qvtc.getEnvironmentFactory());
        this.qvtr2qvtc = qvtr2qvtc;
        this.transformationAnalysis = transformationAnalysis;
        this.relationalTransformation2tracePackage = qvtr2qvtc.getRelationalTransformation2TracePackage(transformationAnalysis);
    }

    public void addRelation2Mappings(@NonNull Relation2Mappings relation2mappings) {
        RelationAnalysis relationAnalysis = relation2mappings.getRelationAnalysis();
        this.relationAnalysis2relation2mapping.put(relationAnalysis, relation2mappings);
    }

    private @NonNull TypedModel createTypedModel(@NonNull Transformation coreTransformation, @Nullable String name, @NonNull List<@NonNull Package> usedPackages) {
        TypedModel coreTypedModel = QVTbaseFactory.eINSTANCE.createTypedModel();
        coreTypedModel.setName(name);
        coreTypedModel.getUsedPackage().addAll(usedPackages);
        coreTransformation.getModelParameter().add((Object)coreTypedModel);
        return coreTypedModel;
    }

    public @NonNull Transformation getCoreTransformation() {
        return (Transformation)ClassUtil.nonNullState((Object)this.coreTransformation);
    }

    public @NonNull Relation2Mappings getRelation2Mappings(@NonNull RelationAnalysis relationAnalysis) {
        return (Relation2Mappings)ClassUtil.nonNullState((Object)this.relationAnalysis2relation2mapping.get((Object)relationAnalysis));
    }

    public @NonNull RelationalTransformation2TracePackage getRelationalTransformation2TracePackage() {
        return this.relationalTransformation2tracePackage;
    }

    public @NonNull Transformation transform() {
        TypedModel coreTypedModel;
        Transformation coreTransformation2 = this.coreTransformation;
        assert (coreTransformation2 == null);
        RelationalTransformation relationalTransformation = this.transformationAnalysis.getTransformation();
        QVTr2QVTc qvtr2qvtc = this.transformationAnalysis.getQVTr2QVTc();
        this.coreTransformation = coreTransformation2 = this.createTransformation(QVTrelationUtil.getName((NamedElement)relationalTransformation));
        qvtr2qvtc.putGlobalTrace((Element)coreTransformation2, (Element)relationalTransformation);
        @NonNull Package corePackage = this.relationalTransformation2tracePackage.getTracePackage();
        this.createTypedModel(coreTransformation2, null, Collections.singletonList(corePackage));
        for (TypedModel relationTypedModel : ClassUtil.nullFree((EList)relationalTransformation.getModelParameter())) {
            if (QVTbaseUtil.isTrace((TypedModel)relationTypedModel)) continue;
            coreTypedModel = this.createTypedModel(coreTransformation2, relationTypedModel.getName(), (List<Package>)ClassUtil.nullFree((EList)relationTypedModel.getUsedPackage()));
            qvtr2qvtc.putTypedModel(relationTypedModel, coreTypedModel);
        }
        for (TypedModel relationTypedModel : ClassUtil.nullFree((EList)relationalTransformation.getModelParameter())) {
            if (relationTypedModel.getDependsOn().size() <= 0) continue;
            coreTypedModel = qvtr2qvtc.getCoreTypedModel(relationTypedModel);
            for (TypedModel relationDependsOn : QVTrelationUtil.getDependsOns((TypedModel)relationTypedModel)) {
                coreTypedModel.getDependsOn().add((Object)qvtr2qvtc.getCoreTypedModel(relationDependsOn));
            }
        }
        return coreTransformation2;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void transformContents() throws CompilerChainException {
        RelationalTransformation rTransformation = this.transformationAnalysis.getTransformation();
        Transformation cTransformation = this.getCoreTransformation();
        @NonNull ArrayList rRelations = Lists.newArrayList((Iterable)QVTrelationUtil.getOwnedRelations((RelationalTransformation)rTransformation));
        Collections.sort(rRelations, new QVTr2QVTc.RelationComparator());
        Variable cThis = QVTbaseUtil.getContextVariable((StandardLibrary)this.standardLibrary, (Transformation)cTransformation);
        Variable rThis = QVTbaseUtil.getContextVariable((StandardLibrary)this.standardLibrary, (Transformation)rTransformation);
        this.qvtr2qvtc.addTrace((Element)rThis, (Element)cThis);
        this.transformQueries();
        TransformationAnalysis rTransformationAnalysis = this.qvtr2qvtc.getTransformationAnalysis(rTransformation);
        for (Relation rRelation : rRelations) {
            BasicRelation2Mappings relation2mappings;
            RelationAnalysis relationAnalysis = rTransformationAnalysis.getRelationAnalysis(rRelation);
            if (rRelation.isIsTopLevel()) {
                QVTr2QVTc.SYNTHESIS.println("topLevel " + rRelation);
                relation2mappings = new TopRelation2Mappings(this, relationAnalysis);
            } else {
                relation2mappings = new NonTopRelation2Mappings(this, relationAnalysis);
            }
            relation2mappings.analyze();
            this.relationAnalysis2relation2mapping.put(relationAnalysis, relation2mappings);
        }
        for (Relation2Mappings relation2mapping : this.relationAnalysis2relation2mapping.values()) {
            relation2mapping.synthesize();
        }
        CompilerUtil.normalizeNameables(QVTbaseUtil.Internal.getOwnedOperationsList((Class)cTransformation));
        CompilerUtil.normalizeNameables(QVTbaseUtil.getRule((Transformation)cTransformation));
    }

    protected void transformQueries() {
        RelationalTransformation rTransformation = this.transformationAnalysis.getTransformation();
        ArrayList<@NonNull Operation> cOperations = new ArrayList<Operation>();
        for (Operation rOperation : QVTbaseUtil.getOwnedOperations((Transformation)rTransformation)) {
            Element cOperation = this.qvtr2qvtc.createCopy((Element)rOperation);
            if (!(cOperation instanceof Operation)) continue;
            cOperations.add((Operation)cOperation);
            this.qvtr2qvtc.putGlobalTrace(cOperation, (Element)rOperation);
        }
        Transformation cTransformation = this.getCoreTransformation();
        cTransformation.getOwnedOperations().addAll(cOperations);
        for (Operation cOperation : cOperations) {
            this.qvtr2qvtc.updateCopy((Element)cOperation);
        }
    }
}

