/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.m2m.internal.qvt.oml.QvtEngine;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompiler;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;

public class WorkspaceQvtModule
extends QvtModule {
    private final IFile myTransformationFile;
    private CompiledModule myModule;
    private QvtCompiler myCompiler;

    public WorkspaceQvtModule(IFile transformationFile) {
        this.myTransformationFile = transformationFile;
        this.myModule = null;
        this.myCompiler = null;
    }

    public String toString() {
        return this.myTransformationFile.getFullPath().toString();
    }

    public CompiledModule getModule(boolean isCheckErrors) throws MdaException {
        if (this.myModule == null) {
            QvtEngine engine = QvtEngine.getInstance((IResource)this.myTransformationFile);
            CompiledModule module = engine.compile(this.myTransformationFile, null, this.getQvtCompilerOptions());
            if (isCheckErrors) {
                this.checkModuleErrors(module);
            }
            this.myModule = module;
            this.myCompiler = engine.getCompiler();
        }
        return this.myModule;
    }

    public CompiledModule getModule() throws MdaException {
        return this.getModule(true);
    }

    public QvtCompiler getCompiler() throws MdaException {
        this.getModule();
        return this.myCompiler;
    }

    public IFile getTransformationFile() {
        return this.myTransformationFile;
    }
}

