/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.ui.generator.trace.FileOpener;
import org.eclipse.xtext.ui.generator.trace.FileOpenerSelector;
import org.eclipse.xtext.util.CollectionBasedAcceptor;
import org.eclipse.xtext.util.IAcceptor;

public abstract class OpenOppositeFileHandler
extends AbstractHandler {
    protected abstract void collectOpeners(IEditorPart var1, IAcceptor<FileOpener> var2);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IWorkbenchPage page = editor.getSite().getPage();
        ArrayList destinations = Lists.newArrayList();
        this.collectOpeners(editor, (IAcceptor<FileOpener>)CollectionBasedAcceptor.of((Collection)destinations));
        switch (destinations.size()) {
            case 0: {
                return null;
            }
            case 1: {
                ((FileOpener)destinations.iterator().next()).open(page);
                return null;
            }
        }
        List<FileOpener> selected = this.selectOpeners(page, destinations);
        for (FileOpener sel : selected) {
            sel.open(page);
        }
        return null;
    }

    protected List<FileOpener> selectOpeners(IWorkbenchPage page, Collection<FileOpener> openers) {
        Shell shell = page.getWorkbenchWindow().getShell();
        FileOpenerSelector dialog = new FileOpenerSelector(shell, openers);
        if (dialog.open() == 0) {
            ArrayList result = Lists.newArrayList();
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof FileOpener) {
                    result.add((FileOpener)item);
                }
                ++n2;
            }
            return result;
        }
        return Collections.emptyList();
    }
}

