/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.internal.Nullable;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.LoadingResourceAccess;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorResourceAccess
implements IReferenceFinder.ILocalResourceAccess {
    private static final Logger LOG = Logger.getLogger(EditorResourceAccess.class);
    @Inject(optional=true)
    @Nullable
    private IWorkbench workbench;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private LoadingResourceAccess delegate;

    @Override
    public <R> R readOnly(final URI targetURI, final IUnitOfWork<R, ResourceSet> work) {
        try {
            Object result = new DisplayRunnableWithResult<R>(){

                @Override
                protected R run() throws Exception {
                    IXtextDocument document = EditorResourceAccess.this.getOpenDocument(targetURI.trimFragment());
                    if (document != null) {
                        return document.readOnly(new IUnitOfWork<R, XtextResource>(){

                            public R exec(XtextResource state) throws Exception {
                                ResourceSet localContext = state.getResourceSet();
                                if (localContext != null) {
                                    return work.exec((Object)localContext);
                                }
                                return null;
                            }
                        });
                    }
                    return null;
                }
            }.syncExec();
            if (result != null) {
                return (R)result;
            }
            return this.delegate.readOnly(targetURI, work);
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    protected IXtextDocument getOpenDocument(URI targetURI) throws Exception {
        Iterable<Pair<IStorage, IProject>> storagesToProject;
        Iterable storages;
        IWorkbenchPage activePage;
        if (this.workbench != null && (activePage = this.workbench.getActiveWorkbenchWindow().getActivePage()) != null && !Iterables.isEmpty((Iterable)(storages = Iterables.transform(storagesToProject = this.storage2UriMapper.getStorages(targetURI.trimFragment()), (Function)new Function<Pair<IStorage, IProject>, IStorage>(){

            public IStorage apply(Pair<IStorage, IProject> from) {
                return (IStorage)from.getFirst();
            }
        })))) {
            IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                try {
                    IEditorPart editor;
                    IEditorInput editorInput = editorReference.getEditorInput();
                    if (editorInput instanceof IStorageEditorInput && Iterables.contains((Iterable)storages, (Object)((IStorageEditorInput)editorInput).getStorage()) && (editor = editorReference.getEditor(true)) instanceof XtextEditor) {
                        XtextEditor xtextEditor = (XtextEditor)editor;
                        return xtextEditor.getDocument();
                    }
                }
                catch (PartInitException e) {
                    LOG.error((Object)e);
                }
                ++n2;
            }
        }
        return null;
    }
}

