/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.ui.refactoring.impl.DisplayChangeWrapper;
import org.eclipse.xtext.util.IAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceEditExtractor {
    private static final Logger LOG = Logger.getLogger(ReplaceEditExtractor.class);

    public List<ReplaceEdit> getReplaceEditsForDocument(Change change, IDocument document) {
        final ArrayList replaceEdits = Lists.newArrayList();
        this.addTextEdits(change, document, new IAcceptor<TextEdit>(){

            public void accept(TextEdit edit) {
                if (edit instanceof ReplaceEdit) {
                    replaceEdits.add((ReplaceEdit)edit);
                }
            }
        });
        return replaceEdits;
    }

    protected void addTextEdits(Change change, IDocument document, IAcceptor<TextEdit> textEdits) {
        try {
            if (change instanceof DocumentChange && document.equals(((DocumentChange)change).getCurrentDocument(null))) {
                this.addTextEdits((TextChange)((DocumentChange)change), textEdits);
            } else if (change instanceof CompositeChange) {
                Change[] changeArray = ((CompositeChange)change).getChildren();
                int n = changeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Change child = changeArray[n2];
                    this.addTextEdits(child, document, textEdits);
                    ++n2;
                }
            } else if (change instanceof DisplayChangeWrapper) {
                this.addTextEdits(((DisplayChangeWrapper)change).getDelegate(), document, textEdits);
            }
        }
        catch (CoreException e) {
            LOG.error((Object)"Error document changes", (Throwable)e);
        }
    }

    protected void addTextEdits(TextChange change, IAcceptor<TextEdit> textEdits) {
        TextEdit edit = change.getEdit();
        this.addTextEdits(edit, textEdits);
    }

    protected void addTextEdits(TextEdit edit, IAcceptor<TextEdit> textEdits) {
        if (edit instanceof MultiTextEdit) {
            TextEdit[] textEditArray = edit.getChildren();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit child = textEditArray[n2];
                this.addTextEdits(child, textEdits);
                ++n2;
            }
        }
        textEdits.accept((Object)edit);
    }
}

