/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.internal;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.xbase.XbaseRuntimeModule;
import org.eclipse.xtext.xbase.XtypeRuntimeModule;
import org.eclipse.xtext.xbase.annotations.XbaseWithAnnotationsRuntimeModule;
import org.eclipse.xtext.xbase.annotations.ui.XbaseWithAnnotationsUiModule;
import org.eclipse.xtext.xbase.ui.XbaseUiModule;
import org.eclipse.xtext.xbase.ui.XtypeUiModule;
import org.osgi.framework.BundleContext;

public class XtypeActivator
extends AbstractUIPlugin {
    private Map<String, Injector> injectors = new HashMap<String, Injector>();
    private static XtypeActivator INSTANCE;

    public Injector getInjector(String languageName) {
        return this.injectors.get(languageName);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        try {
            this.registerInjectorFor("org.eclipse.xtext.xbase.Xtype");
            this.registerInjectorFor("org.eclipse.xtext.xbase.Xbase");
            this.registerInjectorFor("org.eclipse.xtext.xbase.annotations.XbaseWithAnnotations");
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected void registerInjectorFor(String language) throws Exception {
        this.injectors.put(language, Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{Modules.override((Module[])new Module[]{this.getRuntimeModule(language)}).with(new Module[]{this.getSharedStateModule()})}).with(new Module[]{this.getUiModule(language)})}));
    }

    public void stop(BundleContext context) throws Exception {
        this.injectors.clear();
        INSTANCE = null;
        super.stop(context);
    }

    public static XtypeActivator getInstance() {
        return INSTANCE;
    }

    protected Module getRuntimeModule(String grammar) {
        if ("org.eclipse.xtext.xbase.Xtype".equals(grammar)) {
            return new XtypeRuntimeModule();
        }
        if ("org.eclipse.xtext.xbase.Xbase".equals(grammar)) {
            return new XbaseRuntimeModule();
        }
        if ("org.eclipse.xtext.xbase.annotations.XbaseWithAnnotations".equals(grammar)) {
            return new XbaseWithAnnotationsRuntimeModule();
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getUiModule(String grammar) {
        if ("org.eclipse.xtext.xbase.Xtype".equals(grammar)) {
            return new XtypeUiModule(this);
        }
        if ("org.eclipse.xtext.xbase.Xbase".equals(grammar)) {
            return new XbaseUiModule(this);
        }
        if ("org.eclipse.xtext.xbase.annotations.XbaseWithAnnotations".equals(grammar)) {
            return new XbaseWithAnnotationsUiModule(this);
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }
}

