/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.inject.Inject;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;

public abstract class AbstractFeaturesForTypeProvider
implements IFeaturesForTypeProvider {
    @Inject
    private XbaseTypeConformanceComputer typeConformanceComputer;
    @Inject
    private TypeReferences typeReferences;

    protected boolean isSameTypeOrAssignableToUpperBound(JvmTypeReference first, JvmTypeReference second) {
        if (second == null) {
            return false;
        }
        if (second.getType() == first.getType()) {
            return true;
        }
        if (second.getType() instanceof JvmTypeParameter) {
            boolean upperBoundSeen = false;
            for (JvmTypeConstraint constraint : ((JvmTypeParameter)second.getType()).getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                upperBoundSeen = true;
                if (!this.typeConformanceComputer.isConformant(constraint.getTypeReference(), first, true)) continue;
                return true;
            }
            if (!upperBoundSeen && this.typeReferences.is(first, Object.class)) {
                return true;
            }
        }
        return false;
    }
}

