/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.refactoring;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.RenameElementHandler;
import org.eclipse.xtext.xtext.ui.refactoring.RuleOverrideUtil;

public class XtextRenameElementHandler
extends RenameElementHandler {
    @Inject
    private RuleOverrideUtil ruleOverrideUtil;

    protected IRenameElementContext createRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
        AbstractRule targetRule;
        List<IEObjectDescription> overriddenRules;
        if (targetElement instanceof AbstractRule && !(overriddenRules = this.ruleOverrideUtil.getOverriddenRules(targetRule = (AbstractRule)targetElement)).isEmpty()) {
            IEObjectDescription topMostSuperRule = overriddenRules.get(overriddenRules.size() - 1);
            StringBuilder builder = new StringBuilder();
            builder.append("Rule '").append(targetRule.getName()).append("' overrides a rule from a super grammar.\n").append("Rename super rule instead?");
            boolean isRenameSuperRule = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Overriding Rule", (String)builder.toString());
            if (isRenameSuperRule) {
                EObject newTarget = EcoreUtil.resolve((EObject)topMostSuperRule.getEObjectOrProxy(), (ResourceSet)targetElement.eResource().getResourceSet());
                return super.createRenameElementContext(newTarget, editor, selection, resource);
            }
        }
        return super.createRenameElementContext(targetElement, editor, selection, resource);
    }
}

