/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.codebuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.ide.codebuilder.InsertionOffsets;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.output.XtypeTypeReferenceSerializer;
import org.eclipse.xtext.xbase.lib.Extension;

public class MemberFromSuperImplementor {
    public static final String DEFAULT_BODY = "throw new UnsupportedOperationException(\"TODO: auto-generated method stub\")";
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private XtypeTypeReferenceSerializer typeReferenceSerializer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private InsertionOffsets insertionOffsets;
    @Inject
    private AnnotationLookup annotationLookup;

    public void appendOverrideFunction(XtendClass overrider, JvmOperation overriddenOperation, IAppendable appendable) {
        this.appendExecutable(overrider, (JvmExecutable)overriddenOperation, appendable);
    }

    public void appendConstructorFromSuper(XtendClass overrider, JvmConstructor superConstructor, IAppendable appendable) {
        this.appendExecutable(overrider, (JvmExecutable)superConstructor, appendable);
    }

    protected void appendExecutable(XtendClass overrider, JvmExecutable executableFromSuper, IAppendable appendable) {
        appendable.openScope();
        boolean isOperation = executableFromSuper instanceof JvmOperation;
        final JvmGenericType overridingType = this.associations.getInferredType(overrider);
        if (overridingType == null) {
            return;
        }
        ITypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.AbstractRequest(){

            public JvmTypeReference getReceiverType() {
                return MemberFromSuperImplementor.this.typeReferences.createTypeRef((JvmType)overridingType, new JvmTypeReference[0]);
            }
        });
        if (isOperation) {
            appendable.append((CharSequence)"override ");
        }
        if (executableFromSuper.getVisibility() == JvmVisibility.PROTECTED) {
            appendable.append((CharSequence)"protected ");
        }
        this.appendSignature(executableFromSuper, (EObject)overridingType, typeArgumentContext, appendable, false);
        if (!executableFromSuper.getExceptions().isEmpty()) {
            appendable.append((CharSequence)" throws ");
            boolean isFirst = true;
            for (JvmTypeReference exception : executableFromSuper.getExceptions()) {
                if (!isFirst) {
                    appendable.append((CharSequence)", ");
                }
                isFirst = false;
                this.typeReferenceSerializer.serialize(exception, (EObject)overridingType, appendable);
            }
        }
        appendable.append((CharSequence)" {").increaseIndentation().newLine();
        if (isOperation) {
            if (((JvmOperation)executableFromSuper).isAbstract()) {
                appendable.append((CharSequence)DEFAULT_BODY);
            } else {
                appendable.append((CharSequence)"super.");
                this.appendSignature(executableFromSuper, (EObject)overridingType, typeArgumentContext, appendable, true);
            }
        } else if (!executableFromSuper.getParameters().isEmpty()) {
            this.appendSignature(executableFromSuper, (EObject)overridingType, typeArgumentContext, appendable, true);
        }
        appendable.decreaseIndentation().newLine().append((CharSequence)"}");
        appendable.closeScope();
    }

    protected void appendSignature(JvmExecutable overridden, EObject context, ITypeArgumentContext typeArgumentContext, IAppendable appendable, boolean isCall) {
        boolean isFirst = true;
        if (!Iterables.isEmpty((Iterable)overridden.getTypeParameters())) {
            appendable.append((CharSequence)"<");
            for (JvmTypeParameter typeParameter : overridden.getTypeParameters()) {
                if (!isFirst) {
                    appendable.append((CharSequence)", ");
                }
                isFirst = false;
                appendable.append((JvmType)typeParameter);
                if (!(isCall || typeParameter.getConstraints().isEmpty() || this.hasDefaultUpperBounds(typeParameter))) {
                    appendable.append((CharSequence)" extends ");
                    boolean isFirstConstraint = true;
                    for (JvmTypeConstraint constraint : typeParameter.getConstraints()) {
                        if (!isFirstConstraint) {
                            appendable.append((CharSequence)" & ");
                        }
                        isFirstConstraint = false;
                        this.typeReferenceSerializer.serialize(constraint.getTypeReference(), (EObject)typeParameter, appendable);
                    }
                }
                if (isCall) continue;
                boolean firstConstraint = true;
                for (JvmTypeConstraint constraint : typeParameter.getConstraints()) {
                    if (this.typeReferences.is(constraint.getTypeReference(), Object.class)) continue;
                    if (firstConstraint) {
                        appendable.append((CharSequence)" extends ");
                        firstConstraint = false;
                    } else {
                        appendable.append((CharSequence)" & ");
                    }
                    JvmTypeReference constraintType = typeArgumentContext.resolve(constraint.getTypeReference());
                    this.typeReferenceSerializer.serialize(constraintType, context, appendable, false, false, false, false);
                }
            }
            appendable.append((CharSequence)">");
            if (!isCall) {
                appendable.append((CharSequence)" ");
            }
        }
        if (overridden instanceof JvmConstructor) {
            if (isCall) {
                appendable.append((CharSequence)"super");
            } else {
                appendable.append((CharSequence)"new");
            }
        } else {
            appendable.append((CharSequence)overridden.getSimpleName());
        }
        appendable.append((CharSequence)"(");
        EList parameterList = overridden.getParameters();
        int i = 0;
        while (i < parameterList.size()) {
            JvmFormalParameter param = (JvmFormalParameter)parameterList.get(i);
            if (i != 0) {
                appendable.append((CharSequence)", ");
            }
            isFirst = false;
            if (isCall) {
                appendable.append((CharSequence)appendable.getName((Object)param));
            } else {
                JvmTypeReference overriddenParameterType = typeArgumentContext.getLowerBound(param.getParameterType());
                boolean insertDots = false;
                if (overridden.isVarArgs() && overriddenParameterType instanceof JvmGenericArrayTypeReference) {
                    overriddenParameterType = ((JvmGenericArrayTypeReference)overriddenParameterType).getComponentType();
                    insertDots = true;
                }
                if (overridden instanceof JvmOperation && this.annotationLookup.findAnnotation((JvmAnnotationTarget)param, Extension.class) != null) {
                    appendable.append((CharSequence)"extension ");
                }
                this.typeReferenceSerializer.serialize(overriddenParameterType, context, appendable, false, false, false, true);
                if (insertDots) {
                    appendable.append((CharSequence)"...");
                }
                String declareVariable = appendable instanceof StringBuilderBasedAppendable ? ((StringBuilderBasedAppendable)appendable).declareSyntheticVariable((Object)param, param.getName()) : appendable.declareVariable((Object)param, param.getName());
                appendable.append((CharSequence)" ").append((CharSequence)declareVariable);
            }
            ++i;
        }
        appendable.append((CharSequence)")");
    }

    protected boolean hasDefaultUpperBounds(JvmTypeParameter typeParameter) {
        return typeParameter.getConstraints().size() == 1 && typeParameter.getConstraints().get(0) instanceof JvmUpperBound && Strings.equal((String)"java.lang.Object", (String)((JvmTypeConstraint)typeParameter.getConstraints().get(0)).getTypeReference().getIdentifier());
    }
}

