/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.FeatureCallCompiler;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.StandardTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typing.Closures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class XbaseCompiler
extends FeatureCallCompiler {
    @Inject
    private IEarlyExitComputer earlyExitComputer;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private Closures closures;
    private static final String REASSIGNED_THIS_IN_LAMBDA = "!reassigned_this_for_lambda!";

    protected void _toJavaStatement(XListLiteral literal, ITreeAppendable b, boolean isReferenced) {
        for (XExpression element : literal.getElements()) {
            this.internalToJavaStatement(element, b, true);
        }
        LightweightTypeReference literalType = this.batchTypeResolver.resolveTypes(literal).getActualType(literal);
        if (literalType == null || !literalType.isArray()) {
            if (isReferenced) {
                this.declareSyntheticVariable(literal, b);
            }
            this.toCollectionBuilderJavaStatement(literal, ImmutableList.Builder.class, b, isReferenced);
        }
    }

    protected void _toJavaStatement(XSetLiteral literal, ITreeAppendable b, boolean isReferenced) {
        LightweightTypeReference literalType;
        if (isReferenced) {
            this.declareSyntheticVariable(literal, b);
        }
        if ((literalType = this.batchTypeResolver.resolveTypes(literal).getActualType(literal)) != null && literalType.isType(Map.class)) {
            for (XExpression element : literal.getElements()) {
                this.internalToJavaStatement(((XBinaryOperation)element).getLeftOperand(), b, true);
                this.internalToJavaStatement(((XBinaryOperation)element).getRightOperand(), b, true);
            }
            String builderVar = b.declareSyntheticVariable(this.getCollectionLiteralBuilderKey(literal), "_builder");
            LightweightTypeReference keyType = literalType.getTypeArguments().get(0);
            LightweightTypeReference valueType = literalType.getTypeArguments().get(1);
            JvmType builderRawType = this.getTypeReferences().findDeclaredType(ImmutableMap.Builder.class, (Notifier)literal);
            ParameterizedTypeReference builderType = new ParameterizedTypeReference(keyType.getOwner(), builderRawType);
            builderType.addTypeArgument(keyType);
            builderType.addTypeArgument(valueType);
            b.newLine();
            this.getTypeReferenceSerializer().serialize(builderType.toTypeReference(), literal, b);
            b.append(" ").append(builderVar).append(" = ");
            JvmDeclaredType collectionType = ((JvmDeclaredType)builderType.getType()).getDeclaringType();
            b.append((JvmType)collectionType).append(".builder();").newLine();
            for (XExpression element : literal.getElements()) {
                b.append(builderVar).append(".put(");
                this.internalToJavaExpression(((XBinaryOperation)element).getLeftOperand(), b);
                b.append(", ");
                this.internalToJavaExpression(((XBinaryOperation)element).getRightOperand(), b);
                b.append(");").newLine();
            }
            if (isReferenced) {
                b.append(this.getVarName(literal, b)).append(" = ");
            }
            b.append(builderVar).append(".build();");
        } else {
            for (XExpression element : literal.getElements()) {
                this.internalToJavaStatement(element, b, true);
            }
            this.toCollectionBuilderJavaStatement(literal, ImmutableSet.Builder.class, b, isReferenced);
        }
    }

    protected void toCollectionBuilderJavaStatement(XCollectionLiteral literal, Class<?> builderClass, ITreeAppendable b, boolean isReferenced) {
        LightweightTypeReference elementType = this.getCollectionElementType(literal);
        String builderVar = b.declareSyntheticVariable(this.getCollectionLiteralBuilderKey(literal), "_builder");
        JvmType builderRawType = this.getTypeReferences().findDeclaredType(builderClass, (Notifier)literal);
        ParameterizedTypeReference builderType = new ParameterizedTypeReference(elementType.getOwner(), builderRawType);
        builderType.addTypeArgument(elementType);
        b.newLine();
        this.getTypeReferenceSerializer().serialize(builderType.toTypeReference(), literal, b);
        b.append(" ").append(builderVar).append(" = ");
        JvmDeclaredType collectionType = ((JvmDeclaredType)builderType.getType()).getDeclaringType();
        b.append((JvmType)collectionType).append(".builder();").newLine();
        for (XExpression element : literal.getElements()) {
            b.append(builderVar).append(".add(");
            this.internalToJavaExpression(element, b);
            b.append(");").newLine();
        }
        if (isReferenced) {
            b.append(this.getVarName(literal, b)).append(" = ");
        }
        b.append(builderVar).append(".build();");
    }

    protected LightweightTypeReference getCollectionElementType(XCollectionLiteral literal) {
        LightweightTypeReference type = this.batchTypeResolver.resolveTypes(literal).getActualType(literal);
        if (type == null) {
            throw new IllegalStateException();
        }
        if (type.isArray()) {
            LightweightTypeReference result = type.getComponentType();
            if (result == null) {
                throw new IllegalStateException();
            }
            return result;
        }
        if (type.isSubtypeOf(Collection.class) && !type.getTypeArguments().isEmpty()) {
            return type.getTypeArguments().get(0).getInvariantBoundSubstitute();
        }
        return new ParameterizedTypeReference(type.getOwner(), this.getTypeReferences().findDeclaredType(Object.class, (Notifier)literal));
    }

    protected Object getCollectionLiteralBuilderKey(XCollectionLiteral literal) {
        return Tuples.create((Object)literal, (Object)"_builder");
    }

    protected Object getCollectionLiteralLoopKey(XCollectionLiteral literal) {
        return Tuples.create((Object)literal, (Object)"_element");
    }

    protected void _toJavaExpression(XCollectionLiteral expr, ITreeAppendable b) {
        b.trace(expr, false).append(this.getVarName(expr, b));
    }

    protected void _toJavaExpression(XListLiteral literal, ITreeAppendable b) {
        LightweightTypeReference literalType = this.batchTypeResolver.resolveTypes(literal).getActualType(literal);
        if (literalType != null && literalType.isArray()) {
            LightweightTypeReference expectedType = this.batchTypeResolver.resolveTypes(literal).getExpectedType(literal);
            boolean skipTypeName = false;
            if (expectedType != null && expectedType.isArray() && this.canUseArrayInitializer(literal, b)) {
                skipTypeName = true;
            }
            if (!skipTypeName) {
                b.append("new ");
                this.getTypeReferenceSerializer().serialize(literalType.toTypeReference(), literal, b);
                b.append(" ");
            }
            if (literal.getElements().isEmpty()) {
                b.append("{}");
            } else {
                b.append("{ ");
                boolean isFirst = true;
                for (XExpression element : literal.getElements()) {
                    if (!isFirst) {
                        b.append(", ");
                    }
                    isFirst = false;
                    this.internalToJavaExpression(element, b);
                }
                b.append(" }");
            }
            return;
        }
        b.trace(literal, false).append(this.getVarName(literal, b));
    }

    protected boolean canUseArrayInitializer(XListLiteral literal, ITreeAppendable appendable) {
        if (literal.eContainingFeature() == XbasePackage.Literals.XVARIABLE_DECLARATION__RIGHT) {
            return this.canUseArrayInitializerImpl(literal, appendable);
        }
        return false;
    }

    protected boolean canUseArrayInitializerImpl(XListLiteral literal, ITreeAppendable appendable) {
        for (XExpression element : literal.getElements()) {
            if (!this.isVariableDeclarationRequired(element, appendable)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<XExpression> getActualArguments(XAbstractFeatureCall featureCall) {
        return featureCall.getActualArguments();
    }

    @Override
    @Nullable
    protected XExpression getActualReceiver(XAbstractFeatureCall featureCall) {
        return featureCall.getActualReceiver();
    }

    @Override
    protected boolean isMemberCall(XAbstractFeatureCall call) {
        return !call.isStatic();
    }

    @Override
    protected ITreeAppendable appendTypeArguments(XAbstractFeatureCall call, ITreeAppendable original) {
        if (!call.getTypeArguments().isEmpty()) {
            return super.appendTypeArguments(call, original);
        }
        ILocationData completeLocationData = this.getLocationWithTypeArguments(call);
        ITreeAppendable completeFeatureCallAppendable = completeLocationData != null ? original.trace(completeLocationData) : original;
        IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(call);
        List<LightweightTypeReference> typeArguments = resolvedTypes.getActualTypeArguments(call);
        if (!typeArguments.isEmpty()) {
            ArrayList resolvedTypeArguments = Lists.newArrayListWithCapacity((int)typeArguments.size());
            for (LightweightTypeReference typeArgument : typeArguments) {
                if (typeArgument.isWildcard()) {
                    return completeFeatureCallAppendable;
                }
                JvmTypeReference jvmTypeReference = typeArgument.toJavaCompliantTypeReference();
                resolvedTypeArguments.add(jvmTypeReference);
            }
            completeFeatureCallAppendable.append("<");
            int i = 0;
            while (i < resolvedTypeArguments.size()) {
                if (i != 0) {
                    completeFeatureCallAppendable.append(", ");
                }
                JvmTypeReference typeArgument = (JvmTypeReference)resolvedTypeArguments.get(i);
                this.serialize(typeArgument, call, completeFeatureCallAppendable);
                ++i;
            }
            completeFeatureCallAppendable.append(">");
        }
        return completeFeatureCallAppendable;
    }

    @Override
    protected void convertFunctionType(JvmTypeReference expectedType, final JvmTypeReference functionType, ITreeAppendable appendable, Later expression, XExpression context) {
        if (expectedType.getIdentifier().equals(Object.class.getName()) || EcoreUtil.equals((EObject)expectedType.getType(), (EObject)functionType.getType()) || expectedType instanceof JvmSynonymTypeReference && Iterables.any((Iterable)((JvmSynonymTypeReference)expectedType).getReferences(), (Predicate)new Predicate<JvmTypeReference>(){

            public boolean apply(@Nullable JvmTypeReference ref) {
                if (ref == null) {
                    throw new IllegalStateException();
                }
                return EcoreUtil.equals((EObject)ref.getType(), (EObject)functionType.getType());
            }
        })) {
            if (!this.getTypeConformanceComputer().isConformant(expectedType, functionType)) {
                appendable.append("(");
                this.serialize(expectedType, context, appendable);
                appendable.append(")");
            }
            expression.exec(appendable);
            return;
        }
        JvmOperation operation = this.getClosures().findImplementingOperation(expectedType, context.eResource());
        if (operation == null) {
            throw new IllegalStateException("expected type " + expectedType + " not mappable from " + functionType);
        }
        appendable.append("new ");
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, context.eResource().getResourceSet());
        LightweightTypeReference lightweightExpectedType = new OwnedConverter(owner).toLightweightReference(expectedType);
        FunctionTypeReference functionTypeReference = lightweightExpectedType.tryConvertToFunctionTypeReference(false);
        if (functionTypeReference == null) {
            throw new IllegalStateException("Expected type does not seem to be a SAM type");
        }
        JvmTypeReference convertedExpectedType = functionTypeReference.toInstanceTypeReference().toTypeReference();
        this.serialize(convertedExpectedType, context, appendable, false, false);
        appendable.append("() {");
        appendable.increaseIndentation().increaseIndentation();
        appendable.newLine().append("public ");
        LightweightTypeReference returnType = functionTypeReference.getReturnType();
        if (returnType == null) {
            throw new IllegalStateException("Could not find return type");
        }
        this.serialize(returnType.toTypeReference(), context, appendable, false, false);
        appendable.append(" ").append(operation.getSimpleName()).append("(");
        EList params = operation.getParameters();
        int i = 0;
        while (i < params.size()) {
            if (i != 0) {
                appendable.append(",");
            }
            JvmFormalParameter p = (JvmFormalParameter)params.get(i);
            String name = p.getName();
            this.serialize(functionTypeReference.getParameterTypes().get(i).toTypeReference(), context, appendable, false, false);
            appendable.append(" ").append(name);
            ++i;
        }
        appendable.append(") {");
        appendable.increaseIndentation();
        try {
            appendable.openScope();
            this.reassignThisInClosure(appendable, (JvmType)operation.getDeclaringType());
            if (!this.getTypeReferences().is(operation.getReturnType(), Void.TYPE)) {
                appendable.newLine().append("return ");
            } else {
                appendable.newLine();
            }
            expression.exec(appendable);
            appendable.append(".");
            JvmOperation actualOperation = this.getClosures().findImplementingOperation(functionType, context.eResource());
            appendable.append(actualOperation.getSimpleName());
            appendable.append("(");
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                JvmFormalParameter p = (JvmFormalParameter)iterator.next();
                String name = p.getName();
                appendable.append(name);
                if (!iterator.hasNext()) continue;
                appendable.append(",");
            }
            appendable.append(");");
        }
        finally {
            appendable.closeScope();
        }
        appendable.decreaseIndentation();
        appendable.newLine().append("}");
        appendable.decreaseIndentation().decreaseIndentation();
        appendable.newLine().append("}");
    }

    @Override
    protected void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        if (obj instanceof XBlockExpression) {
            this._toJavaExpression((XBlockExpression)obj, appendable);
        } else if (obj instanceof XCastedExpression) {
            this._toJavaExpression((XCastedExpression)obj, appendable);
        } else if (obj instanceof XClosure) {
            this._toJavaExpression((XClosure)obj, appendable);
        } else if (obj instanceof XConstructorCall) {
            this._toJavaExpression((XConstructorCall)obj, appendable);
        } else if (obj instanceof XIfExpression) {
            this._toJavaExpression((XIfExpression)obj, appendable);
        } else if (obj instanceof XInstanceOfExpression) {
            this._toJavaExpression((XInstanceOfExpression)obj, appendable);
        } else if (obj instanceof XSwitchExpression) {
            this._toJavaExpression((XSwitchExpression)obj, appendable);
        } else if (obj instanceof XTryCatchFinallyExpression) {
            this._toJavaExpression((XTryCatchFinallyExpression)obj, appendable);
        } else if (obj instanceof XListLiteral) {
            this._toJavaExpression((XListLiteral)obj, appendable);
        } else if (obj instanceof XSetLiteral) {
            this._toJavaExpression((XSetLiteral)obj, appendable);
        } else {
            super.internalToConvertedExpression(obj, appendable);
        }
    }

    @Override
    protected void doInternalToJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        if (obj instanceof XBlockExpression) {
            this._toJavaStatement((XBlockExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XCastedExpression) {
            this._toJavaStatement((XCastedExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XClosure) {
            this._toJavaStatement((XClosure)obj, appendable, isReferenced);
        } else if (obj instanceof XConstructorCall) {
            this._toJavaStatement((XConstructorCall)obj, appendable, isReferenced);
        } else if (obj instanceof XDoWhileExpression) {
            this._toJavaStatement((XDoWhileExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XForLoopExpression) {
            this._toJavaStatement((XForLoopExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XIfExpression) {
            this._toJavaStatement((XIfExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XInstanceOfExpression) {
            this._toJavaStatement((XInstanceOfExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XReturnExpression) {
            this._toJavaStatement((XReturnExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XSwitchExpression) {
            this._toJavaStatement((XSwitchExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XThrowExpression) {
            this._toJavaStatement((XThrowExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XTryCatchFinallyExpression) {
            this._toJavaStatement((XTryCatchFinallyExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XVariableDeclaration) {
            this._toJavaStatement((XVariableDeclaration)obj, appendable, isReferenced);
        } else if (obj instanceof XWhileExpression) {
            this._toJavaStatement((XWhileExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XListLiteral) {
            this._toJavaStatement((XListLiteral)obj, appendable, isReferenced);
        } else if (obj instanceof XSetLiteral) {
            this._toJavaStatement((XSetLiteral)obj, appendable, isReferenced);
        } else {
            super.doInternalToJavaStatement(obj, appendable, isReferenced);
        }
    }

    protected void _toJavaStatement(XBlockExpression expr, ITreeAppendable b, boolean isReferenced) {
        boolean needsBraces;
        b = b.trace(expr, false);
        if (expr.getExpressions().isEmpty()) {
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToJavaStatement((XExpression)expr.getExpressions().get(0), b, isReferenced);
            return;
        }
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b);
        }
        boolean bl = needsBraces = isReferenced || !this.bracesAreAddedByOuterStructure(expr);
        if (needsBraces) {
            b.newLine().append("{").increaseIndentation();
            b.openPseudoScope();
        }
        EList<XExpression> expressions = expr.getExpressions();
        int i = 0;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            if (i < expressions.size() - 1) {
                this.internalToJavaStatement(ex, b, false);
            } else {
                this.internalToJavaStatement(ex, b, isReferenced);
                if (isReferenced) {
                    b.newLine().append(this.getVarName(expr, b)).append(" = (");
                    this.internalToConvertedExpression(ex, b, this.getType(expr));
                    b.append(");");
                }
            }
            ++i;
        }
        if (needsBraces) {
            b.closeScope();
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected boolean bracesAreAddedByOuterStructure(XBlockExpression block) {
        EObject container = block.eContainer();
        if (container instanceof XTryCatchFinallyExpression || container instanceof XIfExpression || container instanceof XClosure) {
            return true;
        }
        return !(container instanceof XExpression);
    }

    protected void _toJavaExpression(XBlockExpression expr, ITreeAppendable b) {
        if (expr.getExpressions().isEmpty()) {
            b.append("null");
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToConvertedExpression((XExpression)expr.getExpressions().get(0), b, null);
            return;
        }
        b = b.trace(expr, false);
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XTryCatchFinallyExpression expr, ITreeAppendable outerAppendable, boolean isReferenced) {
        ITreeAppendable b = outerAppendable.trace(expr, false);
        if (isReferenced && !this.isPrimitiveVoid(expr)) {
            this.declareSyntheticVariable(expr, b);
        }
        b.newLine().append("try {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getExpression());
        this.internalToJavaStatement(expr.getExpression(), b, canBeReferenced);
        if (canBeReferenced) {
            b.newLine().append(this.getVarName(expr, b)).append(" = ");
            this.internalToConvertedExpression(expr.getExpression(), b, this.getType(expr));
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("}");
        this.appendCatchAndFinally(expr, b, isReferenced);
    }

    protected void appendCatchAndFinally(XTryCatchFinallyExpression expr, ITreeAppendable b, boolean isReferenced) {
        XExpression finallyExp;
        EList<XCatchClause> catchClauses = expr.getCatchClauses();
        if (!catchClauses.isEmpty()) {
            String variable = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"_catchedThrowable"), "_t");
            b.append(" catch (final Throwable ").append(variable).append(") ");
            b.append("{").increaseIndentation();
            b.newLine();
            Iterator iterator = catchClauses.iterator();
            while (iterator.hasNext()) {
                XCatchClause catchClause = (XCatchClause)iterator.next();
                ITreeAppendable catchClauseAppendable = b.trace(catchClause);
                this.appendCatchClause(catchClause, isReferenced, variable, catchClauseAppendable);
                if (!iterator.hasNext()) continue;
                b.append(" else ");
            }
            b.append(" else {");
            b.increaseIndentation();
            JvmType sneakyThrowType = this.getTypeReferences().findDeclaredType(Exceptions.class, (Notifier)expr);
            if (sneakyThrowType == null) {
                b.append("COMPILE ERROR : '" + Exceptions.class.getCanonicalName() + "' could not be found on the classpath!");
            } else {
                b.newLine().append("throw ");
                b.append(sneakyThrowType);
                b.append(".sneakyThrow(");
                b.append(variable);
                b.append(");");
            }
            b.decreaseIndentation();
            b.newLine().append("}");
            b.decreaseIndentation();
            b.newLine().append("}");
        }
        if ((finallyExp = expr.getFinallyExpression()) != null) {
            b.append(" finally {").increaseIndentation();
            this.internalToJavaStatement(finallyExp, b, false);
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected void appendCatchClause(XCatchClause catchClause, boolean parentIsReferenced, String parentVariable, ITreeAppendable appendable) {
        JvmTypeReference type = catchClause.getDeclaredParam().getParameterType();
        String declaredParamName = this.makeJavaIdentifier(catchClause.getDeclaredParam().getName());
        String name = appendable.declareVariable(catchClause.getDeclaredParam(), declaredParamName);
        appendable.append("if (").append(parentVariable).append(" instanceof ");
        this.serialize(type, catchClause, appendable);
        appendable.append(") ").append("{");
        appendable.increaseIndentation();
        ITreeAppendable withDebugging = appendable.trace(catchClause, true);
        ITreeAppendable parameterAppendable = withDebugging.trace((EObject)catchClause.getDeclaredParam());
        this.appendCatchClauseParameter(catchClause, type, name, parameterAppendable.newLine());
        withDebugging.append(" = (");
        this.serialize(type, catchClause, withDebugging);
        withDebugging.append(")").append(parentVariable).append(";");
        boolean canBeReferenced = parentIsReferenced && !this.isPrimitiveVoid(catchClause.getExpression());
        this.internalToJavaStatement(catchClause.getExpression(), withDebugging, canBeReferenced);
        if (canBeReferenced) {
            appendable.newLine().append(this.getVarName(catchClause.eContainer(), appendable)).append(" = ");
            this.internalToConvertedExpression(catchClause.getExpression(), appendable, this.getType((XExpression)catchClause.eContainer()));
            appendable.append(";");
        }
        appendable.decreaseIndentation();
        appendable.newLine().append("}");
    }

    protected void appendCatchClauseParameter(XCatchClause catchClause, JvmTypeReference parameterType, String parameterName, ITreeAppendable appendable) {
        appendable.append("final ");
        this.serialize(parameterType, catchClause, appendable);
        appendable.append(" ");
        appendable.trace((EObject)catchClause.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, 0).append(parameterName);
    }

    protected void _toJavaExpression(XTryCatchFinallyExpression expr, ITreeAppendable b) {
        b.trace(expr, false).append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XThrowExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
        b.newLine().append("throw ");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(";");
    }

    protected void _toJavaExpression(XInstanceOfExpression expr, ITreeAppendable b) {
        b.append("(");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(" instanceof ");
        this.serialize(expr.getType(), expr, b);
        b.append(")");
    }

    protected void _toJavaStatement(XInstanceOfExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
    }

    protected void _toJavaStatement(XVariableDeclaration varDeclaration, ITreeAppendable b, boolean isReferenced) {
        if (varDeclaration.getRight() != null) {
            this.internalToJavaStatement(varDeclaration.getRight(), b, true);
        }
        b.newLine();
        JvmTypeReference type = this.appendVariableTypeAndName(varDeclaration, b);
        b.append(" = ");
        if (varDeclaration.getRight() != null) {
            this.internalToConvertedExpression(varDeclaration.getRight(), b, type);
        } else {
            this.appendDefaultLiteral(b, type);
        }
        b.append(";");
    }

    protected JvmTypeReference appendVariableTypeAndName(XVariableDeclaration varDeclaration, ITreeAppendable appendable) {
        if (!varDeclaration.isWriteable()) {
            appendable.append("final ");
        }
        JvmTypeReference type = null;
        type = varDeclaration.getType() != null ? varDeclaration.getType() : this.getType(varDeclaration.getRight());
        this.serialize(type, varDeclaration, appendable);
        appendable.append(" ");
        appendable.append(appendable.declareVariable(varDeclaration, this.makeJavaIdentifier(varDeclaration.getName())));
        return type;
    }

    protected void _toJavaStatement(XWhileExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        String varName = b.declareSyntheticVariable(expr, "_while");
        b.newLine().append("boolean ").append(varName).append(" = ");
        this.internalToJavaExpression(expr.getPredicate(), b);
        b.append(";");
        b.newLine().append("while (");
        b.append(varName);
        b.append(") {").increaseIndentation();
        b.openPseudoScope();
        this.internalToJavaStatement(expr.getBody(), b, false);
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.newLine();
        if (!this.earlyExitComputer.isEarlyExit(expr.getBody())) {
            b.append(varName).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.closeScope();
        b.decreaseIndentation().newLine().append("}");
    }

    protected void _toJavaStatement(XDoWhileExpression expr, ITreeAppendable b, boolean isReferenced) {
        String variable = b.declareSyntheticVariable(expr, "_dowhile");
        b.newLine().append("boolean ").append(variable).append(" = false;");
        b.newLine().append("do {").increaseIndentation();
        this.internalToJavaStatement(expr.getBody(), b, false);
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.newLine();
        if (!this.earlyExitComputer.isEarlyExit(expr.getBody())) {
            b.append(variable).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("} while(");
        b.append(variable);
        b.append(");");
    }

    protected void _toJavaStatement(XForLoopExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getForExpression(), b, true);
        b.newLine();
        ITreeAppendable loopAppendable = b.trace(expr);
        loopAppendable.append("for (");
        ITreeAppendable parameterAppendable = loopAppendable.trace((EObject)expr.getDeclaredParam());
        this.appendForLoopParameter(expr, parameterAppendable);
        loopAppendable.append(" : ");
        this.internalToJavaExpression(expr.getForExpression(), loopAppendable);
        loopAppendable.append(") {").increaseIndentation();
        this.internalToJavaStatement(expr.getEachExpression(), loopAppendable, false);
        loopAppendable.decreaseIndentation().newLine().append("}");
    }

    protected void appendForLoopParameter(XForLoopExpression expr, ITreeAppendable appendable) {
        appendable.append("final ");
        JvmTypeReference paramType = this.getForLoopParameterType(expr);
        this.serialize(paramType, expr, appendable);
        appendable.append(" ");
        String name = this.makeJavaIdentifier(expr.getDeclaredParam().getName());
        String varName = appendable.declareVariable(expr.getDeclaredParam(), name);
        appendable.trace((EObject)expr.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, 0).append(varName);
    }

    protected JvmTypeReference getForLoopParameterType(XForLoopExpression expr) {
        JvmTypeReference declaredType = expr.getDeclaredParam().getParameterType();
        if (declaredType != null) {
            return declaredType;
        }
        return this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)expr.getDeclaredParam());
    }

    protected void _toJavaStatement(final XConstructorCall expr, ITreeAppendable b, boolean isReferenced) {
        for (XExpression arg : expr.getArguments()) {
            this.internalToJavaStatement(arg, b, true);
        }
        Later later = new Later(){

            public void exec(ITreeAppendable constructorCallAppendable) {
                ILocationData locationWithNewKeyword = XbaseCompiler.this.getLocationWithNewKeyword(expr);
                ITreeAppendable appendableWithNewKeyword = locationWithNewKeyword != null ? constructorCallAppendable.trace(locationWithNewKeyword) : constructorCallAppendable;
                appendableWithNewKeyword.append("new ");
                JvmTypeReference producedType = XbaseCompiler.this.getType(expr);
                XbaseCompiler.this.serialize(producedType, expr, appendableWithNewKeyword.trace(expr, (EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, 0), false, false, true, false);
                constructorCallAppendable.append("(");
                XbaseCompiler.this.appendArguments((List<? extends XExpression>)expr.getArguments(), constructorCallAppendable);
                constructorCallAppendable.append(")");
            }
        };
        if (isReferenced) {
            this.declareFreshLocalVariable(expr, b, later);
        } else {
            b.newLine();
            later.exec(b);
            b.append(";");
        }
    }

    @Nullable
    protected ILocationData getLocationWithNewKeyword(XConstructorCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)call);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            for (INode child : startNode.getChildren()) {
                if (child.getGrammarElement() instanceof Keyword && "(".equals(child.getText())) break;
                resultNodes.add(child);
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected void _toJavaExpression(XConstructorCall expr, ITreeAppendable b) {
        String varName = this.getVarName(expr, b);
        b.trace(expr, false).append(varName);
    }

    protected void _toJavaStatement(XReturnExpression expr, ITreeAppendable b, boolean isReferenced) {
        if (expr.getExpression() != null) {
            JvmIdentifiableElement logicalContainer = this.getLogicalContainerProvider().getNearestLogicalContainer(expr);
            boolean needsSneakyThrow = false;
            if (logicalContainer instanceof JvmExecutable) {
                EList declaredExceptions = ((JvmExecutable)logicalContainer).getExceptions();
                needsSneakyThrow = this.needsSneakyThrow(expr.getExpression(), (Collection<JvmTypeReference>)declaredExceptions);
            }
            if (needsSneakyThrow) {
                b.newLine().append("try {").increaseIndentation();
            }
            this.internalToJavaStatement(expr.getExpression(), b, true);
            b.newLine().append("return ");
            this.internalToJavaExpression(expr.getExpression(), b);
            b.append(";");
            if (needsSneakyThrow) {
                this.generateCheckedExceptionHandling(expr, b);
            }
        } else {
            b.newLine().append("return;");
        }
    }

    protected void _toJavaExpression(XCastedExpression expr, ITreeAppendable b) {
        b.append("((");
        this.serialize(expr.getType(), expr, b);
        b.append(") ");
        this.internalToConvertedExpression(expr.getTarget(), b, expr.getType());
        b.append(")");
    }

    protected void _toJavaStatement(XCastedExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getTarget(), b, isReferenced);
    }

    protected void _toJavaStatement(XIfExpression expr, ITreeAppendable b, boolean isReferenced) {
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b);
        }
        this.internalToJavaStatement(expr.getIf(), b, true);
        b.newLine().append("if (");
        this.internalToJavaExpression(expr.getIf(), b);
        b.append(") {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getThen());
        this.internalToJavaStatement(expr.getThen(), b, canBeReferenced);
        if (canBeReferenced) {
            b.newLine();
            b.append(this.getVarName(expr, b));
            b.append(" = ");
            this.internalToConvertedExpression(expr.getThen(), b, this.getType(expr));
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("}");
        if (expr.getElse() != null) {
            b.append(" else {").increaseIndentation();
            boolean canElseBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getElse());
            this.internalToJavaStatement(expr.getElse(), b, canElseBeReferenced);
            if (canElseBeReferenced) {
                b.newLine();
                b.append(this.getVarName(expr, b));
                b.append(" = ");
                this.internalToConvertedExpression(expr.getElse(), b, this.getType(expr));
                b.append(";");
            }
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected void _toJavaExpression(XIfExpression expr, ITreeAppendable b) {
        b.trace(expr, false).append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XSwitchExpression expr, ITreeAppendable b, boolean isReferenced) {
        boolean canBeReferenced;
        JvmIdentifiableElement feature;
        JvmTypeReference type = this.getTypeForVariableDeclaration(expr);
        String switchResultName = b.declareSyntheticVariable(this.getSwitchExpressionKey(expr), "_switchResult");
        if (isReferenced) {
            b.newLine();
            this.serialize(type, expr, b);
            b.append(" ").append(switchResultName).append(" = ");
            b.append(this.getDefaultValueLiteral(expr));
            b.append(";");
        }
        this.internalToJavaStatement(expr.getSwitch(), b, true);
        String matchedVariable = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"matches"), "_matched");
        String variableName = null;
        if (expr.getLocalVarName() == null && expr.getSwitch() instanceof XFeatureCall && b.hasName(feature = ((XFeatureCall)expr.getSwitch()).getFeature())) {
            variableName = b.getName(feature);
        }
        if (variableName == null) {
            String name = this.getNameProvider().getSimpleName(expr);
            name = name != null ? this.makeJavaIdentifier(name) : "_switchValue";
            JvmTypeReference typeReference = this.getType(expr.getSwitch());
            b.newLine().append("final ");
            this.serialize(typeReference, expr, b);
            b.append(" ");
            variableName = b.declareSyntheticVariable(expr, name);
            if (expr.getLocalVarName() != null) {
                b.trace(expr, (EStructuralFeature)XbasePackage.Literals.XSWITCH_EXPRESSION__LOCAL_VAR_NAME, 0).append(variableName);
            } else {
                b.append(variableName);
            }
            b.append(" = ");
            this.internalToJavaExpression(expr.getSwitch(), b);
            b.append(";");
        }
        b.newLine().append("boolean ");
        b.append(matchedVariable).append(" = false;");
        for (XCasePart casePart : expr.getCases()) {
            ITreeAppendable caseAppendable = b.trace(casePart, true);
            caseAppendable.newLine().append("if (!").append(matchedVariable).append(") {");
            caseAppendable.increaseIndentation();
            if (casePart.getTypeGuard() != null) {
                ITreeAppendable typeGuardAppendable = caseAppendable.trace((EObject)casePart.getTypeGuard(), true);
                typeGuardAppendable.newLine().append("if (");
                typeGuardAppendable.append(variableName);
                typeGuardAppendable.append(" instanceof ");
                typeGuardAppendable.trace((EObject)casePart.getTypeGuard()).append(casePart.getTypeGuard().getType());
                typeGuardAppendable.append(") {");
                typeGuardAppendable.increaseIndentation();
                XSwitchExpression switchOver = expr.getLocalVarName() == null && this.isSimpleFeatureCall(expr.getSwitch()) ? ((XFeatureCall)expr.getSwitch()).getFeature() : expr;
                typeGuardAppendable.openPseudoScope();
                String proposedName = this.getFavoriteVariableName((EObject)casePart.getTypeGuard().getType());
                String castedVariableName = typeGuardAppendable.declareSyntheticVariable(switchOver, proposedName);
                typeGuardAppendable.newLine().append("final ");
                this.serialize(casePart.getTypeGuard(), expr, typeGuardAppendable);
                typeGuardAppendable.append(" ");
                typeGuardAppendable.append(castedVariableName);
                typeGuardAppendable.append(" = (");
                this.serialize(casePart.getTypeGuard(), expr, typeGuardAppendable);
                typeGuardAppendable.append(")");
                typeGuardAppendable.append(variableName);
                typeGuardAppendable.append(";");
            }
            if (casePart.getCase() != null) {
                ITreeAppendable conditionAppendable = caseAppendable.trace(casePart.getCase(), true);
                this.internalToJavaStatement(casePart.getCase(), conditionAppendable, true);
                conditionAppendable.newLine().append("if (");
                JvmTypeReference convertedType = this.getType(casePart.getCase());
                if (this.getTypeReferences().is(convertedType, Boolean.TYPE) || this.getTypeReferences().is(convertedType, Boolean.class)) {
                    this.internalToJavaExpression(casePart.getCase(), conditionAppendable);
                } else {
                    JvmTypeReference typeRef = this.getTypeReferences().getTypeForName(Objects.class, (Notifier)expr, new JvmTypeReference[0]);
                    this.serialize(typeRef, casePart, conditionAppendable);
                    conditionAppendable.append(".equal(").append(variableName).append(",");
                    this.internalToJavaExpression(casePart.getCase(), conditionAppendable);
                    conditionAppendable.append(")");
                }
                conditionAppendable.append(")");
                caseAppendable.append(" {");
                caseAppendable.increaseIndentation();
            }
            caseAppendable.newLine().append(matchedVariable).append("=true;");
            canBeReferenced = isReferenced && !this.isPrimitiveVoid(casePart.getThen());
            this.internalToJavaStatement(casePart.getThen(), caseAppendable, canBeReferenced);
            if (canBeReferenced) {
                caseAppendable.newLine().append(switchResultName).append(" = ");
                this.internalToConvertedExpression(casePart.getThen(), caseAppendable, this.getType(expr));
                caseAppendable.append(";");
            }
            if (casePart.getCase() != null) {
                caseAppendable.decreaseIndentation().newLine().append("}");
            }
            if (casePart.getTypeGuard() != null) {
                caseAppendable.decreaseIndentation().newLine().append("}");
                caseAppendable.closeScope();
            }
            caseAppendable.decreaseIndentation();
            caseAppendable.newLine().append("}");
        }
        if (expr.getDefault() != null) {
            boolean needsMatcherIf;
            ILocationData location = this.getLocationOfDefault(expr);
            ITreeAppendable defaultAppendable = location != null ? b.trace(location) : b;
            boolean bl = needsMatcherIf = isReferenced || !this.allCasesAreExitedEarly(expr);
            if (needsMatcherIf) {
                defaultAppendable.newLine().append("if (!").append(matchedVariable).append(") {");
                defaultAppendable.increaseIndentation();
            }
            canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getDefault());
            this.internalToJavaStatement(expr.getDefault(), defaultAppendable, canBeReferenced);
            if (canBeReferenced) {
                defaultAppendable.newLine().append(switchResultName).append(" = ");
                this.internalToConvertedExpression(expr.getDefault(), defaultAppendable, this.getType(expr));
                defaultAppendable.append(";");
            }
            if (needsMatcherIf) {
                defaultAppendable.decreaseIndentation();
                defaultAppendable.newLine().append("}");
            }
        }
    }

    protected boolean allCasesAreExitedEarly(XSwitchExpression expr) {
        for (XCasePart casePart : expr.getCases()) {
            if (this.earlyExitComputer.isEarlyExit(casePart.getThen())) continue;
            return false;
        }
        return true;
    }

    protected boolean isSimpleFeatureCall(XExpression switch1) {
        if (switch1 instanceof XFeatureCall) {
            XFeatureCall featureCall = (XFeatureCall)switch1;
            return !(featureCall.getFeature() instanceof JvmOperation);
        }
        return false;
    }

    protected Object getSwitchExpressionKey(XSwitchExpression expr) {
        return new Pair((Object)expr, (Object)"key");
    }

    @Override
    @Nullable
    protected String getReferenceName(XExpression expr, ITreeAppendable b) {
        Object key;
        if (expr instanceof XSwitchExpression && b.hasName(key = this.getSwitchExpressionKey((XSwitchExpression)expr))) {
            return b.getName(key);
        }
        return super.getReferenceName(expr, b);
    }

    @Nullable
    protected ILocationData getLocationOfDefault(XSwitchExpression expression) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)expression);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            boolean defaultSeen = false;
            for (INode child : startNode.getChildren()) {
                if (defaultSeen) {
                    resultNodes.add(child);
                    if (GrammarUtil.containingAssignment((EObject)child.getGrammarElement()) == null) continue;
                    break;
                }
                if (!(child.getGrammarElement() instanceof Keyword) || !"default".equals(child.getText())) continue;
                defaultSeen = true;
                resultNodes.add(child);
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected void _toJavaExpression(XSwitchExpression expr, ITreeAppendable b) {
        String referenceName = this.getReferenceName(expr, b);
        if (referenceName == null) {
            throw new IllegalStateException("Switch expression wasn't translated to Java statements before.");
        }
        b.trace(expr, false).append(referenceName);
    }

    protected void _toJavaStatement(XClosure closure, ITreeAppendable b, boolean isReferenced) {
        if (!isReferenced) {
            throw new IllegalArgumentException("a closure definition does not cause any side-effects");
        }
        JvmTypeReference type = this.getType(closure);
        b.newLine().append("final ");
        this.serialize(type, closure, b);
        b.append(" ");
        String variableName = b.declareSyntheticVariable(closure, "_function");
        b.append(variableName).append(" = ");
        b.append("new ");
        this.serialize(type, closure, b, false, false, true, false);
        b.append("() {");
        b.increaseIndentation().increaseIndentation();
        try {
            b.openScope();
            JvmOperation operation = this.findImplementingOperation(type, closure);
            if (operation != null) {
                JvmTypeReference returnType = this.getClosureOperationReturnType(type, operation);
                this.appendOperationVisibility(b, operation);
                this.serialize(returnType, closure, b, false, false, true, true);
                b.append(" ").append(operation.getSimpleName());
                b.append("(");
                EList<JvmFormalParameter> closureParams = closure.getFormalParameters();
                int i = 0;
                while (i < closureParams.size()) {
                    JvmFormalParameter closureParam = (JvmFormalParameter)closureParams.get(i);
                    JvmTypeReference parameterType = this.getClosureOperationParameterType(type, operation, i);
                    this.appendClosureParameter(closureParam, parameterType, closure, b);
                    if (i != closureParams.size() - 1) {
                        b.append(", ");
                    }
                    ++i;
                }
                b.append(")");
                if (!operation.getExceptions().isEmpty()) {
                    b.append(" throws ");
                    i = 0;
                    while (i < operation.getExceptions().size()) {
                        this.serialize((JvmTypeReference)operation.getExceptions().get(i), closure, b, false, false, false, false);
                        if (i != operation.getExceptions().size() - 1) {
                            b.append(", ");
                        }
                        ++i;
                    }
                }
                b.append(" {");
                b.increaseIndentation();
                this.reassignThisInClosure(b, type.getType());
                this.compile(closure.getExpression(), b, operation.getReturnType(), Sets.newHashSet((Iterable)operation.getExceptions()));
                b.decreaseIndentation();
                b.newLine().append("}");
            }
        }
        finally {
            b.closeScope();
        }
        b.decreaseIndentation().newLine().append("};").decreaseIndentation();
    }

    protected void appendClosureParameter(JvmFormalParameter closureParam, JvmTypeReference parameterType, XClosure closure, ITreeAppendable appendable) {
        appendable.append("final ");
        this.serialize(parameterType, closure, appendable, false, false, true, true);
        appendable.append(" ");
        String proposedParamName = this.makeJavaIdentifier(closureParam.getName());
        String name = appendable.declareVariable(closureParam, proposedParamName);
        appendable.append(name);
    }

    protected void appendOperationVisibility(ITreeAppendable b, JvmOperation operation) {
        b.newLine();
        JvmDeclaredType declaringType = operation.getDeclaringType();
        if (declaringType instanceof JvmGenericType && !((JvmGenericType)declaringType).isInterface()) {
            b.append("@Override").newLine();
        }
        switch (operation.getVisibility()) {
            case DEFAULT: {
                break;
            }
            case PUBLIC: {
                b.append("public ");
                return;
            }
            case PROTECTED: {
                b.append("protected ");
                return;
            }
            case PRIVATE: {
                b.append("private ");
                return;
            }
        }
    }

    @Nullable
    protected JvmOperation findImplementingOperation(JvmTypeReference closureType, EObject context) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, context);
        OwnedConverter converter = new OwnedConverter(owner);
        LightweightTypeReference lightweightTypeReference = converter.toLightweightReference(closureType);
        return this.services.getFunctionTypes().findImplementingOperation(lightweightTypeReference);
    }

    protected void reassignThisInClosure(ITreeAppendable b, JvmType rawClosureType) {
        boolean registerClosureAsThis = rawClosureType instanceof JvmGenericType;
        boolean isAlreadyInALambda = b.hasObject(REASSIGNED_THIS_IN_LAMBDA);
        if (b.hasObject("this") && !isAlreadyInALambda) {
            Object element = b.getObject("this");
            if (element instanceof JvmType) {
                String proposedName = String.valueOf(((JvmType)element).getSimpleName()) + ".this";
                if (!b.hasObject(proposedName)) {
                    Object superElement;
                    b.declareSyntheticVariable(element, proposedName);
                    if (b.hasObject("super") && (superElement = b.getObject("super")) instanceof JvmType) {
                        b.declareSyntheticVariable(superElement, String.valueOf(((JvmType)element).getSimpleName()) + ".super");
                    }
                }
            } else {
                registerClosureAsThis = false;
            }
        }
        if (!isAlreadyInALambda) {
            b.declareSyntheticVariable(REASSIGNED_THIS_IN_LAMBDA, REASSIGNED_THIS_IN_LAMBDA);
        }
        if (registerClosureAsThis) {
            b.declareVariable(rawClosureType, "this");
        }
    }

    protected JvmTypeReference getClosureOperationParameterType(JvmTypeReference closureType, JvmOperation operation, int i) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, operation.eResource().getResourceSet());
        OwnedConverter converter = new OwnedConverter(owner);
        LightweightTypeReference lightweightTypeReference = converter.toLightweightReference(closureType);
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(lightweightTypeReference);
        LightweightTypeReference parameterType = converter.toLightweightReference(((JvmFormalParameter)operation.getParameters().get(i)).getParameterType());
        return new StandardTypeParameterSubstitutor(mapping, owner).substitute(parameterType).toJavaCompliantTypeReference();
    }

    protected JvmTypeReference getClosureOperationReturnType(JvmTypeReference closureType, JvmOperation operation) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, operation.eResource().getResourceSet());
        OwnedConverter converter = new OwnedConverter(owner);
        LightweightTypeReference lightweightTypeReference = converter.toLightweightReference(closureType);
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(lightweightTypeReference);
        LightweightTypeReference parameterType = converter.toLightweightReference(operation.getReturnType());
        return new StandardTypeParameterSubstitutor(mapping, owner).substitute(parameterType).toJavaCompliantTypeReference();
    }

    protected void _toJavaExpression(XClosure call, ITreeAppendable b) {
        b.trace(call, false).append(this.getVarName(call, b));
    }

    @Override
    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        if (expression instanceof XSwitchExpression) {
            XSwitchExpression switchExpression = (XSwitchExpression)expression;
            return appendable.hasName(this.getSwitchExpressionKey(switchExpression)) || !this.isVariableDeclarationRequired(expression, appendable);
        }
        return super.internalCanCompileToJavaExpression(expression, appendable);
    }

    @Override
    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b) {
        LightweightTypeReference type;
        if (expr instanceof XListLiteral && (type = this.batchTypeResolver.resolveTypes(expr).getActualType(expr)) != null && type.isArray()) {
            return false;
        }
        if (expr instanceof XCastedExpression) {
            return false;
        }
        if (expr instanceof XInstanceOfExpression) {
            return false;
        }
        EObject container = expr.eContainer();
        if (container instanceof XVariableDeclaration || container instanceof XReturnExpression || container instanceof XThrowExpression) {
            return false;
        }
        return super.isVariableDeclarationRequired(expr, b);
    }

    protected Closures getClosures() {
        return this.closures;
    }
}

