/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticImportsScope
extends AbstractSessionBasedScope {
    public AbstractStaticImportsScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall context) {
        super(parent, session, context);
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (TypeBucket bucket : buckets) {
            for (JvmType jvmType : bucket.getTypes()) {
                if (!(jvmType instanceof JvmDeclaredType)) continue;
                Iterable features = ((JvmDeclaredType)jvmType).getAllFeatures();
                for (JvmFeature feature : features) {
                    if (!feature.isStatic()) continue;
                    this.addDescriptions(feature, bucket, result);
                }
            }
        }
        return result;
    }

    protected void addDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        result.add(this.createDescription(QualifiedName.create((String)feature.getSimpleName()), feature, bucket));
    }

    protected abstract List<TypeBucket> getBuckets();

    @Override
    protected void processFeatureNames(QualifiedName name, AbstractSessionBasedScope.NameAcceptor acceptor) {
        super.processFeatureNames(name, acceptor);
        this.processAsPropertyNames(name, acceptor);
    }

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(final QualifiedName name) {
        final List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList result = Lists.newArrayList();
        this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

            public void accept(String simpleName, int order) {
                for (TypeBucket bucket : buckets) {
                    for (JvmType jvmType : bucket.getTypes()) {
                        if (!(jvmType instanceof JvmDeclaredType)) continue;
                        Iterable features = ((JvmDeclaredType)jvmType).findAllFeaturesByName(simpleName);
                        Iterable filtered = order == 1 ? features : Iterables.filter((Iterable)features, JvmOperation.class);
                        for (JvmFeature feature : filtered) {
                            BucketedEObjectDescription description;
                            if (!feature.isStatic() || (description = AbstractStaticImportsScope.this.createDescription(name, feature, bucket)) == null) continue;
                            result.add(description);
                        }
                    }
                }
            }
        });
        return result;
    }

    protected abstract BucketedEObjectDescription createDescription(QualifiedName var1, JvmFeature var2, TypeBucket var3);
}

