/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class AbstractUnresolvableReference
implements ILinkingCandidate {
    private final XExpression expression;
    private final ExpressionTypeComputationState state;

    public AbstractUnresolvableReference(XExpression expression, ExpressionTypeComputationState state) {
        this.expression = expression;
        this.state = state;
    }

    @Override
    public XExpression getExpression() {
        return this.expression;
    }

    @Override
    public void applyToComputationState() {
        this.state.getResolvedTypes().acceptLinkingInformation(this.expression, this);
        this.computeArgumentTypes();
        this.applyType();
        this.getResolvedTypes().mergeIntoParent();
    }

    protected void applyType() {
        for (ITypeExpectation iTypeExpectation : this.state.getExpectations()) {
            LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
            if (expectedType != null) {
                iTypeExpectation.acceptActualType(expectedType, ConformanceHint.CHECKED, ConformanceHint.SUCCESS);
                continue;
            }
            iTypeExpectation.acceptActualType(new UnknownTypeReference(iTypeExpectation.getReferenceOwner()), ConformanceHint.CHECKED, ConformanceHint.SUCCESS);
        }
    }

    protected ExpressionTypeComputationState getState() {
        return this.state;
    }

    protected StackedResolvedTypes getResolvedTypes() {
        return this.state.getStackedResolvedTypes();
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        return true;
    }

    protected void computeArgumentTypes() {
        List<XExpression> arguments = this.getArguments();
        for (XExpression argument : arguments) {
            AbstractTypeComputationState argumentState = this.state.withNonVoidExpectation();
            argumentState.computeTypes(argument);
        }
    }

    protected abstract List<XExpression> getArguments();

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        return other;
    }

    @Override
    @Nullable
    public JvmIdentifiableElement getFeature() {
        return null;
    }

    public EObject getContext() {
        return this.expression;
    }

    protected OwnedConverter getConverter() {
        return this.state.getConverter();
    }
}

