/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.DefaultResourceUIServiceProvider;

public class XtendResourceUiServiceProvider
extends DefaultResourceUIServiceProvider {
    @Inject
    public XtendResourceUiServiceProvider(IResourceServiceProvider delegate) {
        super(delegate);
    }

    public boolean canHandle(URI uri) {
        return super.canHandle(uri);
    }

    public boolean canBuild(URI uri, IStorage storage) {
        if (storage instanceof IFile) {
            IFile file = (IFile)storage;
            IProject project = file.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return this.isInSourceFolder(javaProject, file);
        }
        return false;
    }

    public boolean isInSourceFolder(IJavaProject javaProject, IFile resource) {
        IClasspathEntry[] classpath;
        IPath path = resource.getFullPath();
        try {
            classpath = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException e) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            IPath entryPath;
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 3 && (entryPath = entry.getPath()).isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

