/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.IOutlineNodeComparer;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineTreeState;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineRefreshJob
extends Job {
    private OutlinePage outlinePage;
    @Inject
    private IOutlineNodeComparer nodeComparer;

    public OutlineRefreshJob() {
        super("Refreshing outline");
    }

    public void setOutlinePage(OutlinePage outlinePage) {
        this.outlinePage = outlinePage;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            OutlineTreeState formerState = new OutlineTreeState(this.outlinePage.getTreeViewer());
            OutlineTreeState newState = new OutlineTreeState();
            IOutlineNode rootNode = this.refreshOutlineModel(monitor, formerState, newState);
            if (!monitor.isCanceled()) {
                this.outlinePage.refreshViewer(rootNode, newState.getExpandedNodes(), newState.getSelectedNodes());
            }
            return Status.OK_STATUS;
        }
        catch (Throwable t) {
            return new Status(4, "org.eclipse.xtext.ui", "Error refreshing outline", t);
        }
    }

    protected IOutlineNode refreshOutlineModel(IProgressMonitor monitor, final OutlineTreeState formerState, final OutlineTreeState newState) {
        IOutlineNode rootNode = (IOutlineNode)this.outlinePage.getXtextDocument().readOnly((IUnitOfWork)new IUnitOfWork<IOutlineNode, XtextResource>(){

            public IOutlineNode exec(XtextResource resource) throws Exception {
                IOutlineNode rootNode = OutlineRefreshJob.this.outlinePage.getTreeProvider().createRoot(OutlineRefreshJob.this.outlinePage.getXtextDocument());
                OutlineRefreshJob.this.restoreChildrenSelectionAndExpansion(rootNode, (Resource)resource, formerState, newState);
                return rootNode;
            }
        });
        return rootNode;
    }

    protected void restoreChildrenSelectionAndExpansion(IOutlineNode parent, Resource resource, OutlineTreeState formerState, OutlineTreeState newState) {
        List<IOutlineNode> children = parent.getChildren();
        for (IOutlineNode child : children) {
            if (this.containsUsingComparer(formerState.getExpandedNodes(), child)) {
                this.restoreChildrenSelectionAndExpansion(child, resource, formerState, newState);
                newState.addExpandedNode(child);
            }
            if (!this.containsUsingComparer(formerState.getSelectedNodes(), child)) continue;
            newState.addSelectedNode(child);
        }
    }

    protected boolean containsUsingComparer(Iterable<IOutlineNode> list, final IOutlineNode node) {
        return Iterables.any(list, (Predicate)new Predicate<IOutlineNode>(){

            public boolean apply(IOutlineNode nodeFromList) {
                return OutlineRefreshJob.this.nodeComparer.equals(node, nodeFromList);
            }
        });
    }
}

