/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.typesystem.computation.ClosureTypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintAwareTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class XbaseTypeComputer
implements ITypeComputer {
    @Inject
    private NumberLiterals numberLiterals;
    @Inject
    private CommonTypeComputationServices services;

    @Override
    public void computeTypes(XExpression expression, ITypeComputationState state) {
        if (expression instanceof XAssignment) {
            this._computeTypes((XAssignment)expression, state);
        } else if (expression instanceof XAbstractFeatureCall) {
            this._computeTypes((XAbstractFeatureCall)expression, state);
        } else if (expression instanceof XDoWhileExpression) {
            this._computeTypes((XDoWhileExpression)expression, state);
        } else if (expression instanceof XAbstractWhileExpression) {
            this._computeTypes((XAbstractWhileExpression)expression, state);
        } else if (expression instanceof XBlockExpression) {
            this._computeTypes((XBlockExpression)expression, state);
        } else if (expression instanceof XBooleanLiteral) {
            this._computeTypes((XBooleanLiteral)expression, state);
        } else if (expression instanceof XCastedExpression) {
            this._computeTypes((XCastedExpression)expression, state);
        } else if (expression instanceof XClosure) {
            this._computeTypes((XClosure)expression, state);
        } else if (expression instanceof XConstructorCall) {
            this._computeTypes((XConstructorCall)expression, state);
        } else if (expression instanceof XForLoopExpression) {
            this._computeTypes((XForLoopExpression)expression, state);
        } else if (expression instanceof XIfExpression) {
            this._computeTypes((XIfExpression)expression, state);
        } else if (expression instanceof XInstanceOfExpression) {
            this._computeTypes((XInstanceOfExpression)expression, state);
        } else if (expression instanceof XNumberLiteral) {
            this._computeTypes((XNumberLiteral)expression, state);
        } else if (expression instanceof XNullLiteral) {
            this._computeTypes((XNullLiteral)expression, state);
        } else if (expression instanceof XReturnExpression) {
            this._computeTypes((XReturnExpression)expression, state);
        } else if (expression instanceof XStringLiteral) {
            this._computeTypes((XStringLiteral)expression, state);
        } else if (expression instanceof XSwitchExpression) {
            this._computeTypes((XSwitchExpression)expression, state);
        } else if (expression instanceof XThrowExpression) {
            this._computeTypes((XThrowExpression)expression, state);
        } else if (expression instanceof XTryCatchFinallyExpression) {
            this._computeTypes((XTryCatchFinallyExpression)expression, state);
        } else if (expression instanceof XTypeLiteral) {
            this._computeTypes((XTypeLiteral)expression, state);
        } else if (expression instanceof XVariableDeclaration) {
            this._computeTypes((XVariableDeclaration)expression, state);
        } else if (expression instanceof XListLiteral) {
            this._computeTypes((XListLiteral)expression, state);
        } else if (expression instanceof XSetLiteral) {
            this._computeTypes((XSetLiteral)expression, state);
        } else {
            throw new UnsupportedOperationException("Missing type computation for expression type: " + expression.eClass().getName() + " / " + state);
        }
    }

    protected LightweightTypeReference getTypeForName(Class<?> clazz, ITypeComputationState state) {
        ResourceSet resourceSet = state.getReferenceOwner().getContextResourceSet();
        JvmTypeReference typeReference = this.services.getTypeReferences().getTypeForName(clazz, (Notifier)resourceSet, new JvmTypeReference[0]);
        if (typeReference == null) {
            return new UnknownTypeReference(state.getReferenceOwner(), clazz.getName());
        }
        return state.getConverter().toLightweightReference(typeReference);
    }

    protected ParameterizedTypeReference getRawTypeForName(Class<?> clazz, ITypeReferenceOwner owner) {
        JvmType clazzType = this.services.getTypeReferences().findDeclaredType(clazz, (Notifier)owner.getContextResourceSet());
        ParameterizedTypeReference result = new ParameterizedTypeReference(owner, clazzType);
        return result;
    }

    protected LightweightTypeReference getPrimitiveVoid(ITypeComputationState state) {
        return this.getTypeForName(Void.TYPE, state);
    }

    protected void _computeTypes(XIfExpression object, ITypeComputationState state) {
        ITypeComputationState conditionExpectation = state.withExpectation(this.getTypeForName(Boolean.TYPE, state));
        conditionExpectation.computeTypes(object.getIf());
        XExpression thenExpression = this.getThen(object);
        ITypeComputationResult thenResult = state.computeTypes(thenExpression);
        XExpression elseExpression = this.getElse(object);
        if (elseExpression != null) {
            state.computeTypes(elseExpression);
        } else {
            LightweightTypeReference expressionReturnType = thenResult.getReturnType();
            if (expressionReturnType != null && expressionReturnType.isPrimitiveVoid()) {
                for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
                    if (iTypeExpectation.isVoidTypeAllowed()) continue;
                    AnyTypeReference anyType = new AnyTypeReference(state.getReferenceOwner());
                    iTypeExpectation.acceptActualType(anyType, ConformanceHint.UNCHECKED);
                }
                return;
            }
            AnyTypeReference anyTypeReference = new AnyTypeReference(state.getReferenceOwner());
            state.acceptActualType(anyTypeReference);
        }
    }

    @Nullable
    protected XExpression getElse(XIfExpression ifExpression) {
        return ifExpression.getElse();
    }

    @Nullable
    protected XExpression getThen(XIfExpression ifExpression) {
        return ifExpression.getThen();
    }

    protected void _computeTypes(XSwitchExpression object, ITypeComputationState state) {
        ITypeComputationState switchExpressionState = state.withNonVoidExpectation();
        ITypeComputationResult computedType = switchExpressionState.computeTypes(object.getSwitch());
        ITypeComputationState allCasePartsState = state;
        if (object.getLocalVarName() != null) {
            allCasePartsState = allCasePartsState.assignType(object, computedType.getActualExpressionType());
        }
        boolean casesAreVoid = true;
        for (XCasePart casePart : this.getCases(object)) {
            LightweightTypeReference expressionReturnType;
            ITypeComputationState casePartState = allCasePartsState.withTypeCheckpoint(casePart);
            if (casePart.getTypeGuard() != null) {
                JvmIdentifiableElement refinable = null;
                refinable = object.getLocalVarName() != null ? this.getRefinableCandidate(object, casePartState) : this.getRefinableCandidate(object.getSwitch(), casePartState);
                if (refinable != null) {
                    casePartState.reassignType(refinable, casePartState.getConverter().toLightweightReference(casePart.getTypeGuard()));
                }
            }
            if (casePart.getCase() != null) {
                ITypeComputationState caseState = casePartState.withNonVoidExpectation();
                caseState.computeTypes(casePart.getCase());
            }
            ITypeComputationResult thenResult = casePartState.computeTypes(casePart.getThen());
            if (!casesAreVoid || (expressionReturnType = thenResult.getReturnType()) != null && expressionReturnType.isPrimitiveVoid()) continue;
            casesAreVoid = false;
        }
        XExpression defaultCase = object.getDefault();
        if (defaultCase != null) {
            allCasePartsState.computeTypes(object.getDefault());
        } else {
            if (casesAreVoid) {
                for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
                    if (iTypeExpectation.isVoidTypeAllowed()) continue;
                    AnyTypeReference anyType = new AnyTypeReference(state.getReferenceOwner());
                    iTypeExpectation.acceptActualType(anyType, ConformanceHint.UNCHECKED);
                }
                return;
            }
            AnyTypeReference anyTypeReference = new AnyTypeReference(state.getReferenceOwner());
            state.acceptActualType(anyTypeReference);
        }
    }

    protected List<XCasePart> getCases(XSwitchExpression switchExpression) {
        return switchExpression.getCases();
    }

    protected void _computeTypes(XBlockExpression object, ITypeComputationState state) {
        for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
            ITypeComputationState expressionState;
            EList<XExpression> expressions;
            LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
            if (expectedType != null && expectedType.isPrimitiveVoid()) {
                expressions = object.getExpressions();
                if (!expressions.isEmpty()) {
                    for (XExpression expression : expressions) {
                        expressionState = state.withoutExpectation();
                        expressionState.computeTypes(expression);
                        if (!(expression instanceof XVariableDeclaration)) continue;
                        this.addLocalToCurrentScope((XVariableDeclaration)expression, state);
                    }
                }
                iTypeExpectation.acceptActualType(this.getPrimitiveVoid(state), ConformanceHint.CHECKED, ConformanceHint.SUCCESS);
                continue;
            }
            expressions = object.getExpressions();
            if (!expressions.isEmpty()) {
                for (XExpression expression : expressions.subList(0, expressions.size() - 1)) {
                    expressionState = state.withoutExpectation();
                    expressionState.computeTypes(expression);
                    if (!(expression instanceof XVariableDeclaration)) continue;
                    this.addLocalToCurrentScope((XVariableDeclaration)expression, state);
                }
                XExpression lastExpression = (XExpression)IterableExtensions.last(expressions);
                state.computeTypes(lastExpression);
                if (!(lastExpression instanceof XVariableDeclaration)) continue;
                this.addLocalToCurrentScope((XVariableDeclaration)lastExpression, state);
                continue;
            }
            iTypeExpectation.acceptActualType(new AnyTypeReference(iTypeExpectation.getReferenceOwner()), ConformanceHint.UNCHECKED);
        }
    }

    protected void addLocalToCurrentScope(XVariableDeclaration localVariable, ITypeComputationState state) {
        state.addLocalToCurrentScope(localVariable);
    }

    protected void _computeTypes(XVariableDeclaration object, ITypeComputationState state) {
        ITypeComputationState initializerState;
        LightweightTypeReference lightweightTypeReference;
        JvmTypeReference declaredType = object.getType();
        LightweightTypeReference lightweightTypeReference2 = lightweightTypeReference = declaredType != null ? state.getConverter().toLightweightReference(declaredType) : null;
        if (lightweightTypeReference != null && object.getRight() instanceof XClosure) {
            initializerState = state.assignType(object, lightweightTypeReference).withExpectation(lightweightTypeReference);
            initializerState.computeTypes(object.getRight());
        } else {
            LightweightTypeReference variableType;
            initializerState = lightweightTypeReference != null ? state.withExpectation(lightweightTypeReference) : state.withNonVoidExpectation();
            ITypeComputationResult computedType = initializerState.computeTypes(object.getRight());
            LightweightTypeReference lightweightTypeReference3 = variableType = lightweightTypeReference != null ? lightweightTypeReference : computedType.getActualExpressionType();
            if (variableType != null && variableType.isPrimitiveVoid()) {
                variableType = new UnknownTypeReference(variableType.getOwner());
            }
            state.assignType(object, variableType, false);
            state.addExtensionToCurrentScope(object);
        }
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected void _computeTypes(XConstructorCall constructorCall, ITypeComputationState state) {
        List<? extends IConstructorLinkingCandidate> candidates = state.getLinkingCandidates(constructorCall);
        ILinkingCandidate best = this.getBestCandidate(candidates);
        best.applyToComputationState();
    }

    protected void _computeTypes(XBooleanLiteral object, ITypeComputationState state) {
        LightweightTypeReference bool = this.getTypeForName(Boolean.TYPE, state);
        state.acceptActualType(bool);
    }

    protected void _computeTypes(XNullLiteral object, ITypeComputationState state) {
        state.acceptActualType(new AnyTypeReference(state.getReferenceOwner()));
    }

    protected void _computeTypes(XNumberLiteral object, ITypeComputationState state) {
        LightweightTypeReference result = this.getTypeForName(this.numberLiterals.getJavaType(object), state);
        state.acceptActualType(result);
    }

    protected void _computeTypes(XStringLiteral object, ITypeComputationState state) {
        if (object.getValue().length() != 1) {
            LightweightTypeReference lightweightTypeReference = this.getTypeForName(String.class, state);
            state.acceptActualType(lightweightTypeReference);
        } else {
            for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
                LightweightTypeReference type;
                LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
                if (expectedType != null) {
                    if (expectedType.isType(Character.TYPE) || expectedType.isType(Character.class)) {
                        iTypeExpectation.acceptActualType(expectedType, ConformanceHint.CHECKED, ConformanceHint.SUCCESS, ConformanceHint.DEMAND_CONVERSION);
                        continue;
                    }
                    type = this.getTypeForName(String.class, state);
                    iTypeExpectation.acceptActualType(type, ConformanceHint.UNCHECKED);
                    continue;
                }
                type = this.getTypeForName(String.class, state);
                iTypeExpectation.acceptActualType(type, ConformanceHint.UNCHECKED);
            }
        }
    }

    protected void _computeTypes(XListLiteral literal, ITypeComputationState state) {
        JvmGenericType listType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(List.class, (Notifier)literal);
        for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
            List<LightweightTypeReference> listTypeCandidates;
            LightweightTypeReference elementTypeExpectation = null;
            LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
            if (expectedType != null) {
                elementTypeExpectation = this.getElementOrComponentType(expectedType, state);
                if (expectedType.isArray()) {
                    elementTypeExpectation = expectedType.getComponentType();
                    for (XExpression element : literal.getElements()) {
                        state.withExpectation(elementTypeExpectation).computeTypes(element);
                    }
                    iTypeExpectation.acceptActualType(expectedType, ConformanceHint.UNCHECKED);
                    return;
                }
            }
            if (!(listTypeCandidates = this.computeCollectionTypeCandidates(literal, listType, elementTypeExpectation, state)).isEmpty()) {
                LightweightTypeReference commonListType = this.services.getTypeConformanceComputer().getCommonSuperType(listTypeCandidates, state.getReferenceOwner());
                iTypeExpectation.acceptActualType(commonListType, ConformanceHint.UNCHECKED);
                continue;
            }
            ParameterizedTypeReference unboundCollectionType = new ParameterizedTypeReference(state.getReferenceOwner(), (JvmType)listType);
            unboundCollectionType.addTypeArgument(iTypeExpectation.createUnboundTypeReference(literal, (JvmTypeParameter)listType.getTypeParameters().get(0)));
            iTypeExpectation.acceptActualType(unboundCollectionType, ConformanceHint.UNCHECKED);
        }
    }

    protected void _computeTypes(XSetLiteral literal, ITypeComputationState state) {
        JvmGenericType setType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(Set.class, (Notifier)literal);
        JvmGenericType mapType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(Map.class, (Notifier)literal);
        for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
            ParameterizedTypeReference unboundCollectionType;
            List<LightweightTypeReference> setTypeCandidates;
            LightweightTypeReference elementTypeExpectation = null;
            LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
            if (expectedType != null) {
                elementTypeExpectation = this.getElementOrComponentType(expectedType, state);
            }
            if (!(setTypeCandidates = this.computeCollectionTypeCandidates(literal, setType, elementTypeExpectation, state)).isEmpty()) {
                LightweightTypeReference commonSetType = this.services.getTypeConformanceComputer().getCommonSuperType(setTypeCandidates, state.getReferenceOwner());
                LightweightTypeReference commonElementType = commonSetType.getTypeArguments().get(0).getInvariantBoundSubstitute();
                JvmGenericType pairType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(Pair.class, (Notifier)literal);
                if (!(expectedType != null && expectedType.isType(Set.class) || commonElementType.getType() != pairType)) {
                    Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(commonElementType);
                    ParameterizedTypeReference boundMapType = new ParameterizedTypeReference(state.getReferenceOwner(), (JvmType)mapType);
                    boundMapType.addTypeArgument(typeParameterMapping.get(pairType.getTypeParameters().get(0)).getTypeReference().getInvariantBoundSubstitute());
                    boundMapType.addTypeArgument(typeParameterMapping.get(pairType.getTypeParameters().get(1)).getTypeReference().getInvariantBoundSubstitute());
                    iTypeExpectation.acceptActualType(boundMapType, ConformanceHint.UNCHECKED);
                    continue;
                }
                iTypeExpectation.acceptActualType(commonSetType, ConformanceHint.UNCHECKED);
                continue;
            }
            if (expectedType != null && expectedType.isType(Map.class)) {
                unboundCollectionType = new ParameterizedTypeReference(state.getReferenceOwner(), (JvmType)mapType);
                unboundCollectionType.addTypeArgument(iTypeExpectation.createUnboundTypeReference(literal, (JvmTypeParameter)mapType.getTypeParameters().get(0)));
                unboundCollectionType.addTypeArgument(iTypeExpectation.createUnboundTypeReference(literal, (JvmTypeParameter)mapType.getTypeParameters().get(1)));
                iTypeExpectation.acceptActualType(unboundCollectionType, ConformanceHint.UNCHECKED);
                continue;
            }
            unboundCollectionType = new ParameterizedTypeReference(state.getReferenceOwner(), (JvmType)setType);
            unboundCollectionType.addTypeArgument(iTypeExpectation.createUnboundTypeReference(literal, (JvmTypeParameter)setType.getTypeParameters().get(0)));
            iTypeExpectation.acceptActualType(unboundCollectionType, ConformanceHint.UNCHECKED);
        }
    }

    private List<LightweightTypeReference> computeCollectionTypeCandidates(XCollectionLiteral literal, JvmGenericType collectionType, LightweightTypeReference elementTypeExpectation, ITypeComputationState state) {
        ArrayList elementTypes = Lists.newArrayList();
        if (!literal.getElements().isEmpty()) {
            for (XExpression element : literal.getElements()) {
                ITypeComputationResult elementType = state.withExpectation(elementTypeExpectation).computeTypes(element);
                LightweightTypeReference actualType = elementType.getActualExpressionType();
                if (actualType == null || actualType.isAny()) continue;
                ParameterizedTypeReference collectionTypeCandidate = new ParameterizedTypeReference(state.getReferenceOwner(), (JvmType)collectionType);
                collectionTypeCandidate.addTypeArgument(actualType.getWrapperTypeIfPrimitive());
                elementTypes.add(collectionTypeCandidate);
            }
        }
        return elementTypes;
    }

    protected void _computeTypes(XClosure object, ITypeComputationState state) {
        for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
            new ClosureTypeComputer(object, iTypeExpectation, state).computeTypes();
        }
    }

    protected void _computeTypes(XCastedExpression object, ITypeComputationState state) {
        state.withNonVoidExpectation().computeTypes(object.getTarget());
        JvmTypeReference type = object.getType();
        if (type != null) {
            state.acceptActualType(state.getConverter().toLightweightReference(type));
        }
    }

    protected void _computeTypes(XForLoopExpression object, ITypeComputationState state) {
        JvmFormalParameter declaredParam = object.getDeclaredParam();
        ITypeComputationState eachState = state.withoutExpectation();
        if (declaredParam != null) {
            LightweightTypeReference parameterType = this.computeForLoopParameterType(object, state);
            eachState = this.assignType(declaredParam, parameterType, eachState);
        }
        eachState.computeTypes(object.getEachExpression());
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected ITypeComputationState assignType(JvmFormalParameter param, @Nullable LightweightTypeReference type, ITypeComputationState state) {
        return state.assignType((JvmIdentifiableElement)param, type);
    }

    @Nullable
    protected LightweightTypeReference computeForLoopParameterType(XForLoopExpression object, ITypeComputationState state) {
        JvmFormalParameter declaredParam = object.getDeclaredParam();
        LightweightTypeReference parameterType = this.getDeclaredParameterType(declaredParam, state);
        JvmGenericType iterableType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(Iterable.class, (Notifier)object);
        if (parameterType != null && !parameterType.isPrimitiveVoid()) {
            CompoundTypeReference withSynonyms = new CompoundTypeReference(state.getReferenceOwner(), true);
            LightweightTypeReference iterableOrArray = this.getAndEnhanceIterableOrArrayFromComponent(parameterType, iterableType, withSynonyms);
            ITypeComputationState iterableState = state.withExpectation(withSynonyms);
            ITypeComputationResult forExpressionResult = iterableState.computeTypes(object.getForExpression());
            LightweightTypeReference forExpressionType = forExpressionResult.getActualExpressionType();
            if (forExpressionType != null) {
                if (forExpressionType.isAny() || forExpressionType.isUnknown()) {
                    iterableState.refineExpectedType(object.getForExpression(), iterableOrArray);
                } else if (forExpressionType.isResolved()) {
                    TypeConformanceResult assignability = iterableOrArray.internalIsAssignableFrom(forExpressionType, new TypeConformanceComputationArgument());
                    if (assignability.isConformant() && !assignability.getConformanceHints().contains((Object)ConformanceHint.RAWTYPE_CONVERSION)) {
                        iterableState.refineExpectedType(object.getForExpression(), forExpressionType);
                    } else {
                        ArrayTypeReference array = forExpressionType.tryConvertToArray();
                        if (array != null) {
                            LightweightTypeReference arrayComponentType = array.getComponentType();
                            if (parameterType.isAssignableFrom(arrayComponentType)) {
                                iterableState.refineExpectedType(object.getForExpression(), forExpressionType);
                            } else {
                                LightweightTypeReference rawArrayComponentType = arrayComponentType.getRawTypeReference();
                                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert from element type %s to %s", rawArrayComponentType.getSimpleName(), parameterType.getSimpleName()), (EObject)object, (EStructuralFeature)XbasePackage.Literals.XFOR_LOOP_EXPRESSION__FOR_EXPRESSION, -1, null);
                                state.addDiagnostic((AbstractDiagnostic)diagnostic);
                            }
                        }
                    }
                }
            }
        } else {
            ITypeReferenceOwner owner = state.getReferenceOwner();
            LightweightTypeReference iterable = null;
            if (iterableType == null) {
                iterable = new UnknownTypeReference(owner, Iterable.class.getName());
            } else {
                WildcardTypeReference wildcard = new WildcardTypeReference(owner);
                ParameterizedTypeReference iterableTypeRef = new ParameterizedTypeReference(owner, (JvmType)iterableType);
                UnboundTypeReference unbound = state.createUnboundTypeReference(object, (JvmTypeParameter)iterableType.getTypeParameters().get(0));
                wildcard.addUpperBound(unbound);
                iterableTypeRef.addTypeArgument(wildcard);
                iterable = iterableTypeRef;
            }
            ITypeComputationState iterableState = state.withExpectation(iterable);
            ITypeComputationResult forExpressionResult = iterableState.computeTypes(object.getForExpression());
            LightweightTypeReference forExpressionType = forExpressionResult.getActualExpressionType();
            if (forExpressionType != null) {
                if (forExpressionType.isResolved() && !forExpressionType.isAny() && (iterable.isAssignableFrom(forExpressionType) || forExpressionType.isArray())) {
                    iterableState.refineExpectedType(object.getForExpression(), forExpressionType);
                }
                parameterType = this.getElementOrComponentType(forExpressionType, state);
            }
        }
        return parameterType;
    }

    protected LightweightTypeReference getAndEnhanceIterableOrArrayFromComponent(LightweightTypeReference parameterType, JvmGenericType iterableType, CompoundTypeReference compoundResult) {
        if (parameterType.isUnknown()) {
            return parameterType;
        }
        ITypeReferenceOwner owner = compoundResult.getOwner();
        LightweightTypeReference iterableOrArray = null;
        LightweightTypeReference addAsArrayComponentAndIterable = null;
        if (parameterType.isPrimitive()) {
            iterableOrArray = new ArrayTypeReference(owner, parameterType);
            compoundResult.addComponent(iterableOrArray);
            addAsArrayComponentAndIterable = parameterType.getWrapperTypeIfPrimitive();
        } else {
            addAsArrayComponentAndIterable = parameterType.isAny() ? this.getRawTypeForName(Object.class, parameterType.getOwner()) : parameterType;
        }
        ParameterizedTypeReference reference = new ParameterizedTypeReference(owner, (JvmType)iterableType);
        WildcardTypeReference wildcard = new WildcardTypeReference(owner);
        wildcard.addUpperBound(addAsArrayComponentAndIterable);
        reference.addTypeArgument(wildcard);
        compoundResult.addComponent(reference);
        if (iterableOrArray == null) {
            iterableOrArray = reference;
            LightweightTypeReference potentialPrimitive = addAsArrayComponentAndIterable.getPrimitiveIfWrapperType();
            if (potentialPrimitive != addAsArrayComponentAndIterable) {
                compoundResult.addComponent(new ArrayTypeReference(owner, potentialPrimitive));
            }
        }
        compoundResult.addComponent(new ArrayTypeReference(owner, addAsArrayComponentAndIterable));
        return iterableOrArray;
    }

    private LightweightTypeReference getElementOrComponentType(final LightweightTypeReference iterableOrArray, final ITypeComputationState state) {
        LightweightTypeReference parameterType = iterableOrArray.accept(new TypeReferenceVisitorWithResult<LightweightTypeReference>(){

            @Override
            public LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
                ConstraintAwareTypeArgumentCollector typeArgumentCollector = new ConstraintAwareTypeArgumentCollector(state.getReferenceOwner());
                Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping = typeArgumentCollector.getTypeParameterMapping(reference);
                UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(typeParameterMapping, state.getReferenceOwner());
                JvmGenericType iterable = (JvmGenericType)XbaseTypeComputer.this.services.getTypeReferences().findDeclaredType(Iterable.class, (Notifier)iterableOrArray.getOwner().getContextResourceSet());
                ParameterizedTypeReference substituteMe = new ParameterizedTypeReference(state.getReferenceOwner(), (JvmType)iterable.getTypeParameters().get(0));
                LightweightTypeReference substitutedArgument = substitutor.substitute(substituteMe).getUpperBoundSubstitute();
                if (substitutedArgument.getType() instanceof JvmTypeParameter && !state.getReferenceOwner().getDeclaredTypeParameters().contains(substitutedArgument.getType())) {
                    return substitutedArgument.getRawTypeReference();
                }
                return substitutedArgument;
            }

            @Override
            protected LightweightTypeReference doVisitAnyTypeReference(AnyTypeReference reference) {
                return reference;
            }

            @Override
            protected LightweightTypeReference doVisitUnknownTypeReference(UnknownTypeReference reference) {
                return reference;
            }

            @Override
            public LightweightTypeReference doVisitArrayTypeReference(ArrayTypeReference reference) {
                return reference.getComponentType();
            }

            @Override
            @Nullable
            protected LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference) {
                return null;
            }
        });
        return parameterType;
    }

    @Nullable
    protected LightweightTypeReference getDeclaredParameterType(JvmFormalParameter declaredParam, ITypeComputationState state) {
        JvmTypeReference parameterType = declaredParam.getParameterType();
        if (parameterType == null) {
            return null;
        }
        return state.getConverter().toLightweightReference(parameterType);
    }

    protected void _computeTypes(XAbstractWhileExpression object, ITypeComputationState state) {
        this.computeWhileLoopBody(object, state);
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected ITypeComputationResult computeWhileLoopBody(XAbstractWhileExpression object, ITypeComputationState state) {
        ITypeComputationState conditionExpectation = state.withExpectation(this.getTypeForName(Boolean.TYPE, state));
        conditionExpectation.computeTypes(object.getPredicate());
        return state.withoutExpectation().computeTypes(object.getBody());
    }

    protected void _computeTypes(XDoWhileExpression object, ITypeComputationState state) {
        ITypeComputationResult loopBodyResult = this.computeWhileLoopBody(object, state);
        boolean noImplicitReturn = loopBodyResult.getConformanceHints().contains((Object)ConformanceHint.NO_IMPLICIT_RETURN);
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        if (noImplicitReturn) {
            state.acceptActualType(primitiveVoid, ConformanceHint.NO_IMPLICIT_RETURN, ConformanceHint.UNCHECKED);
        } else {
            state.acceptActualType(primitiveVoid);
        }
    }

    protected void _computeTypes(XTypeLiteral object, ITypeComputationState state) {
        JvmType type = object.getType();
        if (type == null) {
            return;
        }
        ITypeReferenceOwner owner = state.getReferenceOwner();
        LightweightTypeReference clazz = new ParameterizedTypeReference(owner, object.getType());
        int i = 0;
        while (i < object.getArrayDimensions().size()) {
            clazz = new ArrayTypeReference(clazz.getOwner(), clazz);
            ++i;
        }
        if (object.getArrayDimensions().isEmpty()) {
            JvmType voidType;
            clazz = clazz.isPrimitiveVoid() ? ((voidType = this.services.getTypeReferences().findDeclaredType(Void.class, (Notifier)object)) == null ? new UnknownTypeReference(owner, Void.class.getName()) : new ParameterizedTypeReference(owner, voidType)) : clazz.getWrapperTypeIfPrimitive();
        }
        ParameterizedTypeReference result = this.getRawTypeForName(Class.class, owner);
        result.addTypeArgument(clazz);
        state.acceptActualType(result);
    }

    protected void _computeTypes(XInstanceOfExpression object, ITypeComputationState state) {
        ITypeComputationState expressionState = state.withExpectation(this.getRawTypeForName(Object.class, state.getReferenceOwner()));
        expressionState.computeTypes(object.getExpression());
        LightweightTypeReference bool = this.getTypeForName(Boolean.TYPE, state);
        state.acceptActualType(bool);
    }

    protected void _computeTypes(XThrowExpression object, ITypeComputationState state) {
        LightweightTypeReference throwable = this.getTypeForName(Throwable.class, state);
        ITypeComputationState expressionState = state.withExpectation(throwable);
        ITypeComputationResult types = expressionState.computeTypes(object.getExpression());
        LightweightTypeReference thrownException = types.getActualExpressionType();
        state.acceptActualType(this.getPrimitiveVoid(state), ConformanceHint.NO_IMPLICIT_RETURN);
        if (thrownException != null && !thrownException.isUnknown() && !state.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception") && thrownException.isSubtypeOf(Throwable.class) && !thrownException.isSubtypeOf(RuntimeException.class)) {
            boolean declarationFound = false;
            for (LightweightTypeReference declaredException : state.getExpectedExceptions()) {
                if (!declaredException.isAssignableFrom(thrownException)) continue;
                declarationFound = true;
                break;
            }
            if (!declarationFound) {
                state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(expressionState.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception"), "org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception", "Unhandled exception type " + thrownException.getSimpleName(), (EObject)object, (EStructuralFeature)XbasePackage.Literals.XTHROW_EXPRESSION__EXPRESSION, -1, new String[]{EcoreUtil.getURI((EObject)thrownException.getType()).toString(), EcoreUtil.getURI((EObject)object).toString()}));
            }
        }
    }

    protected void _computeTypes(XReturnExpression object, ITypeComputationState state) {
        XExpression returnValue = object.getExpression();
        ITypeComputationState expressionState = state.withReturnExpectation();
        if (returnValue != null) {
            expressionState.computeTypes(returnValue);
        } else {
            for (ITypeExpectation iTypeExpectation : expressionState.getExpectations()) {
                if (!iTypeExpectation.isNoTypeExpectation() && !iTypeExpectation.isVoidTypeAllowed()) continue;
                expressionState.acceptActualType(this.getPrimitiveVoid(state));
                break;
            }
        }
        state.acceptActualType(this.getPrimitiveVoid(state), ConformanceHint.NO_IMPLICIT_RETURN);
    }

    protected void _computeTypes(XTryCatchFinallyExpression object, ITypeComputationState state) {
        ArrayList caughtExceptions = Lists.newArrayList();
        OwnedConverter converter = state.getConverter();
        for (XCatchClause catchClause : object.getCatchClauses()) {
            if (catchClause.getDeclaredParam() == null || catchClause.getDeclaredParam().getParameterType() == null) continue;
            caughtExceptions.add(converter.toLightweightReference(catchClause.getDeclaredParam().getParameterType()));
        }
        state.withExpectedExceptions(caughtExceptions).computeTypes(object.getExpression());
        for (XCatchClause catchClause : object.getCatchClauses()) {
            JvmFormalParameter catchClauseParam = catchClause.getDeclaredParam();
            JvmTypeReference parameterType = catchClauseParam.getParameterType();
            LightweightTypeReference lightweightReference = parameterType != null ? state.getConverter().toLightweightReference(parameterType) : new AnyTypeReference(state.getReferenceOwner());
            ITypeComputationState catchClauseState = this.assignType(catchClauseParam, lightweightReference, state);
            catchClauseState.computeTypes(catchClause.getExpression());
        }
        state.withoutExpectation().computeTypes(object.getFinallyExpression());
    }

    protected void _computeTypes(XAssignment assignment, ITypeComputationState state) {
        List<? extends IFeatureLinkingCandidate> candidates = state.getLinkingCandidates(assignment);
        ILinkingCandidate best = this.getBestCandidate(candidates);
        JvmIdentifiableElement feature = best.getFeature();
        if (feature != null && this.mustDiscardRefinement(feature)) {
            state.discardReassignedTypes(feature);
        }
        best.applyToComputationState();
    }

    protected void _computeTypes(XAbstractFeatureCall featureCall, ITypeComputationState state) {
        List<? extends IFeatureLinkingCandidate> candidates = state.getLinkingCandidates(featureCall);
        ILinkingCandidate best = this.getBestCandidate(candidates);
        best.applyToComputationState();
    }

    protected ILinkingCandidate getBestCandidate(List<? extends ILinkingCandidate> candidates) {
        ILinkingCandidate result = candidates.get(0);
        int i = 1;
        while (i < candidates.size()) {
            ILinkingCandidate candidate = candidates.get(i);
            result = result.getPreferredCandidate(candidate);
            ++i;
        }
        return result;
    }

    @Nullable
    protected JvmIdentifiableElement getRefinableCandidate(XExpression object, ITypeComputationState state) {
        JvmIdentifiableElement linkedFeature;
        List<? extends IFeatureLinkingCandidate> candidates;
        if (object instanceof XSwitchExpression) {
            return (XSwitchExpression)object;
        }
        if (object instanceof XFeatureCall && (candidates = state.getLinkingCandidates((XFeatureCall)object)).size() == 1 && this.isRefinableFeature(linkedFeature = candidates.get(0).getFeature())) {
            return linkedFeature;
        }
        return null;
    }

    protected boolean isRefinableFeature(@Nullable JvmIdentifiableElement feature) {
        return feature instanceof XVariableDeclaration || feature instanceof XSwitchExpression || feature instanceof JvmFormalParameter || feature instanceof JvmField;
    }

    protected boolean mustDiscardRefinement(JvmIdentifiableElement feature) {
        if (feature instanceof XVariableDeclaration) {
            return ((XVariableDeclaration)feature).isWriteable();
        }
        if (feature instanceof JvmField) {
            return !((JvmField)feature).isFinal();
        }
        return false;
    }
}

