/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.xbase.typesystem.conformance.AbstractConformanceVisitor;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class TypeConformanceStrategy<T extends LightweightTypeReference>
extends AbstractConformanceVisitor<T> {
    protected final TypeConformanceComputer conformanceComputer;

    protected TypeConformanceStrategy(TypeConformanceComputer conformanceComputer) {
        this.conformanceComputer = conformanceComputer;
    }

    private T getLeft(TypeConformanceComputationArgument.Internal<T> param) {
        return param.reference;
    }

    @Override
    protected final TypeConformanceResult doVisitAnyTypeReference(AnyTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitAnyTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitAnyTypeReference(T left, AnyTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitTypeReference(left, right, param);
    }

    @Override
    protected final TypeConformanceResult doVisitUnknownTypeReference(UnknownTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitUnknownTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitUnknownTypeReference(T left, UnknownTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
    }

    @Override
    protected final TypeConformanceResult doVisitCompoundTypeReference(CompoundTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitCompoundTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitCompoundTypeReference(T left, CompoundTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitTypeReference(left, right, param);
    }

    @Override
    protected final TypeConformanceResult doVisitArrayTypeReference(ArrayTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitArrayTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitArrayTypeReference(T left, ArrayTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitTypeReference(left, right, param);
    }

    @Override
    protected final TypeConformanceResult doVisitParameterizedTypeReference(ParameterizedTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitParameterizedTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitParameterizedTypeReference(T left, ParameterizedTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitTypeReference(left, right, param);
    }

    @Override
    protected final TypeConformanceResult doVisitFunctionTypeReference(FunctionTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitFunctionTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitFunctionTypeReference(T left, FunctionTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitParameterizedTypeReference(left, right, param);
    }

    @Override
    protected final TypeConformanceResult doVisitTypeReference(LightweightTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitTypeReference(T left, LightweightTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        throw new IllegalStateException("doVisitTypeReference was invoked but not implemented for: " + left + " <= " + right);
    }

    @Override
    protected final TypeConformanceResult doVisitUnboundTypeReference(UnboundTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitUnboundTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitUnboundTypeReference(T left, UnboundTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitTypeReference(left, right, param);
    }

    @Override
    protected final TypeConformanceResult doVisitWildcardTypeReference(WildcardTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitWildcardTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitWildcardTypeReference(T left, WildcardTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitTypeReference(left, right, param);
    }

    @Override
    protected final TypeConformanceResult doVisitMultiTypeReference(CompoundTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitMultiTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitMultiTypeReference(T left, CompoundTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        for (LightweightTypeReference reference : right.getMultiTypeComponents()) {
            TypeConformanceResult result = (TypeConformanceResult)reference.accept(this, param);
            if (!result.isConformant()) continue;
            return result;
        }
        if (right.getMultiTypeComponents().isEmpty()) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected final TypeConformanceResult doVisitSynonymTypeReference(CompoundTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        return this.doVisitSynonymTypeReference(this.getLeft(param), right, param);
    }

    protected TypeConformanceResult doVisitSynonymTypeReference(T left, CompoundTypeReference right, TypeConformanceComputationArgument.Internal<T> param) {
        List<LightweightTypeReference> rightComponents = right.getMultiTypeComponents();
        if (rightComponents.isEmpty()) {
            return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
        }
        int i = 0;
        while (i < rightComponents.size()) {
            TypeConformanceResult candidate = (TypeConformanceResult)rightComponents.get(i).accept(this, param);
            if (candidate.isConformant()) {
                if (i == 0) {
                    return candidate;
                }
                TypeConformanceResult result = TypeConformanceResult.merge(candidate, TypeConformanceResult.create(param, ConformanceHint.SYNONYM));
                result.setConversion(rightComponents.get(0), rightComponents.get(i));
                return result;
            }
            ++i;
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }
}

