/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.scoping.batch.SimpleIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ExpectedExceptionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.FollowUpError;
import org.eclipse.xtext.xbase.typesystem.internal.ForwardingResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.NoTypeResult;
import org.eclipse.xtext.xbase.typesystem.internal.NullConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.NullFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ResolutionBasedComputationResult;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedFeature;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ReturnExpectationTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ScopeProviderAccess;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeAssigner;
import org.eclipse.xtext.xbase.typesystem.internal.TypeCheckpointComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithNonVoidExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithRootExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeInsteadOfConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.UnresolvableConstructorCall;
import org.eclipse.xtext.xbase.typesystem.internal.UnresolvableFeatureCall;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class AbstractTypeComputationState
implements ITypeComputationState {
    protected final ResolvedTypes resolvedTypes;
    private IFeatureScopeSession featureScopeSession;
    private final DefaultReentrantTypeResolver reentrantTypeResolver;
    private List<AbstractTypeExpectation> expectations;
    private List<AbstractTypeExpectation> returnExpectations;

    protected AbstractTypeComputationState(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession) {
        this.resolvedTypes = resolvedTypes;
        this.featureScopeSession = featureScopeSession;
        this.reentrantTypeResolver = resolvedTypes.getResolver();
    }

    protected ResolvedTypes getResolvedTypes() {
        return this.resolvedTypes;
    }

    protected IFeatureScopeSession getFeatureScopeSession() {
        return this.featureScopeSession;
    }

    protected TypeReferences getTypeReferences() {
        return this.reentrantTypeResolver.getServices().getTypeReferences();
    }

    protected ITypeComputer getTypeComputer() {
        return this.reentrantTypeResolver.getTypeComputer();
    }

    protected DefaultReentrantTypeResolver getResolver() {
        return this.reentrantTypeResolver;
    }

    protected abstract LightweightTypeReference acceptType(ResolvedTypes var1, AbstractTypeExpectation var2, LightweightTypeReference var3, boolean var4, ConformanceHint ... var5);

    protected abstract LightweightTypeReference acceptType(XExpression var1, ResolvedTypes var2, AbstractTypeExpectation var3, LightweightTypeReference var4, boolean var5, ConformanceHint ... var6);

    @Override
    public final ITypeComputationResult computeTypes(@Nullable XExpression expression) {
        if (expression != null) {
            if (expression.eContainer() == null && expression.eResource() == null) {
                throw new IllegalStateException("Dangling expression: " + expression);
            }
            ExpressionAwareStackedResolvedTypes stackedResolvedTypes = this.doComputeTypes(expression);
            stackedResolvedTypes.performMergeIntoParent();
            return new ResolutionBasedComputationResult(expression, this.resolvedTypes);
        }
        return new NoTypeResult(null, this.getReferenceOwner());
    }

    protected ExpressionAwareStackedResolvedTypes doComputeTypes(XExpression expression) {
        ExpressionAwareStackedResolvedTypes stackedResolvedTypes = this.pushTypes(expression);
        ExpressionTypeComputationState state = this.createExpressionComputationState(expression, stackedResolvedTypes);
        this.getResolver().getTypeComputer().computeTypes(expression, state);
        stackedResolvedTypes.prepareMergeIntoParent();
        if (stackedResolvedTypes.doGetTypeData(expression) == null) {
            state.acceptActualType(new AnyTypeReference(stackedResolvedTypes.getReferenceOwner()));
        }
        return stackedResolvedTypes;
    }

    protected ExpressionAwareStackedResolvedTypes pushTypes(XExpression expression) {
        return this.getResolvedTypes().pushTypes(expression);
    }

    protected ExpressionTypeComputationState createExpressionComputationState(XExpression expression, StackedResolvedTypes typeResolution) {
        return new ExpressionTypeComputationState(typeResolution, this.featureScopeSession, this, expression);
    }

    @Override
    public TypeComputationStateWithExpectation withExpectation(@Nullable LightweightTypeReference expectation) {
        return new TypeComputationStateWithExpectation(this.resolvedTypes, this.featureScopeSession, this, expectation);
    }

    @Override
    public void refineExpectedType(XExpression expression, LightweightTypeReference expectation) {
        TypeExpectation typeExpectation = new TypeExpectation(expectation, this, false);
        this.getResolvedTypes().refineExpectedType(expression, typeExpectation);
    }

    @Override
    public TypeComputationStateWithRootExpectation withRootExpectation(@Nullable LightweightTypeReference expectation) {
        return new TypeComputationStateWithRootExpectation(this.resolvedTypes, this.featureScopeSession, this, expectation);
    }

    @Override
    public TypeComputationStateWithRootExpectation withoutRootExpectation() {
        return new TypeComputationStateWithRootExpectation(this.resolvedTypes, this.featureScopeSession, this, null);
    }

    @Override
    public AbstractTypeComputationState withNonVoidExpectation() {
        return this.withNonVoidExpectation(this.resolvedTypes);
    }

    protected AbstractTypeComputationState withNonVoidExpectation(ResolvedTypes resolvedTypes) {
        return new TypeComputationStateWithNonVoidExpectation(resolvedTypes, this.featureScopeSession, this);
    }

    @Override
    public AbstractTypeComputationState withReturnExpectation() {
        return new ReturnExpectationTypeComputationState(this.resolvedTypes, this.featureScopeSession, this);
    }

    @Override
    public AbstractTypeComputationState withoutExpectation() {
        return new TypeComputationStateWithExpectation(this.resolvedTypes, this.featureScopeSession, this, null);
    }

    @Override
    public TypeCheckpointComputationState withTypeCheckpoint(@Nullable EObject context) {
        return new TypeCheckpointComputationState(this.resolvedTypes, this.featureScopeSession, this);
    }

    @Override
    public AbstractTypeComputationState withExpectedExceptions(List<LightweightTypeReference> declaredExceptionTypes) {
        return new ExpectedExceptionTypeComputationState(this.resolvedTypes, this.featureScopeSession, this, declaredExceptionTypes);
    }

    @Override
    public AbstractTypeComputationState assignType(JvmIdentifiableElement element, @Nullable LightweightTypeReference type) {
        return this.assignType(element, type, true);
    }

    @Override
    public AbstractTypeComputationState assignType(JvmIdentifiableElement element, @Nullable LightweightTypeReference type, boolean addToChildScope) {
        TypeAssigner assigner = this.assignTypes();
        assigner.assignType(element, type, addToChildScope);
        return assigner.getForkedState();
    }

    @Override
    public void addLocalToCurrentScope(JvmIdentifiableElement element) {
        String simpleName = element.getSimpleName();
        if (Strings.isNullOrEmpty((String)simpleName)) {
            return;
        }
        QualifiedName elementName = QualifiedName.create((String)simpleName);
        this.addLocalToCurrentScope(elementName, element, !this.getResolver().isShadowingAllowed(elementName));
    }

    @Override
    public void addExtensionToCurrentScope(JvmIdentifiableElement extensionProvider) {
        LightweightTypeReference knownType = this.getResolvedTypes().getActualType(extensionProvider);
        if (knownType != null && !knownType.isAny() && !knownType.isUnknown()) {
            XFeatureCall prototype = this.getResolver().getXbaseFactory().createXFeatureCall();
            prototype.setFeature(extensionProvider);
            this.featureScopeSession = this.featureScopeSession.addToExtensionScope(Collections.singletonMap(prototype, knownType));
        }
    }

    @Override
    public void addExtensionsToCurrentScope(List<? extends JvmIdentifiableElement> extensionProviders) {
        if (extensionProviders.isEmpty()) {
            return;
        }
        if (extensionProviders.size() == 1) {
            this.addExtensionToCurrentScope(extensionProviders.get(0));
            return;
        }
        LinkedHashMap<XExpression, LightweightTypeReference> prototypeToType = Maps2.newLinkedHashMapWithExpectedSize(extensionProviders.size());
        for (JvmIdentifiableElement jvmIdentifiableElement : extensionProviders) {
            LightweightTypeReference knownType = this.getResolvedTypes().getActualType(jvmIdentifiableElement);
            if (knownType == null || knownType.isAny() || knownType.isUnknown()) continue;
            XFeatureCall prototype = this.getResolver().getXbaseFactory().createXFeatureCall();
            prototype.setFeature(jvmIdentifiableElement);
            prototypeToType.put(prototype, knownType);
        }
        if (!prototypeToType.isEmpty()) {
            this.featureScopeSession = this.featureScopeSession.addToExtensionScope(prototypeToType);
        }
    }

    protected void addLocalToCurrentScope(QualifiedName elementName, JvmIdentifiableElement element, boolean raiseIssueIfShadowing) {
        IEObjectDescription existingElement;
        if (this.getResolver().isDisallowedName(elementName)) {
            this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", "'" + elementName + "' is not a valid name", this.getResolver().getSourceElement((EObject)element), element.eClass().getEStructuralFeature("name"), -1, null));
            return;
        }
        if (raiseIssueIfShadowing && (existingElement = this.featureScopeSession.getLocalElement(elementName)) != null) {
            this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_shadowing", "Duplicate local variable " + elementName, this.getResolver().getSourceElement((EObject)element), element.eClass().getEStructuralFeature("name"), -1, null));
        }
        this.featureScopeSession = this.featureScopeSession.addLocalElement(elementName, element, this.getReferenceOwner());
    }

    @Override
    public void assignType(QualifiedName name, JvmType rawType, LightweightTypeReference actualType) {
        this.resolvedTypes.reassignTypeWithoutMerge((JvmIdentifiableElement)rawType, actualType);
        this.featureScopeSession = this.featureScopeSession.addLocalElement(name, (JvmIdentifiableElement)rawType, this.getReferenceOwner());
    }

    @Override
    public TypeAssigner assignTypes() {
        TypeCheckpointComputationState state = this.withTypeCheckpoint(null);
        return this.createTypeAssigner(state);
    }

    @Override
    public void addDiagnostic(AbstractDiagnostic diagnostic) {
        this.resolvedTypes.addDiagnostic(diagnostic);
    }

    protected TypeAssigner createTypeAssigner(AbstractTypeComputationState state) {
        return new TypeAssigner(state);
    }

    @Override
    public final List<? extends ITypeExpectation> getExpectations() {
        if (this.expectations == null) {
            this.expectations = this.getExpectations(this);
        }
        return this.expectations;
    }

    protected final List<? extends ITypeExpectation> getReturnExpectations() {
        if (this.returnExpectations == null) {
            this.returnExpectations = this.getReturnExpectations(this, false);
        }
        return this.returnExpectations;
    }

    protected abstract List<AbstractTypeExpectation> getExpectations(AbstractTypeComputationState var1);

    protected abstract List<AbstractTypeExpectation> getReturnExpectations(AbstractTypeComputationState var1, boolean var2);

    @Override
    public void acceptActualType(LightweightTypeReference type) {
        for (ITypeExpectation iTypeExpectation : this.getExpectations()) {
            iTypeExpectation.acceptActualType(type, ConformanceHint.UNCHECKED, ConformanceHint.EXPECTATION_INDEPENDENT);
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, ConformanceHint ... hints) {
        EnumSet<ConformanceHint> actualHints = EnumSet.copyOf(Arrays.asList(hints));
        actualHints.add(ConformanceHint.UNCHECKED);
        actualHints.add(ConformanceHint.EXPECTATION_INDEPENDENT);
        ConformanceHint[] actualHintsAsArray = actualHints.toArray(new ConformanceHint[actualHints.size()]);
        for (ITypeExpectation iTypeExpectation : this.getExpectations()) {
            iTypeExpectation.acceptActualType(type, actualHintsAsArray);
        }
    }

    @Override
    public void reassignType(JvmIdentifiableElement refinable, LightweightTypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("Reassigned type may not be null");
        }
        this.resolvedTypes.reassignType(refinable, type);
    }

    @Override
    public void discardReassignedTypes(JvmIdentifiableElement refinable) {
        this.resolvedTypes.reassignType(refinable, null);
    }

    public List<IFeatureLinkingCandidate> getLinkingCandidates(XAbstractFeatureCall featureCall) {
        IFeatureLinkingCandidate result = this.reentrantTypeResolver.getScopeProviderAccess().getKnownFeature(featureCall, this, this.resolvedTypes);
        if (result != null) {
            return Collections.singletonList(result);
        }
        EObject proxyOrResolved = (EObject)featureCall.eGet((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, false);
        StackedResolvedTypes demandComputedTypes = this.resolvedTypes.pushTypes();
        final AbstractTypeComputationState forked = this.withNonVoidExpectation(demandComputedTypes);
        ForwardingResolvedTypes demandResolvedTypes = new ForwardingResolvedTypes(){

            protected IResolvedTypes delegate() {
                return forked.getResolvedTypes();
            }

            @Nullable
            public LightweightTypeReference getActualType(XExpression expression) {
                LightweightTypeReference type = super.getActualType(expression);
                if (type == null) {
                    ITypeComputationResult result = forked.computeTypes(expression);
                    return result.getActualExpressionType();
                }
                return type;
            }
        };
        Iterable<IEObjectDescription> descriptions = this.reentrantTypeResolver.getScopeProviderAccess().getCandidateDescriptions(featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, proxyOrResolved, this.featureScopeSession, demandResolvedTypes);
        ArrayList resultList = Lists.newArrayList();
        for (IEObjectDescription description : descriptions) {
            resultList.add(this.createCandidate(featureCall, demandComputedTypes, this.toIdentifiableDescription(description)));
        }
        if (resultList.isEmpty()) {
            resultList.add(new NullFeatureLinkingCandidate(featureCall, this));
        }
        return resultList;
    }

    protected IFeatureLinkingCandidate createResolvedLink(XAbstractFeatureCall featureCall, JvmIdentifiableElement resolvedTo) {
        XExpression implicitFirstArgument;
        XExpression implicitReceiver;
        FeatureLinkHelper helper = new FeatureLinkHelper();
        XExpression syntacticReceiver = helper.getSyntacticReceiver(featureCall);
        if (syntacticReceiver != null) {
            AbstractTypeComputationState child = this.withNonVoidExpectation();
            child.computeTypes(syntacticReceiver);
        }
        if ((implicitReceiver = featureCall.getImplicitReceiver()) != null) {
            AbstractTypeComputationState child = this.withNonVoidExpectation();
            child.computeTypes(implicitReceiver);
        }
        if ((implicitFirstArgument = featureCall.getImplicitFirstArgument()) != null) {
            AbstractTypeComputationState child = this.withNonVoidExpectation();
            child.computeTypes(implicitFirstArgument);
        }
        ExpressionAwareStackedResolvedTypes resolvedTypes = this.resolvedTypes.pushTypes(featureCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(featureCall, resolvedTypes);
        return new ResolvedFeature(featureCall, resolvedTo, helper, state);
    }

    protected IFeatureLinkingCandidate createCandidate(XAbstractFeatureCall featureCall, final StackedResolvedTypes demandComputedTypes, IIdentifiableElementDescription description) {
        if (description.getSyntacticReceiverType() != null) {
            ExpressionAwareStackedResolvedTypes resolvedTypes = demandComputedTypes.pushTypes(featureCall);
            ExpressionTypeComputationState state = this.createExpressionComputationState(featureCall, resolvedTypes);
            return new FeatureLinkingCandidate(featureCall, description, state){

                public void applyToComputationState() {
                    super.applyToComputationState();
                    XExpression receiver = this.getReceiver();
                    if (receiver != null) {
                        LightweightTypeReference receiverType = this.getReceiverType();
                        if (receiverType == null) {
                            throw new IllegalStateException("Cannot determine receiver's type");
                        }
                        LightweightTypeReference expectedReceiverType = new FeatureLinkHelper().getExpectedReceiverType(this.getFeature(), receiverType);
                        TypeExpectation refinedExpectation = new TypeExpectation(expectedReceiverType, this.getState(), false);
                        demandComputedTypes.refineExpectedType(receiver, refinedExpectation);
                    }
                    demandComputedTypes.mergeIntoParent();
                }
            };
        }
        ExpressionAwareStackedResolvedTypes resolvedTypes = this.resolvedTypes.pushTypes(featureCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(featureCall, resolvedTypes);
        if (description instanceof ScopeProviderAccess.ErrorDescription) {
            boolean followUpError = ((ScopeProviderAccess.ErrorDescription)description).isFollowUpError();
            if (followUpError) {
                return new FollowUpError(featureCall, state);
            }
            return new UnresolvableFeatureCall(featureCall, ((ScopeProviderAccess.ErrorDescription)description).getNode(), description.getName().toString(), state);
        }
        return new FeatureLinkingCandidate(featureCall, description, state);
    }

    public List<IConstructorLinkingCandidate> getLinkingCandidates(XConstructorCall constructorCall) {
        IConstructorLinkingCandidate result = this.reentrantTypeResolver.getScopeProviderAccess().getKnownConstructor(constructorCall, this, this.resolvedTypes);
        if (result != null) {
            return Collections.singletonList(result);
        }
        EObject proxyOrResolved = (EObject)constructorCall.eGet((EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, false);
        Iterable<IEObjectDescription> descriptions = this.reentrantTypeResolver.getScopeProviderAccess().getCandidateDescriptions(constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, proxyOrResolved, this.featureScopeSession, this.resolvedTypes);
        ArrayList resultList = Lists.newArrayList();
        for (IEObjectDescription description : descriptions) {
            resultList.add(this.createCandidate(constructorCall, this.toIdentifiableDescription(description)));
        }
        if (resultList.isEmpty()) {
            resultList.add(new NullConstructorLinkingCandidate(constructorCall, this));
        }
        return resultList;
    }

    protected IIdentifiableElementDescription toIdentifiableDescription(IEObjectDescription description) {
        if (description instanceof IIdentifiableElementDescription) {
            return (IIdentifiableElementDescription)description;
        }
        if (!(description.getEObjectOrProxy() instanceof JvmIdentifiableElement)) {
            throw new IllegalStateException("Given description does not describe an identifable element");
        }
        return new SimpleIdentifiableElementDescription(description);
    }

    protected IConstructorLinkingCandidate createResolvedLink(XConstructorCall constructorCall, JvmConstructor resolvedTo) {
        ExpressionAwareStackedResolvedTypes stackedResolvedTypes = this.resolvedTypes.pushTypes(constructorCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(constructorCall, stackedResolvedTypes);
        return new ResolvedConstructor(constructorCall, resolvedTo, state);
    }

    protected IConstructorLinkingCandidate createCandidate(XConstructorCall constructorCall, IIdentifiableElementDescription description) {
        ExpressionAwareStackedResolvedTypes stackedResolvedTypes = this.resolvedTypes.pushTypes(constructorCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(constructorCall, stackedResolvedTypes);
        if (description instanceof ScopeProviderAccess.ErrorDescription) {
            return new UnresolvableConstructorCall(constructorCall, ((ScopeProviderAccess.ErrorDescription)description).getNode(), description.getName().toString(), state);
        }
        if (description.getElementOrProxy() instanceof JvmType) {
            return new TypeInsteadOfConstructorLinkingCandidate(constructorCall, description, state);
        }
        return new ConstructorLinkingCandidate(constructorCall, description, state);
    }

    public String toString() {
        return String.format("%s: %s", this.getClass().getSimpleName(), this.resolvedTypes);
    }

    @Override
    public ITypeReferenceOwner getReferenceOwner() {
        return this.resolvedTypes.getReferenceOwner();
    }

    @Override
    public UnboundTypeReference createUnboundTypeReference(XExpression expression, JvmTypeParameter typeParameter) {
        return this.getResolvedTypes().createUnboundTypeReference(expression, typeParameter);
    }

    @Override
    public OwnedConverter getConverter() {
        return new OwnedConverter(this.getReferenceOwner());
    }

    @Override
    public List<LightweightTypeReference> getExpectedExceptions() {
        return this.resolvedTypes.getExpectedExceptions();
    }

    protected IssueSeverities getSeverities() {
        return this.resolvedTypes.getSeverities();
    }

    @Override
    public Severity getSeverity(String issueCode) {
        return this.getSeverities().getSeverity(issueCode);
    }

    @Override
    public boolean isIgnored(String issueCode) {
        return this.getSeverities().isIgnored(issueCode);
    }
}

