/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeKind;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReferenceResolver;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;
import org.eclipse.xtext.xtype.XComputedTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class UnboundTypeReference
extends LightweightTypeReference {
    private LightweightTypeReference resolvedTo;
    private final JvmTypeParameter typeParameter;
    private final Object handle;
    private final XExpression expression;
    boolean copying = false;

    public static UnboundTypeReference create(ITypeExpectation expectation, XExpression expression, JvmTypeParameter typeParameter) {
        return expectation.createUnboundTypeReference(expression, typeParameter);
    }

    protected UnboundTypeReference(ITypeReferenceOwner owner, XExpression expression, JvmTypeParameter typeParameter) {
        this(owner, expression, typeParameter, new Object());
    }

    protected UnboundTypeReference(ITypeReferenceOwner owner, XExpression expression, JvmTypeParameter typeParameter, Object handle) {
        super(owner);
        this.typeParameter = typeParameter;
        this.handle = handle;
        this.expression = expression;
    }

    public XExpression getExpression() {
        return this.expression;
    }

    protected UnboundTypeReference createCopy(ITypeReferenceOwner owner) {
        UnboundTypeReference result = new UnboundTypeReference(owner, this.expression, this.getTypeParameter(), this.getHandle());
        return result;
    }

    public void tryResolve() {
        if (this.internalIsResolved()) {
            return;
        }
        List<LightweightBoundTypeArgument> hints = this.getAllHints();
        if (!hints.isEmpty() && this.hasSignificantHints(hints)) {
            this.resolveWithHints(hints);
        }
    }

    public boolean canResolveTo(LightweightTypeReference reference) {
        if (this.internalIsResolved()) {
            return reference.isAssignableFrom(this.resolvedTo, new TypeConformanceComputationArgument(false, true, true, true, false, false));
        }
        List<LightweightBoundTypeArgument> hints = this.getAllHints();
        if (!hints.isEmpty() && this.hasSignificantHints(hints)) {
            return this.canResolveTo(reference, hints);
        }
        return false;
    }

    public boolean hasSignificantHints() {
        if (this.internalIsResolved()) {
            return true;
        }
        List<LightweightBoundTypeArgument> hints = this.getAllHints();
        return !hints.isEmpty() && this.hasSignificantHints(hints);
    }

    protected boolean hasSignificantHints(List<LightweightBoundTypeArgument> hints) {
        for (LightweightBoundTypeArgument hint : hints) {
            if (hint.getOrigin() instanceof VarianceInfo) continue;
            return true;
        }
        return false;
    }

    @Override
    public JvmTypeReference toTypeReference() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.toTypeReference();
        }
        XComputedTypeReference result = this.getServices().getXtypeFactory().createXComputedTypeReference();
        result.setTypeProvider(new UnboundTypeReferenceResolver(this));
        return result;
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference() {
        return this.resolve().toJavaCompliantTypeReference();
    }

    @Override
    protected boolean isRawType(Set<JvmType> seenTypes) {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.isRawType(seenTypes);
        }
        return false;
    }

    public JvmTypeParameter getTypeParameter() {
        return this.typeParameter;
    }

    public Object getHandle() {
        return this.handle;
    }

    @Nullable
    public LightweightTypeReference getResolvedTo() {
        return this.internalGetResolvedTo();
    }

    @Override
    public LightweightTypeReference getUpperBoundSubstitute() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.getUpperBoundSubstitute();
        }
        return super.getUpperBoundSubstitute();
    }

    @Override
    public LightweightTypeReference getLowerBoundSubstitute() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.getLowerBoundSubstitute();
        }
        return super.getLowerBoundSubstitute();
    }

    @Override
    public LightweightTypeReference getInvariantBoundSubstitute() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.getInvariantBoundSubstitute();
        }
        return super.getInvariantBoundSubstitute();
    }

    public LightweightTypeReference resolve() {
        LightweightTypeReference result;
        if (this.internalIsResolved()) {
            return this.resolvedTo;
        }
        List<LightweightBoundTypeArgument> allHints = this.getAllHints();
        if (!allHints.isEmpty() && this.resolveWithHints(allHints) && (result = this.internalGetResolvedTo()) != null) {
            return result;
        }
        this.resolveAgainstConstraints();
        return this.resolvedTo;
    }

    protected void resolveAgainstConstraints() {
        TypeParameterByConstraintSubstitutor unboundSubstitutor = new TypeParameterByConstraintSubstitutor(Collections.<JvmTypeParameter, LightweightMergedBoundTypeArgument>emptyMap(), this.getOwner(), true);
        LightweightTypeReference substitute = unboundSubstitutor.substitute(new ParameterizedTypeReference(this.getOwner(), (JvmType)this.typeParameter));
        this.getOwner().acceptHint(this.getHandle(), new LightweightBoundTypeArgument(substitute, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT));
        this.resolvedTo = substitute;
    }

    public boolean isConformantToConstraints(LightweightTypeReference typeReference) {
        TypeParameterByConstraintSubstitutor unboundSubstitutor = new TypeParameterByConstraintSubstitutor(Collections.<JvmTypeParameter, LightweightMergedBoundTypeArgument>emptyMap(), this.getOwner(), true);
        LightweightTypeReference substitute = unboundSubstitutor.substitute(new ParameterizedTypeReference(this.getOwner(), (JvmType)this.typeParameter));
        return substitute.isAssignableFrom(typeReference);
    }

    protected boolean canResolveTo(LightweightTypeReference reference, List<LightweightBoundTypeArgument> allHints) {
        ArrayList inferredHints = Lists.newArrayListWithCapacity((int)allHints.size());
        ArrayList effectiveHints = Lists.newArrayListWithCapacity((int)allHints.size());
        EnumSet<VarianceInfo> varianceHints = EnumSet.noneOf(VarianceInfo.class);
        for (LightweightBoundTypeArgument hint : allHints) {
            if (hint.getOrigin() instanceof VarianceInfo) {
                varianceHints.add((VarianceInfo)((Object)hint.getOrigin()));
                continue;
            }
            effectiveHints.add(hint);
            if (hint.getSource() != BoundTypeArgumentSource.INFERRED) continue;
            inferredHints.add(hint);
        }
        if (effectiveHints.isEmpty()) {
            return false;
        }
        boolean result = this.getServices().getBoundTypeArgumentMerger().isPossibleMergeResult(!inferredHints.isEmpty() ? inferredHints : effectiveHints, reference);
        return result;
    }

    protected boolean resolveWithHints(List<LightweightBoundTypeArgument> allHints) {
        ArrayList inferredHints = Lists.newArrayListWithCapacity((int)allHints.size());
        ArrayList effectiveHints = Lists.newArrayListWithCapacity((int)allHints.size());
        EnumSet<VarianceInfo> varianceHints = EnumSet.noneOf(VarianceInfo.class);
        for (LightweightBoundTypeArgument hint : allHints) {
            if (hint.getOrigin() instanceof VarianceInfo) {
                varianceHints.add((VarianceInfo)((Object)hint.getOrigin()));
                continue;
            }
            effectiveHints.add(hint);
            if (hint.getSource() != BoundTypeArgumentSource.INFERRED) continue;
            inferredHints.add(hint);
        }
        if (effectiveHints.isEmpty()) {
            return false;
        }
        LightweightMergedBoundTypeArgument typeArgument = this.getServices().getBoundTypeArgumentMerger().merge(!inferredHints.isEmpty() ? inferredHints : effectiveHints, this.getOwner());
        if (typeArgument != null) {
            this.resolvedTo = typeArgument.getTypeReference();
            if (this.resolvedTo != null && varianceHints.contains((Object)VarianceInfo.OUT) && varianceHints.size() == 1 && typeArgument.getVariance() == VarianceInfo.INVARIANT && this.resolvedTo instanceof WildcardTypeReference) {
                this.resolvedTo = this.resolvedTo.getUpperBoundSubstitute();
            }
            this.getOwner().acceptHint(this.getHandle(), new LightweightBoundTypeArgument(this.resolvedTo, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, typeArgument.getVariance()));
            return true;
        }
        return false;
    }

    @Override
    public LightweightTypeReference copyInto(ITypeReferenceOwner owner) {
        return this.doCopyInto(owner);
    }

    @Override
    public boolean isResolved() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.isResolved();
        }
        return false;
    }

    public boolean internalIsResolved() {
        return this.internalGetResolvedTo() != null;
    }

    @Nullable
    protected LightweightTypeReference internalGetResolvedTo() {
        if (this.resolvedTo != null) {
            if (!this.getOwner().isResolved(this.handle)) {
                throw new IllegalStateException("owner should know that this one is resolved");
            }
            return this.resolvedTo;
        }
        if (this.getOwner().isResolved(this.getHandle())) {
            List<LightweightBoundTypeArgument> hints = this.getOwner().getAllHints(this.getHandle());
            if (hints.isEmpty()) {
                throw new IllegalStateException("cannot have empty hints if marked as resolved");
            }
            if (hints.size() != 1) {
                return null;
            }
            LightweightBoundTypeArgument singleHint = hints.get(0);
            if (singleHint.getSource() == BoundTypeArgumentSource.RESOLVED) {
                this.resolvedTo = singleHint.getTypeReference();
                return this.resolvedTo;
            }
        }
        return null;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getTypeArguments();
        }
        return super.getTypeArguments();
    }

    @Override
    public boolean isArray() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isArray();
        }
        return false;
    }

    @Override
    public boolean isAny() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isAny();
        }
        return false;
    }

    @Override
    public boolean isUnknown() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isUnknown();
        }
        return false;
    }

    @Override
    public FunctionTypeKind getFunctionTypeKind() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getFunctionTypeKind();
        }
        return super.getFunctionTypeKind();
    }

    @Override
    @Nullable
    public ArrayTypeReference tryConvertToArray() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.tryConvertToArray();
        }
        return super.tryConvertToArray();
    }

    @Override
    @Nullable
    public FunctionTypeReference tryConvertToFunctionTypeReference(boolean rawType) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.tryConvertToFunctionTypeReference(rawType);
        }
        return super.tryConvertToFunctionTypeReference(rawType);
    }

    @Override
    @Nullable
    public LightweightTypeReference tryConvertToListType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.tryConvertToListType();
        }
        return null;
    }

    @Override
    @Nullable
    public LightweightTypeReference getComponentType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getComponentType();
        }
        return super.getComponentType();
    }

    @Override
    public boolean isWrapper() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isWrapper();
        }
        return false;
    }

    @Override
    public LightweightTypeReference getPrimitiveIfWrapperType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getPrimitiveIfWrapperType();
        }
        return this;
    }

    @Override
    @Nullable
    public JvmType getType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getType();
        }
        return this.getTypeParameter();
    }

    @Override
    public boolean isType(Class<?> clazz) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isType(clazz);
        }
        return false;
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getSuperTypes(substitutor);
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public LightweightTypeReference getSuperType(JvmType rawType) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getSuperType(rawType);
        }
        return null;
    }

    @Override
    public LightweightTypeReference getWrapperTypeIfPrimitive() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getWrapperTypeIfPrimitive();
        }
        return super.getWrapperTypeIfPrimitive();
    }

    @Override
    protected LightweightTypeReference doCopyInto(ITypeReferenceOwner owner) {
        if (this.internalIsResolved()) {
            if (this.copying) {
                throw new IllegalStateException();
            }
            this.copying = true;
            try {
                LightweightTypeReference lightweightTypeReference = this.resolvedTo.copyInto(owner);
                return lightweightTypeReference;
            }
            finally {
                this.copying = false;
            }
        }
        UnboundTypeReference result = this.createCopy(owner);
        return result;
    }

    @Override
    public String getSimpleName() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getSimpleName();
        }
        return "Unbound[" + this.typeParameter.getSimpleName() + "]";
    }

    @Override
    public String getIdentifier() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getIdentifier();
        }
        return "Unbound[" + this.typeParameter.getIdentifier() + "]";
    }

    @Override
    public String getJavaIdentifier() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getJavaIdentifier();
        }
        return this.getIdentifier();
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        if (this.internalIsResolved()) {
            this.resolvedTo.accept(visitor);
        } else {
            visitor.doVisitUnboundTypeReference(this);
        }
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        if (this.internalIsResolved()) {
            this.resolvedTo.accept(visitor, param);
        } else {
            visitor.doVisitUnboundTypeReference(this, param);
        }
    }

    @Override
    @Nullable
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.accept(visitor);
        }
        return visitor.doVisitUnboundTypeReference(this);
    }

    @Override
    @Nullable
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.accept(visitor, param);
        }
        return visitor.doVisitUnboundTypeReference(this, param);
    }

    public void acceptHint(VarianceInfo variance) {
        this.acceptHint(new LightweightBoundTypeArgument(null, null, (Object)variance, null, null));
    }

    public void acceptHint(LightweightTypeReference hint, BoundTypeArgumentSource source, Object origin, VarianceInfo expectedVariance, VarianceInfo actualVariance) {
        if (!hint.isValidHint()) {
            throw new IllegalArgumentException("Hint may not be primitive void, <any> or <unknown>");
        }
        this.acceptHint(new LightweightBoundTypeArgument(hint.getWrapperTypeIfPrimitive(), source, origin, expectedVariance, actualVariance));
    }

    public void acceptHint(LightweightBoundTypeArgument hint) {
        if (this.internalIsResolved()) {
            throw new IllegalStateException("Cannot add hints to a resolved reference");
        }
        if (hint.getSource() == BoundTypeArgumentSource.EXPLICIT) {
            LightweightTypeReference reference = hint.getTypeReference();
            if (!(reference instanceof ParameterizedTypeReference || reference.isArray() || reference.isUnknown())) {
                throw new IllegalArgumentException("cannot set " + hint + " as explicit hint");
            }
            if (!this.getAllHints().isEmpty()) {
                throw new IllegalStateException("Cannot set explicit hint if other hints are present: " + this.getAllHints());
            }
            this.resolvedTo = reference;
            this.getOwner().acceptHint(this.getHandle(), new LightweightBoundTypeArgument(this.resolvedTo, BoundTypeArgumentSource.RESOLVED, this, hint.getDeclaredVariance(), hint.getActualVariance()));
            return;
        }
        this.getOwner().acceptHint(this.getHandle(), hint);
    }

    public List<LightweightBoundTypeArgument> getAllHints() {
        if (this.internalGetResolvedTo() != null) {
            throw new IllegalStateException("Cannot query hints for a resolved reference");
        }
        return this.getOwner().getAllHints(this.getHandle());
    }

    public boolean equalHandles(UnboundTypeReference reference) {
        return this.getHandle().equals(reference.getHandle());
    }

    @Override
    public boolean isWildcard() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.isWildcard();
        }
        return false;
    }

    @Override
    public boolean isMultiType() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.isMultiType();
        }
        return super.isMultiType();
    }

    @Override
    public LightweightTypeReference toJavaType() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.toJavaType();
        }
        return super.toJavaType();
    }

    @Override
    public List<LightweightTypeReference> getMultiTypeComponents() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.getMultiTypeComponents();
        }
        return super.getMultiTypeComponents();
    }
}

