/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.output.XtypeTypeReferenceSerializer;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class TypeSerializationUtil {
    @Inject
    private XtypeTypeReferenceSerializer serializer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private IImportsConfiguration importsConfig;

    public String serialize(JvmType type, EObject context) {
        return this.serialize((JvmTypeReference)this.typeReferences.createTypeRef(type, new JvmTypeReference[0]), context);
    }

    public String serialize(JvmTypeReference typeRef, EObject context) {
        if (typeRef == null) {
            return "void";
        }
        StringBuilderBasedAppendable appendable = new StringBuilderBasedAppendable(this.getImportManager(context));
        this.serializer.serialize(typeRef, context, (IAppendable)appendable);
        return appendable.toString();
    }

    public ImportManager getImportManager(EObject context) {
        ImportManager importManager = new ImportManager(true);
        XImportSection importSection = this.importsConfig.getImportSection((XtextResource)context.eResource());
        if (importSection != null) {
            for (XImportDeclaration ximport : importSection.getImportDeclarations()) {
                importManager.addImportFor((JvmType)ximport.getImportedType());
            }
        }
        return importManager;
    }
}

