/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.JvmExceptions;
import org.eclipse.xtext.xbase.typing.JvmOnlyTypeConformanceComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class AbstractXbaseCompiler {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeReferenceSerializer referenceSerializer;
    @Inject
    private JavaKeywords javaUtils;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IEarlyExitComputer exitComputer;
    @Inject
    private JvmOnlyTypeConformanceComputer typeConformanceComputer;
    @Inject
    private Primitives primitives;
    @Inject
    private JvmExceptions jvmExceptions;
    @Inject
    private IdentifiableSimpleNameProvider nameProvider;

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    public void setTypeReferences(TypeReferences typeReferences) {
        this.typeReferences = typeReferences;
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    protected Primitives getPrimitives() {
        return this.primitives;
    }

    public ITreeAppendable compile(XExpression obj, ITreeAppendable appendable, JvmTypeReference expectedReturnType) {
        this.compile(obj, appendable, expectedReturnType, null);
        return appendable;
    }

    public ITreeAppendable compileAsJavaExpression(XExpression obj, ITreeAppendable parentAppendable, JvmTypeReference expectedType) {
        boolean needsToBeWrapped;
        ITreeAppendable appendable = parentAppendable.trace(obj, true);
        boolean isPrimitiveVoidExpected = this.typeReferences.is(expectedType, Void.TYPE);
        boolean isPrimitiveVoid = this.isPrimitiveVoid(obj);
        boolean earlyExit = this.exitComputer.isEarlyExit(obj);
        boolean needsSneakyThrow = this.needsSneakyThrow(obj, Collections.<JvmTypeReference>emptySet());
        boolean bl = needsToBeWrapped = earlyExit || needsSneakyThrow || !this.canCompileToJavaExpression(obj, appendable);
        if (needsToBeWrapped) {
            appendable.openScope();
            try {
                Object thisElement;
                if (appendable.hasObject("this") && (thisElement = appendable.getObject("this")) instanceof JvmType) {
                    Object superElement;
                    appendable.declareVariable(thisElement, String.valueOf(((JvmType)thisElement).getSimpleName()) + ".this");
                    if (appendable.hasObject("super") && (superElement = appendable.getObject("super")) instanceof JvmType) {
                        appendable.declareVariable(superElement, String.valueOf(((JvmType)thisElement).getSimpleName()) + ".super");
                    }
                }
                appendable.append("new ");
                JvmTypeReference procedureOrFunction = null;
                procedureOrFunction = isPrimitiveVoidExpected ? this.typeReferences.getTypeForName(Procedures.Procedure0.class, (Notifier)obj, new JvmTypeReference[0]) : this.typeReferences.getTypeForName(Functions.Function0.class, (Notifier)obj, new JvmTypeReference[]{expectedType});
                if (procedureOrFunction != null) {
                    this.referenceSerializer.serialize(procedureOrFunction, obj, appendable, false, false, true, false);
                } else {
                    appendable.append("Object");
                }
                appendable.append("() {").increaseIndentation();
                appendable.newLine().append("public ");
                this.referenceSerializer.serialize(this.primitives.asWrapperTypeIfPrimitive(expectedType), obj, appendable);
                appendable.append(" apply() {").increaseIndentation();
                if (needsSneakyThrow) {
                    appendable.newLine().append("try {").increaseIndentation();
                }
                this.internalToJavaStatement(obj, appendable, !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit);
                if (!isPrimitiveVoidExpected && !earlyExit) {
                    appendable.newLine().append("return ");
                    if (isPrimitiveVoid && !isPrimitiveVoidExpected) {
                        this.appendDefaultLiteral(appendable, expectedType);
                    } else {
                        this.internalToJavaExpression(obj, appendable);
                    }
                    appendable.append(";");
                }
                if (needsSneakyThrow) {
                    this.generateCheckedExceptionHandling(obj, appendable);
                }
                appendable.decreaseIndentation().newLine().append("}");
                appendable.decreaseIndentation().newLine().append("}.apply()");
            }
            finally {
                appendable.closeScope();
            }
        } else {
            this.internalToJavaExpression(obj, appendable);
        }
        return parentAppendable;
    }

    protected void appendDefaultLiteral(ITreeAppendable b, @Nullable JvmTypeReference type) {
        if (type != null && this.getPrimitives().isPrimitive(type)) {
            Primitives.Primitive primitiveKind = this.getPrimitives().primitiveKind((JvmPrimitiveType)type.getType());
            switch (primitiveKind) {
                case Boolean: {
                    b.append("false");
                    break;
                }
                default: {
                    b.append("0");
                    break;
                }
            }
        } else {
            b.append("null");
        }
    }

    protected void generateCheckedExceptionHandling(XExpression obj, ITreeAppendable appendable) {
        String name = appendable.declareSyntheticVariable(new Object(), "_e");
        appendable.decreaseIndentation().newLine().append("} catch (Throwable " + name + ") {").increaseIndentation();
        JvmType findDeclaredType = this.typeReferences.findDeclaredType(Exceptions.class, (Notifier)obj);
        if (findDeclaredType == null) {
            appendable.append("COMPILE ERROR : '" + Exceptions.class.getCanonicalName() + "' could not be found on the classpath!");
        } else {
            appendable.newLine().append("throw ");
            appendable.append(findDeclaredType);
            appendable.append(".sneakyThrow(");
            appendable.append(name);
            appendable.append(");");
        }
        appendable.decreaseIndentation().newLine().append("}");
    }

    protected boolean canCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        TreeIterator iterator = EcoreUtil2.eAll((EObject)expression);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!(next instanceof XExpression) || this.internalCanCompileToJavaExpression((XExpression)next, appendable)) continue;
            return false;
        }
        return true;
    }

    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        return this.getReferenceName(expression, appendable) != null || !this.isVariableDeclarationRequired(expression, appendable);
    }

    public ITreeAppendable compile(XExpression obj, ITreeAppendable parentAppendable, @Nullable JvmTypeReference expectedReturnType, @Nullable Set<JvmTypeReference> declaredExceptions) {
        ITreeAppendable appendable = parentAppendable.trace(obj, true);
        if (declaredExceptions == null) {
            declaredExceptions = Sets.newHashSet();
            assert (declaredExceptions != null);
        }
        boolean isPrimitiveVoidExpected = this.typeReferences.is(expectedReturnType, Void.TYPE);
        boolean isPrimitiveVoid = this.isPrimitiveVoid(obj);
        boolean earlyExit = this.exitComputer.isEarlyExit(obj);
        boolean needsSneakyThrow = this.needsSneakyThrow(obj, declaredExceptions);
        if (needsSneakyThrow) {
            appendable.newLine().append("try {").increaseIndentation();
        }
        this.internalToJavaStatement(obj, appendable, !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit);
        if (!isPrimitiveVoidExpected && !earlyExit) {
            appendable.newLine().append("return ");
            if (isPrimitiveVoid && !isPrimitiveVoidExpected) {
                this.appendDefaultLiteral(appendable, expectedReturnType);
            } else {
                this.internalToJavaExpression(obj, appendable);
            }
            appendable.append(";");
        }
        if (needsSneakyThrow) {
            this.generateCheckedExceptionHandling(obj, appendable);
        }
        return parentAppendable;
    }

    protected boolean needsSneakyThrow(XExpression obj, Collection<JvmTypeReference> declaredExceptions) {
        Iterable<JvmTypeReference> types = this.typeProvider.getThrownExceptionTypes(obj);
        Iterable<JvmTypeReference> exceptions = this.jvmExceptions.findUnhandledExceptions(obj, types, declaredExceptions);
        return !Iterables.isEmpty(exceptions);
    }

    public ITreeAppendable compile(XBlockExpression expr, ITreeAppendable b, JvmTypeReference expectedReturnType) {
        boolean isPrimitiveVoidExpected = this.typeReferences.is(expectedReturnType, Void.TYPE);
        boolean isPrimitiveVoid = this.isPrimitiveVoid(expr);
        boolean earlyExit = this.exitComputer.isEarlyExit(expr);
        boolean isImplicitReturn = !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit;
        EList<XExpression> expressions = expr.getExpressions();
        int i = 0;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            if (i < expressions.size() - 1) {
                this.internalToJavaStatement(ex, b.trace(ex, true), false);
            } else {
                this.internalToJavaStatement(ex, b.trace(ex, true), isImplicitReturn);
                if (isImplicitReturn) {
                    b.newLine().append("return (");
                    this.internalToConvertedExpression(ex, b, this.getType(expr));
                    b.append(");");
                }
            }
            ++i;
        }
        return b;
    }

    protected JvmTypeReference getType(XExpression expr) {
        return this.getTypeProvider().getType(expr);
    }

    protected abstract void internalToConvertedExpression(XExpression var1, ITreeAppendable var2, @Nullable JvmTypeReference var3);

    protected boolean isPrimitiveVoid(XExpression xExpression) {
        JvmTypeReference type = this.getType(xExpression);
        return this.typeReferences.is(type, Void.TYPE);
    }

    protected final void internalToJavaStatement(XExpression obj, ITreeAppendable builder, boolean isReferenced) {
        ITreeAppendable trace = builder.trace(obj, true);
        this.doInternalToJavaStatement(obj, trace, isReferenced);
    }

    protected void doInternalToJavaStatement(XExpression obj, ITreeAppendable builder, boolean isReferenced) {
        this._toJavaStatement(obj, builder, isReferenced);
    }

    public void toJavaExpression(XExpression obj, ITreeAppendable appendable) {
        this.internalToJavaExpression(obj, appendable.trace(obj, true));
    }

    public void toJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        this.internalToJavaStatement(obj, appendable.trace(obj, true), isReferenced);
    }

    protected void internalToJavaExpression(XExpression obj, ITreeAppendable appendable) {
        this._toJavaExpression(obj, appendable);
    }

    public void _toJavaStatement(XExpression func, ITreeAppendable b, boolean isReferenced) {
        throw new UnsupportedOperationException("Coudn't find a compilation strategy for expressions of type " + func.getClass().getCanonicalName());
    }

    public void _toJavaExpression(XExpression func, ITreeAppendable b) {
        throw new UnsupportedOperationException("Coudn't find a compilation strategy for expressions of type " + func.getClass().getCanonicalName());
    }

    protected void serialize(JvmTypeReference type, EObject context, ITreeAppendable appendable) {
        this.serialize(type, context, appendable, false, true);
    }

    protected void serialize(JvmTypeReference type, EObject context, ITreeAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard) {
        this.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, false, true);
    }

    protected void serialize(JvmTypeReference type, EObject context, ITreeAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard, boolean paramsToObject, boolean allowPrimitives) {
        this.referenceSerializer.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
    }

    protected boolean isReferenceToForeignTypeParameter(JvmTypeReference reference, EObject context) {
        JvmType type = reference.getType();
        if (type instanceof JvmTypeParameter) {
            return !this.referenceSerializer.isLocalTypeParameter(context, (JvmTypeParameter)type);
        }
        return false;
    }

    protected JvmTypeReference resolveMultiType(JvmTypeReference typeRef, EObject context) {
        return this.referenceSerializer.resolveMultiType(typeRef, context);
    }

    protected String getVarName(Object ex, ITreeAppendable appendable) {
        String name = appendable.getName(ex);
        return name;
    }

    public void setNameProvider(IdentifiableSimpleNameProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    protected IdentifiableSimpleNameProvider getNameProvider() {
        return this.nameProvider;
    }

    protected String getFavoriteVariableName(EObject ex) {
        if (ex instanceof XVariableDeclaration) {
            return ((XVariableDeclaration)ex).getName();
        }
        if (ex instanceof JvmFormalParameter) {
            return ((JvmFormalParameter)ex).getName();
        }
        if (ex instanceof JvmArrayType) {
            return this.getFavoriteVariableName((EObject)((JvmArrayType)ex).getComponentType());
        }
        if (ex instanceof JvmType) {
            return "_" + Strings.toFirstLower((String)((JvmType)ex).getSimpleName());
        }
        if (ex instanceof JvmIdentifiableElement) {
            return ((JvmIdentifiableElement)ex).getSimpleName();
        }
        if (ex instanceof XAbstractFeatureCall) {
            String name = this.nameProvider.getSimpleName(((XAbstractFeatureCall)ex).getFeature());
            int indexOf = name.indexOf(40);
            if (indexOf != -1) {
                name = name.substring(0, indexOf);
            }
            if ((indexOf = name.lastIndexOf(46)) != -1) {
                name = name.substring(indexOf + 1);
            }
            if (name.startsWith("operator_")) {
                name = Strings.toFirstLower((String)name.substring("operator_".length()));
            } else if (name.startsWith("get") && name.length() > 3) {
                name = Strings.toFirstLower((String)name.substring(3));
            } else if (name.startsWith("to") && name.length() > 2) {
                name = Strings.toFirstLower((String)name.substring(2));
            }
            return "_" + name;
        }
        if (ex instanceof XConstructorCall) {
            String name = ((XConstructorCall)ex).getConstructor().getSimpleName();
            return "_" + Strings.toFirstLower((String)name);
        }
        return "_" + Strings.toFirstLower((String)ex.eClass().getName().toLowerCase());
    }

    protected String makeJavaIdentifier(String name) {
        return this.javaUtils.isJavaKeyword(name) ? String.valueOf(name) + "_" : name;
    }

    protected void declareSyntheticVariable(final XExpression expr, ITreeAppendable b) {
        this.declareFreshLocalVariable(expr, b, new Later(){

            public void exec(ITreeAppendable appendable) {
                appendable.append(AbstractXbaseCompiler.this.getDefaultValueLiteral(expr));
            }
        });
    }

    protected String getDefaultValueLiteral(XExpression expr) {
        JvmTypeReference type = this.getType(expr);
        if (this.primitives.isPrimitive(type)) {
            if (this.primitives.primitiveKind((JvmPrimitiveType)type.getType()) == Primitives.Primitive.Boolean) {
                return "false";
            }
            return "(" + type.getQualifiedName() + ") 0";
        }
        return "null";
    }

    protected void declareFreshLocalVariable(XExpression expr, ITreeAppendable b, Later expression) {
        JvmTypeReference type = this.getTypeForVariableDeclaration(expr);
        String proposedName = this.makeJavaIdentifier(this.getFavoriteVariableName(expr));
        String varName = b.declareSyntheticVariable(expr, proposedName);
        b.newLine();
        this.serialize(type, expr, b);
        b.append(" ").append(varName).append(" = ");
        expression.exec(b);
        b.append(";");
    }

    protected JvmTypeReference getTypeForVariableDeclaration(XExpression expr) {
        JvmTypeReference type = this.getType(expr);
        if (type instanceof JvmAnyTypeReference) {
            JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(expr);
            if (expectedType == null && (expectedType = this.getTypeProvider().getExpectedReturnType(expr, false)) == null) {
                expectedType = this.getTypeProvider().getCommonReturnType(expr, true);
            }
            if (expectedType != null && !(expectedType.getType() instanceof JvmTypeParameter) && !this.typeReferences.is(expectedType, Void.TYPE)) {
                type = expectedType;
            }
        }
        return type;
    }

    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b) {
        return true;
    }

    protected TypeConformanceComputer getTypeConformanceComputer() {
        return this.typeConformanceComputer;
    }

    @Nullable
    protected String getReferenceName(XExpression expr, ITreeAppendable b) {
        XFeatureCall featureCall;
        if (b.hasName(expr)) {
            return b.getName(expr);
        }
        if (expr instanceof XFeatureCall && b.hasName((featureCall = (XFeatureCall)expr).getFeature())) {
            return b.getName(featureCall.getFeature());
        }
        return null;
    }
}

