/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class WildcardTypeReference
extends LightweightTypeReference {
    private List<LightweightTypeReference> upperBounds;
    private LightweightTypeReference lowerBound;
    private boolean resolved = true;

    public WildcardTypeReference(ITypeReferenceOwner owner) {
        super(owner);
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        if (this.lowerBound != null) {
            return this.lowerBound.getTypeArguments();
        }
        if (this.upperBounds != null && this.upperBounds.size() == 1) {
            return this.upperBounds.get(0).getTypeArguments();
        }
        return super.getTypeArguments();
    }

    public List<LightweightTypeReference> getUpperBounds() {
        return this.expose(this.upperBounds);
    }

    public boolean isUnbounded() {
        return this.lowerBound == null && this.upperBounds == null || this.upperBounds.isEmpty();
    }

    @Nullable
    public LightweightTypeReference getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        if (super.isOwnedBy(owner)) {
            if (this.lowerBound != null && !this.lowerBound.isOwnedBy(owner)) {
                return false;
            }
            for (LightweightTypeReference parameterType : this.expose(this.upperBounds)) {
                if (parameterType.isOwnedBy(owner)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected WildcardTypeReference doCopyInto(ITypeReferenceOwner owner) {
        LightweightTypeReference copiedLowerBound;
        WildcardTypeReference result = new WildcardTypeReference(owner);
        if (this.upperBounds != null && !this.upperBounds.isEmpty()) {
            for (LightweightTypeReference upperBound : this.upperBounds) {
                LightweightTypeReference copiedUpperBound = upperBound.copyInto(owner).getInvariantBoundSubstitute();
                if (copiedUpperBound.isPrimitive() || copiedUpperBound.isPrimitiveVoid()) continue;
                result.addUpperBound(copiedUpperBound);
            }
        }
        if (this.lowerBound != null && !(copiedLowerBound = this.lowerBound.copyInto(owner).getInvariantBoundSubstitute()).isPrimitive() && !copiedLowerBound.isPrimitiveVoid()) {
            result.setLowerBound(copiedLowerBound);
        }
        return result;
    }

    @Override
    public boolean isType(Class<?> clazz) {
        return false;
    }

    @Override
    public LightweightTypeReference getUpperBoundSubstitute() {
        if (this.isUnbounded()) {
            JvmType object = this.getOwner().getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)this.getOwner().getContextResourceSet());
            return new ParameterizedTypeReference(this.getOwner(), object);
        }
        List<LightweightTypeReference> upperBounds = this.getUpperBounds();
        if (upperBounds.size() == 1) {
            LightweightTypeReference result = upperBounds.get(0);
            return result;
        }
        CompoundTypeReference result = new CompoundTypeReference(this.getOwner(), false);
        for (LightweightTypeReference upperBound : upperBounds) {
            result.addComponent(upperBound);
        }
        return result;
    }

    @Override
    public LightweightTypeReference getLowerBoundSubstitute() {
        if (this.lowerBound != null) {
            return this.lowerBound;
        }
        return new AnyTypeReference(this.getOwner());
    }

    @Override
    public LightweightTypeReference getInvariantBoundSubstitute() {
        if (this.lowerBound != null) {
            return this.lowerBound;
        }
        return this.getUpperBoundSubstitute();
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        if (this.isUnbounded()) {
            return Collections.singletonList(this.getUpperBoundSubstitute());
        }
        List<LightweightTypeReference> nonNullUpperBounds = this.expose(this.getUpperBounds());
        ArrayList result = Lists.newArrayListWithCapacity((int)nonNullUpperBounds.size());
        for (LightweightTypeReference upperBound : nonNullUpperBounds) {
            result.add(substitutor.substitute(upperBound));
        }
        return result;
    }

    @Override
    @Nullable
    public LightweightTypeReference getSuperType(JvmType rawType) {
        if (this.isUnbounded()) {
            if (Object.class.getCanonicalName().equals(rawType.getIdentifier())) {
                return new ParameterizedTypeReference(this.getOwner(), rawType);
            }
            return null;
        }
        List<LightweightTypeReference> nonNullUpperBounds = this.expose(this.getUpperBounds());
        for (LightweightTypeReference upperBound : nonNullUpperBounds) {
            LightweightTypeReference result = upperBound.getSuperType(rawType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public JvmTypeReference toTypeReference() {
        TypesFactory typesFactory = this.getTypesFactory();
        JvmWildcardTypeReference result = typesFactory.createJvmWildcardTypeReference();
        if (this.upperBounds != null && !this.upperBounds.isEmpty()) {
            for (LightweightTypeReference typeArgument : this.upperBounds) {
                JvmUpperBound constraint = typesFactory.createJvmUpperBound();
                constraint.setTypeReference(typeArgument.getWrapperTypeIfPrimitive().toTypeReference());
                result.getConstraints().add((Object)constraint);
            }
        }
        if (this.lowerBound != null) {
            JvmLowerBound constraint = typesFactory.createJvmLowerBound();
            constraint.setTypeReference(this.lowerBound.getWrapperTypeIfPrimitive().toTypeReference());
            result.getConstraints().add((Object)constraint);
        }
        return result;
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper helper) {
        TypesFactory typesFactory = this.getTypesFactory();
        JvmWildcardTypeReference result = typesFactory.createJvmWildcardTypeReference();
        if (this.upperBounds != null && !this.upperBounds.isEmpty()) {
            List<LightweightTypeReference> nonInterfaceTypes = this.getNonInterfaceTypes(this.upperBounds);
            JvmTypeReference upperBound = this.toJavaCompliantTypeReference(nonInterfaceTypes != null ? nonInterfaceTypes : this.upperBounds, helper);
            JvmUpperBound constraint = typesFactory.createJvmUpperBound();
            constraint.setTypeReference(upperBound);
            result.getConstraints().add((Object)constraint);
        }
        if (this.lowerBound != null) {
            JvmLowerBound constraint = typesFactory.createJvmLowerBound();
            constraint.setTypeReference(this.lowerBound.toJavaCompliantTypeReference());
            result.getConstraints().add((Object)constraint);
        }
        return result;
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        if (this.upperBounds != null && !this.upperBounds.isEmpty()) {
            for (LightweightTypeReference upperBound : this.upperBounds) {
                if (upperBound.isVisible(visibilityHelper)) continue;
                return false;
            }
        }
        return this.lowerBound == null || this.lowerBound.isVisible(visibilityHelper);
    }

    public void addUpperBound(LightweightTypeReference upperBound) {
        if (upperBound == null) {
            throw new NullPointerException("upperBound may not be null");
        }
        if (!upperBound.isOwnedBy(this.getOwner())) {
            throw new IllegalArgumentException("upperBound is not valid in current context");
        }
        if (upperBound instanceof WildcardTypeReference) {
            throw new IllegalArgumentException("Wildcards are not supported as upper bounds");
        }
        if (upperBound.isPrimitive() || upperBound.isPrimitiveVoid()) {
            throw new IllegalArgumentException("Constraints may not be primitives");
        }
        if (this.upperBounds == null) {
            this.upperBounds = Lists.newArrayListWithCapacity((int)2);
        }
        this.upperBounds.add(upperBound);
        this.resolved = this.resolved && upperBound.isResolved();
    }

    public void setLowerBound(LightweightTypeReference lowerBound) {
        if (lowerBound == null) {
            throw new NullPointerException("lowerBound may not be null");
        }
        if (!lowerBound.isOwnedBy(this.getOwner())) {
            throw new IllegalArgumentException("lowerBound is not valid in current context");
        }
        if (lowerBound instanceof WildcardTypeReference) {
            throw new IllegalArgumentException("Wildcards are not supported as lower bounds");
        }
        if (lowerBound.isPrimitive() || lowerBound.isPrimitiveVoid()) {
            throw new IllegalArgumentException("Constraints may not be primitives");
        }
        if (this.lowerBound != null && this.lowerBound != lowerBound) {
            throw new IllegalStateException("only one lower bound is supported");
        }
        this.lowerBound = lowerBound;
        this.resolved = this.resolved && lowerBound.isResolved();
    }

    @Override
    public String getSimpleName() {
        return this.getAsString(new LightweightTypeReference.SimpleNameFunction());
    }

    @Override
    public String getIdentifier() {
        return this.getAsString(new LightweightTypeReference.IdentifierFunction());
    }

    @Override
    public String getJavaIdentifier() {
        return this.getAsString(new LightweightTypeReference.JavaIdentifierFunction());
    }

    @Override
    @Nullable
    public JvmType getType() {
        return null;
    }

    private String getAsString(Function<LightweightTypeReference, String> format) {
        if (this.lowerBound != null) {
            return "? super " + (String)format.apply((Object)this.lowerBound);
        }
        if (this.upperBounds != null && this.upperBounds.size() == 1 && this.upperBounds.get(0).isType(Object.class)) {
            return "?";
        }
        return "?" + (this.upperBounds != null ? " extends " + Joiner.on((String)" & ").join(Iterables.transform(this.upperBounds, format)) : "");
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitWildcardTypeReference(this);
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitWildcardTypeReference(this, param);
    }

    @Override
    @Nullable
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitWildcardTypeReference(this);
    }

    @Override
    @Nullable
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitWildcardTypeReference(this, param);
    }

    @Override
    public boolean isWildcard() {
        return true;
    }
}

