/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.impl;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.AbstractCleaningLinker;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticProducer;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linker
extends AbstractCleaningLinker {
    private static Logger log = Logger.getLogger(Linker.class);
    @Inject
    private ILinkingService linkingService;
    @Inject
    private ILinkingDiagnosticMessageProvider.Extended diagnosticMessageProvider;
    @Inject
    private LinkingHelper linkingHelper;

    public void ensureLinked(EObject obj, IDiagnosticProducer producer) {
        ICompositeNode node = NodeModelUtils.getNode(obj);
        if (node == null) {
            return;
        }
        HashSet<EReference> handledReferences = new HashSet<EReference>();
        this.ensureLinked(obj, producer, node, handledReferences);
        producer.setNode(node);
        this.setDefaultValues(obj, handledReferences, producer);
    }

    private void ensureLinked(EObject obj, IDiagnosticProducer producer, ICompositeNode node, Set<EReference> handledReferences) {
        for (INode abstractNode : node.getChildren()) {
            if (!(abstractNode.getGrammarElement() instanceof CrossReference)) continue;
            CrossReference ref = (CrossReference)abstractNode.getGrammarElement();
            producer.setNode(abstractNode);
            this.ensureIsLinked(obj, abstractNode, ref, handledReferences, producer);
        }
        if (this.shouldCheckParentNode(node)) {
            this.ensureLinked(obj, producer, node.getParent(), handledReferences);
        }
    }

    protected IDiagnosticProducer createDiagnosticProducer(IDiagnosticConsumer consumer) {
        return new LinkingDiagnosticProducer(consumer);
    }

    private void setDefaultValues(EObject obj, Set<EReference> references, IDiagnosticProducer producer) {
        for (EReference ref : obj.eClass().getEAllReferences()) {
            if (!this.canSetDefaultValues(ref) || references.contains(ref) || obj.eIsSet((EStructuralFeature)ref) || ref.isDerived()) continue;
            this.setDefaultValue(obj, ref, producer);
        }
    }

    protected boolean canSetDefaultValues(EReference ref) {
        return !ref.isContainment() && !ref.isContainer() && ref.isChangeable();
    }

    protected final void setDefaultValue(EObject obj, EReference ref, IDiagnosticProducer producer) {
        producer.setTarget(obj, (EStructuralFeature)ref);
        this.setDefaultValueImpl(obj, ref, producer);
    }

    protected void setDefaultValueImpl(EObject obj, EReference ref, IDiagnosticProducer producer) {
    }

    protected void beforeEnsureIsLinked(EObject obj, EReference ref, IDiagnosticProducer producer) {
    }

    protected void ensureIsLinked(EObject obj, INode node, CrossReference ref, Set<EReference> handledReferences, IDiagnosticProducer producer) {
        block13: {
            EReference eRef = GrammarUtil.getReference(ref, obj.eClass());
            if (eRef == null) {
                ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                DiagnosticMessage message = this.diagnosticMessageProvider.getIllegalCrossReferenceMessage(context, ref);
                producer.addDiagnostic(message);
                return;
            }
            handledReferences.add(eRef);
            this.beforeEnsureIsLinked(obj, eRef, producer);
            producer.setTarget(obj, (EStructuralFeature)eRef);
            try {
                List<EObject> links = this.getLinkedObject(obj, eRef, node);
                if (links == null || links.isEmpty()) {
                    if (!this.isNullValidResult(obj, eRef, node)) {
                        ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                        DiagnosticMessage message = this.diagnosticMessageProvider.getUnresolvedProxyMessage(context);
                        producer.addDiagnostic(message);
                    }
                    return;
                }
                if (eRef.getUpperBound() >= 0 && links.size() > eRef.getUpperBound()) {
                    ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                    DiagnosticMessage message = this.diagnosticMessageProvider.getViolatedBoundsConstraintMessage(context, links.size());
                    producer.addDiagnostic(message);
                    return;
                }
                if (eRef.getUpperBound() == 1) {
                    obj.eSet((EStructuralFeature)eRef, (Object)links.get(0));
                } else {
                    List list = (List)obj.eGet((EStructuralFeature)eRef);
                    if (links.size() > 1 && eRef.isUnique() && list instanceof InternalEList) {
                        LinkedHashSet<EObject> addUs = new LinkedHashSet<EObject>(links);
                        int i = 0;
                        while (i < list.size()) {
                            addUs.remove(list.get(i));
                            ++i;
                        }
                        if (!((InternalEList)list).addAllUnique(addUs)) {
                            ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                            DiagnosticMessage message = this.diagnosticMessageProvider.getViolatedBoundsConstraintMessage(context, links.size());
                            producer.addDiagnostic(message);
                        }
                    } else if (!list.addAll(links)) {
                        ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                        DiagnosticMessage message = this.diagnosticMessageProvider.getViolatedBoundsConstraintMessage(context, links.size());
                        producer.addDiagnostic(message);
                    }
                }
            }
            catch (IllegalNodeException e) {
                ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticContext(obj, eRef, node);
                DiagnosticMessage message = this.diagnosticMessageProvider.getIllegalNodeMessage(context, e);
                producer.addDiagnostic(message);
                if (!log.isDebugEnabled()) break block13;
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext createDiagnosticContext(EObject obj, EReference eRef, INode node) {
        return new LinkingDiagnosticContext(obj, eRef, node, this.linkingHelper);
    }

    protected List<EObject> getLinkedObject(EObject obj, EReference eRef, INode node) throws IllegalNodeException {
        return this.linkingService.getLinkedObjects(obj, eRef, node);
    }

    protected boolean isNullValidResult(EObject obj, EReference eRef, INode node) {
        return false;
    }

    public ILinkingService getLinkingService() {
        return this.linkingService;
    }

    public void setLinkingService(ILinkingService linkingService) {
        this.linkingService = linkingService;
    }

    @Override
    protected void doLinkModel(EObject model, IDiagnosticConsumer consumer) {
        IDiagnosticProducer producer = this.createDiagnosticProducer(consumer);
        this.ensureModelLinked(model, producer);
    }

    protected void ensureModelLinked(EObject model, IDiagnosticProducer producer) {
        this.ensureLinked(model, producer);
        TreeIterator allContents = model.eAllContents();
        while (allContents.hasNext()) {
            this.ensureLinked((EObject)allContents.next(), producer);
        }
    }

    public void setDiagnosticMessageProvider(ILinkingDiagnosticMessageProvider.Extended diagnosticMessageProvider) {
        this.diagnosticMessageProvider = diagnosticMessageProvider;
    }

    public ILinkingDiagnosticMessageProvider.Extended getDiagnosticMessageProvider() {
        return this.diagnosticMessageProvider;
    }

    public LinkingHelper getLinkingHelper() {
        return this.linkingHelper;
    }

    public void setLinkingHelper(LinkingHelper linkingHelper) {
        this.linkingHelper = linkingHelper;
    }

    protected static class LinkingDiagnosticContext
    implements ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext {
        private final EObject obj;
        private final EReference eRef;
        private final INode node;
        private final LinkingHelper linkingHelper;

        protected LinkingDiagnosticContext(EObject obj, EReference eRef, INode node, LinkingHelper helper) {
            this.obj = obj;
            this.eRef = eRef;
            this.node = node;
            this.linkingHelper = helper;
        }

        public EObject getContext() {
            return this.obj;
        }

        public EReference getReference() {
            return this.eRef;
        }

        public String getLinkText() {
            return this.linkingHelper.getCrossRefNodeAsString(this.node, true);
        }
    }
}

