/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.ui.refactoring.IRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.impl.FixedCompositeChange;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessorBasedRenameParticipant
extends RenameParticipant {
    private static final Logger LOG = Logger.getLogger(AbstractProcessorBasedRenameParticipant.class);
    @Inject
    private IGlobalServiceProvider globalServiceProvider;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private StatusWrapper status;
    private List<RenameProcessor> wrappedProcessors;
    private Set<Object> disabledTargets = Sets.newHashSet();

    protected boolean initialize(Object originalTargetElement) {
        try {
            this.wrappedProcessors = this.getRenameProcessors(originalTargetElement);
            return this.wrappedProcessors != null;
        }
        catch (Exception exc) {
            this.status.add(3, "Error initializing refactoring participant.", exc, LOG);
            return false;
        }
    }

    protected List<RenameProcessor> getRenameProcessors(Object originalTargetElement) {
        List<? extends IRenameElementContext> participantContexts = this.createRenameElementContexts(originalTargetElement);
        if (participantContexts != null) {
            ArrayList processors = Lists.newArrayList();
            for (IRenameElementContext iRenameElementContext : participantContexts) {
                RenameProcessor renameProcessor = this.getRenameProcessor(iRenameElementContext);
                if (renameProcessor == null) continue;
                processors.add(renameProcessor);
            }
            return processors;
        }
        return null;
    }

    protected RenameProcessor getRenameProcessor(IRenameElementContext participantContext) {
        IRenameRefactoringProvider renameRefactoringProvider = this.getRenameRefactoringProvider(participantContext);
        if (renameRefactoringProvider != null) {
            return renameRefactoringProvider.getRenameProcessor(participantContext);
        }
        return null;
    }

    protected IRenameRefactoringProvider getRenameRefactoringProvider(IRenameElementContext renameElementContext) {
        return (IRenameRefactoringProvider)this.globalServiceProvider.findService(renameElementContext.getTargetElementURI(), IRenameRefactoringProvider.class);
    }

    public String getName() {
        return this.languageName;
    }

    public Object[] getElements() {
        ArrayList elements = Lists.newArrayList();
        for (RenameProcessor wrappedProcessor : this.wrappedProcessors) {
            elements.addAll(Arrays.asList(wrappedProcessor.getElements()));
        }
        return Iterables.toArray((Iterable)elements, Object.class);
    }

    public void disableFor(Object ... elements) {
        this.disabledTargets.addAll(Arrays.asList(elements));
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm).setWorkRemaining(100);
        try {
            for (RenameProcessor wrappedProcessor : this.wrappedProcessors) {
                List<Object> targetElements = Arrays.asList(wrappedProcessor.getElements());
                if (this.disabledTargets.containsAll(targetElements)) continue;
                this.setNewName(wrappedProcessor, this.getNewName());
                this.status.merge(wrappedProcessor.checkInitialConditions((IProgressMonitor)progress.newChild(20)));
                if (this.status.getRefactoringStatus().hasFatalError()) continue;
                this.status.merge(wrappedProcessor.checkFinalConditions((IProgressMonitor)progress.newChild(80), context));
            }
        }
        catch (Exception ce) {
            this.status.add(3, "Error checking conditions in refactoring participant: {0}. See log for details", ce, LOG);
        }
        return this.status.getRefactoringStatus();
    }

    protected void setNewName(RenameProcessor processor, String newName) {
        ((AbstractRenameProcessor)processor).setNewName(newName);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        FixedCompositeChange compositeChange = null;
        try {
            try {
                for (RenameProcessor wrappedProcessor : this.wrappedProcessors) {
                    Change processorChange;
                    if (this.disabledTargets.containsAll(Arrays.asList(wrappedProcessor.getElements())) || (processorChange = wrappedProcessor.createChange(pm)) == null) continue;
                    if (compositeChange == null) {
                        compositeChange = new FixedCompositeChange("Changes from participant: " + this.getName());
                    }
                    compositeChange.add(processorChange);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.xtext.ui", "Error creating change", (Throwable)e));
            }
        }
        finally {
            this.dispose();
        }
        return compositeChange;
    }

    protected void dispose() {
        this.status = null;
        this.wrappedProcessors = null;
        this.disabledTargets.clear();
    }

    protected List<? extends IRenameElementContext> createRenameElementContexts(Object element) {
        IRenameElementContext triggeringContext;
        IProject project;
        if (element instanceof IRenameElementContext && (project = this.projectUtil.getProject((triggeringContext = (IRenameElementContext)element).getTargetElementURI())) != null) {
            ResourceSet resourceSet = this.resourceSetProvider.get(project);
            EObject originalTarget = resourceSet.getEObject(triggeringContext.getTargetElementURI(), true);
            List<EObject> renamedElements = this.getRenamedElementsOrProxies(originalTarget);
            if (renamedElements == null || renamedElements.isEmpty()) {
                return null;
            }
            ArrayList contexts = Lists.newArrayListWithCapacity((int)renamedElements.size());
            for (EObject renamedElement : renamedElements) {
                contexts.add(new IRenameElementContext.Impl(EcoreUtil.getURI((EObject)renamedElement), renamedElement.eClass(), triggeringContext.getTriggeringEditor(), triggeringContext.getTriggeringEditorSelection(), triggeringContext.getContextResourceURI()));
            }
            return contexts;
        }
        return null;
    }

    protected abstract List<EObject> getRenamedElementsOrProxies(EObject var1);

    protected String getNewName() {
        return this.getArguments().getNewName();
    }

    protected StatusWrapper getStatus() {
        return this.status;
    }

    protected IGlobalServiceProvider getGlobalServiceProvider() {
        return this.globalServiceProvider;
    }
}

