/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.tasks.ITaskFinder;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.util.ITextRegion;

public class DefaultSemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    @Inject
    private ITaskFinder taskFinder;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null) {
            return;
        }
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null || parseResult.getRootASTElement() == null) {
            return;
        }
        this.doProvideHighlightingFor(resource, acceptor);
    }

    protected void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        this.searchAndHighlightElements(resource, acceptor);
        this.highlightTasks(resource, acceptor);
    }

    protected void searchAndHighlightElements(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            throw new IllegalStateException("resource#parseResult may not be null");
        }
        EObject element = parseResult.getRootASTElement();
        this.highlightElementRecursively(element, acceptor);
    }

    protected void highlightElementRecursively(EObject element, IHighlightedPositionAcceptor acceptor) {
        TreeIterator iterator = EcoreUtil2.eAll((EObject)element);
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (!this.highlightElement(object, acceptor)) continue;
            iterator.prune();
        }
    }

    protected boolean highlightElement(EObject object, IHighlightedPositionAcceptor acceptor) {
        return false;
    }

    protected void highlightTasks(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        List tasks = this.taskFinder.findTasks((Resource)resource);
        for (Task task : tasks) {
            acceptor.addPosition(task.getOffset(), task.getTagLength(), "task");
        }
    }

    protected void highlightFeature(IHighlightedPositionAcceptor acceptor, EObject object, EStructuralFeature feature, String ... styleIds) {
        List children = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
        if (children.size() > 0) {
            this.highlightNode(acceptor, (INode)children.get(0), styleIds);
        }
    }

    protected void highlightNode(IHighlightedPositionAcceptor acceptor, INode node, String ... styleIds) {
        if (node == null) {
            return;
        }
        if (node instanceof ILeafNode) {
            ITextRegion textRegion = node.getTextRegion();
            acceptor.addPosition(textRegion.getOffset(), textRegion.getLength(), styleIds);
        } else {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                ITextRegion leafRegion = leaf.getTextRegion();
                acceptor.addPosition(leafRegion.getOffset(), leafRegion.getLength(), styleIds);
            }
        }
    }
}

