/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractResolvedReference;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedConstructor
extends AbstractResolvedReference<XConstructorCall>
implements IConstructorLinkingCandidate {
    public ResolvedConstructor(XConstructorCall constructorCall, JvmConstructor constructor, ITypeExpectation expectation, ExpressionTypeComputationState state) {
        super(constructorCall, (JvmIdentifiableElement)constructor, expectation, state);
    }

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        return this;
    }

    @Override
    public JvmConstructor getConstructor() {
        return (JvmConstructor)this.getFeature();
    }

    @Override
    public boolean isAnonymousClassConstructorCall() {
        return this.getConstructorCall().isAnonymousClassConstructorCall();
    }

    @Override
    public XConstructorCall getConstructorCall() {
        return (XConstructorCall)this.getExpression();
    }

    @Override
    protected List<XExpression> getArguments() {
        return this.getConstructorCall().getArguments();
    }

    @Override
    protected List<LightweightTypeReference> getSyntacticTypeArguments() {
        if (this.isAnonymousClassConstructorCall()) {
            return Collections.emptyList();
        }
        return Lists.transform(this.getConstructorCall().getTypeArguments(), (Function)this.getState().getResolvedTypes().getConverter());
    }

    @Override
    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        return new FeatureLinkHelper().getDeclaredTypeParameters(this.getConstructor());
    }
}

