/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.formatting;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.formatting.IContentFormatterFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.formatting.FormattingPreferenceValues;
import org.eclipse.xtext.xbase.formatting.IBasicFormatter;
import org.eclipse.xtext.xbase.formatting.IFormattingPreferenceValuesProvider;
import org.eclipse.xtext.xbase.formatting.TextReplacement;

public class FormatterFactory
implements IContentFormatterFactory {
    @Inject
    private ContentFormatter formatter;

    public IContentFormatter createConfiguredFormatter(SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        return this.formatter;
    }

    public static class ContentFormatter
    implements IContentFormatter {
        @Inject
        protected IBasicFormatter formatter;
        @Inject
        private IFormattingPreferenceValuesProvider cfgProvider;

        public void format(IDocument document, IRegion region) {
            IXtextDocument doc = (IXtextDocument)document;
            TextEdit r = (TextEdit)doc.priorityReadOnly((IUnitOfWork)new FormattingUnitOfWork(this.formatter, region, (IPreferenceValuesProvider)this.cfgProvider));
            try {
                if (r != null) {
                    r.apply(document);
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        public IFormattingStrategy getFormattingStrategy(String contentType) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormattingUnitOfWork
    implements IUnitOfWork<TextEdit, XtextResource> {
        private final IRegion region;
        private final IPreferenceValuesProvider configurationProvider;
        private final IBasicFormatter formatter;

        public FormattingUnitOfWork(IBasicFormatter formatter, IRegion region, IPreferenceValuesProvider configurationProvider) {
            this.configurationProvider = configurationProvider;
            this.region = region;
            this.formatter = formatter;
        }

        public TextEdit exec(XtextResource state) throws Exception {
            IParseResult parseResult = state.getParseResult();
            if (parseResult == null) {
                return null;
            }
            IPreferenceValues configuration = this.configurationProvider.getPreferenceValues((Resource)state);
            MultiTextEdit mte = new MultiTextEdit();
            try {
                List edits = this.formatter.format(state, this.region.getOffset(), this.region.getLength(), new FormattingPreferenceValues(configuration));
                for (TextReplacement tr : edits) {
                    mte.addChild((TextEdit)new ReplaceEdit(tr.getOffset(), tr.getLength(), tr.getText()));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return mte;
        }
    }
}

