/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.contentassist.antlr;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtend.core.parser.InternalFlexer;
import org.eclipse.xtend.ide.contentassist.antlr.internal.ContentAssistFlexerFactory;
import org.eclipse.xtext.ui.editor.contentassist.antlr.ParserBasedContentAssistContextFactory;
import org.eclipse.xtext.util.Strings;

public class FlexerBasedContentAssistContextFactory
extends ParserBasedContentAssistContextFactory.StatefulFactory {
    private static final Logger log = Logger.getLogger(FlexerBasedContentAssistContextFactory.class);
    @Inject
    private ContentAssistFlexerFactory flexerFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createContextsForLastCompleteNode(EObject previousModel, boolean strict) throws BadLocationException {
        String currentNodePrefix = this.getPrefix(this.currentNode);
        if (!Strings.isEmpty((String)currentNodePrefix) && !this.currentNode.getText().equals(currentNodePrefix)) {
            InternalFlexer flexer = this.flexerFactory.createFlexer(new StringReader(currentNodePrefix));
            try {
                int token = flexer.advance();
                if (token == -1) {
                    return;
                }
                while (token != -1) {
                    if (this.isErrorToken(token)) {
                        return;
                    }
                    token = flexer.advance();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        String prefix = "";
        String completeInput = this.viewer.getDocument().get(0, this.completionOffset);
        Collection followElements = this.parser.getFollowElements(completeInput, strict);
        this.doCreateContexts(this.lastCompleteNode, this.currentNode, prefix, previousModel, followElements);
    }

    protected boolean isErrorToken(int token) {
        return 126 == token;
    }
}

