/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.xtext.builder.trace.AbstractTrace;
import org.eclipse.xtext.builder.trace.FolderAwareTrace;
import org.eclipse.xtext.builder.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.builder.trace.ZipFileAwareTrace;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class TraceForTypeRootProvider
implements ITraceForTypeRootProvider {
    private static final Logger log = Logger.getLogger(TraceForTypeRootProvider.class);
    @Inject
    private TraceRegionSerializer traceRegionSerializer;
    @Inject
    private Provider<ZipFileAwareTrace> zipFileAwareTraceProvider;
    @Inject
    private Provider<FolderAwareTrace> folderAwareTraceProvider;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    private ITraceForStorageProvider traceForStorageProvider;
    private Pair<ITypeRoot, ITrace> lruCache = null;

    protected String getPathInFragmentRoot(ITypeRoot derivedResource) {
        return String.valueOf(derivedResource.getParent().getElementName().replace('.', '/')) + "/";
    }

    protected String getTraceSimpleFileName(ITypeRoot derivedResource) {
        IType type = derivedResource.findPrimaryType();
        if (type == null) {
            return null;
        }
        String sourceName = ((BinaryType)type).getSourceFileName(null);
        if (sourceName == null) {
            return null;
        }
        if (sourceName.endsWith(".java")) {
            return this.traceFileNameProvider.getTraceFromJava(sourceName);
        }
        if (sourceName.endsWith(".xtend")) {
            String name = type.getElementName();
            int index = name.indexOf("$");
            if (index > 0) {
                name = name.substring(0, index);
            }
            return this.traceFileNameProvider.getTraceFromJava(String.valueOf(name) + ".java");
        }
        return null;
    }

    protected IPath getSourcePath(ITypeRoot derivedJavaType) {
        IJavaElement current = derivedJavaType.getParent();
        while (current != null) {
            if (current instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)current;
                try {
                    IPath attachmentPath = fragmentRoot.getSourceAttachmentPath();
                    if (attachmentPath != null) {
                        return attachmentPath;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                if (current instanceof JarPackageFragmentRoot) {
                    return fragmentRoot.getPath();
                }
            }
            current = current.getParent();
        }
        return null;
    }

    protected boolean isZipFile(IPath path) {
        if (path.getFileExtension() == null) {
            return false;
        }
        String ext = path.getFileExtension();
        return "jar".equalsIgnoreCase(ext) || "zip".equalsIgnoreCase(ext);
    }

    public ITrace getTraceToSource(ITypeRoot derivedJavaType) {
        if (this.lruCache != null && ((ITypeRoot)this.lruCache.getFirst()).equals(derivedJavaType)) {
            return (ITrace)this.lruCache.getSecond();
        }
        ITrace trace = this.createTraceToSource(derivedJavaType);
        if (derivedJavaType.isReadOnly()) {
            this.lruCache = Tuples.create((Object)derivedJavaType, (Object)trace);
        }
        return trace;
    }

    private ITrace createTraceToSource(ITypeRoot derivedJavaType) {
        if (derivedJavaType instanceof IClassFile) {
            return this.getTraceToSource((IClassFile)derivedJavaType);
        }
        if (derivedJavaType instanceof ICompilationUnit) {
            return this.getTraceToSource((ICompilationUnit)derivedJavaType);
        }
        throw new IllegalStateException("Unknown type " + derivedJavaType);
    }

    public ITrace getTraceToSource(ICompilationUnit javaFile) {
        try {
            IResource resource = javaFile.getUnderlyingResource();
            if (resource instanceof IStorage) {
                return this.traceForStorageProvider.getTraceToSource((IStorage)resource);
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e);
        }
        return null;
    }

    public ITrace getTraceToSource(final IClassFile classFile) {
        AbstractTrace trace1;
        IPath sourcePath = this.getSourcePath((ITypeRoot)classFile);
        if (sourcePath == null) {
            return null;
        }
        IProject project = classFile.getJavaProject().getProject();
        if (this.isZipFile(sourcePath)) {
            ZipFileAwareTrace zipFileAwareTrace = (ZipFileAwareTrace)this.zipFileAwareTraceProvider.get();
            zipFileAwareTrace.setProject(project);
            zipFileAwareTrace.setZipFilePath(sourcePath);
            trace1 = zipFileAwareTrace;
        } else {
            FolderAwareTrace folderAwareTrace = (FolderAwareTrace)this.folderAwareTraceProvider.get();
            folderAwareTrace.setProject(project);
            folderAwareTrace.setRootFolder(sourcePath.toString());
            trace1 = folderAwareTrace;
        }
        final AbstractTrace result = trace1;
        result.setTraceRegionProvider(new ITraceRegionProvider(){

            public AbstractTraceRegion getTraceRegion() {
                block7: {
                    AbstractTraceRegion abstractTraceRegion;
                    String traceSimpleFileName = TraceForTypeRootProvider.this.getTraceSimpleFileName((ITypeRoot)classFile);
                    if (traceSimpleFileName == null) {
                        return null;
                    }
                    String pathInFragmentRoot = TraceForTypeRootProvider.this.getPathInFragmentRoot((ITypeRoot)classFile);
                    URI traceURI = URI.createURI((String)(String.valueOf(pathInFragmentRoot) + traceSimpleFileName));
                    InputStream contents = result.getContents(traceURI, result.getLocalProject());
                    if (contents == null) break block7;
                    try {
                        abstractTraceRegion = TraceForTypeRootProvider.this.traceRegionSerializer.readTraceRegionFrom(contents);
                    }
                    catch (Throwable throwable) {
                        try {
                            contents.close();
                            throw throwable;
                        }
                        catch (CoreException e) {
                            log.error((Object)e);
                            break block7;
                        }
                        catch (IOException e) {
                            log.error((Object)e);
                        }
                    }
                    contents.close();
                    return abstractTraceRegion;
                }
                return null;
            }
        });
        return result;
    }
}

