/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.xtext.ui.editor.embedded.ActionActivationCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivationCodeTrigger
implements VerifyKeyListener {
    private List<ActionActivationCode> activationCodes;
    private Map<String, IAction> actions;

    public ActivationCodeTrigger(Map<String, IAction> actions, List<ActionActivationCode> activationCodes) {
        this.actions = actions;
        this.activationCodes = activationCodes;
    }

    public void verifyKey(VerifyEvent event) {
        ActionActivationCode code = null;
        int size = this.activationCodes.size();
        int i = 0;
        while (i < size) {
            IAction action;
            code = this.activationCodes.get(i);
            if (code.matches(event) && (action = this.actions.get(code.fActionId)) != null) {
                if (action instanceof IUpdate) {
                    ((IUpdate)action).update();
                }
                if (!action.isEnabled() && action instanceof IReadOnlyDependent) {
                    IReadOnlyDependent dependent = (IReadOnlyDependent)action;
                    boolean writable = dependent.isEnabled(true);
                    if (writable) {
                        event.doit = false;
                        return;
                    }
                } else if (action.isEnabled()) {
                    event.doit = false;
                    action.run();
                    return;
                }
            }
            ++i;
        }
    }
}

